import random
from collections import defaultdict
from glob import glob

sample_size = 500

files = defaultdict(list)

for fn in glob('means/*.mean'):
	pn = fn.partition('/')[2].partition('_')[0]
	files[pn].append(fn)

multiple = [key for key in files if len(files[key])>1]


with open('good_fits.txt', 'w') as f:
	for key in random.sample(multiple, sample_size):
		a, b = random.sample(files[key], 2)
		print(a, b, file=f)

with open('bad_fits.txt', 'w') as f:
	positions = random.sample(list(files.values()), sample_size*2)
	x = [random.choice(a) for a in positions]
	q = x[::2]
	w = x[1::2]
	for i, j in zip(q, w):
		print(i, j, file=f)


