package MainPackage;

import javax.swing.*;
import symMetricFiles.*;
import symMetricStrings.*;

import java.awt.*;
import java.awt.event.*;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class Gui implements ActionListener {

	JFrame frame;
	JPanel pane1;
	JPanel pane2;
	ImageIcon icon = new ImageIcon();
	JTabbedPane tabbedpane;

	JButton btncompare_p1;
	JRadioButton but1_p1;
	JRadioButton but2_p1;
	JRadioButton but3_p1;
	JRadioButton but4_p1;
	JRadioButton but5_p1;
	JRadioButton but6_p1;
	
	JRadioButton but8_p1;
	JRadioButton but9_p1;
	JRadioButton but10_p1;
	JRadioButton but11_p1;
	JRadioButton but12_p1;
	JRadioButton but13_p1;
	JRadioButton but14_p1;
	JCheckBox check_p1;
	JTextField string1;
	JTextField string2;

	JButton btncompare_p2;
	JFileChooser fc1;
	JTextArea namef1_p2;
	JFileChooser fc2;
	JTextArea namef2_p2;
	JButton but1_p2;
	JButton but2_p2;
	JRadioButton but3_p2;
	JRadioButton but4_p2;
	JRadioButton but5_p2;
	JRadioButton but6_p2;
	JRadioButton but7_p2;
	JRadioButton but8_p2;
	JRadioButton but9_p2;
	JRadioButton but10_p2;
	JCheckBox check_p2;
	JCheckBox check2_p2;
	File file1;
	File file2;

	String s1 = new String("");
	String s2 = new String("");
	boolean NORMALISED = true;
	boolean FILENORMALISED = true;
	boolean ADJUST = true;
	StringMetric s_metric = new BlockDist(NORMALISED);
	FileMetric f_metric = new DiceFile(FILENORMALISED);
	boolean pair_comp;

	public Gui() {

		// Create and set up the window.
		frame = new JFrame("Similarity Metrics");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		pane1 = new JPanel(new GridLayout(0, 2, 5, 5));
		pane2 = new JPanel(new GridLayout(0, 2, 5, 5));

		createComponentsPane1();
		createComponentsPane2();
		tabbedpane = new JTabbedPane();
		tabbedpane.addTab("String Comparison", icon, pane1,
				"Compares tvo strings");
		tabbedpane.setMnemonicAt(0, KeyEvent.VK_1);
		tabbedpane.addTab("Text Comparison", icon, pane2, "Compares two texts");
		tabbedpane.setMnemonicAt(1, KeyEvent.VK_1);

		frame.getContentPane().add(tabbedpane, BorderLayout.CENTER);

		// Display the window.
		frame.pack();
		frame.setLocationRelativeTo(null);
		frame.setVisible(true);
		
		pair_comp = false;

	}

	private void createComponentsPane1() {

		btncompare_p1 = new JButton("Compare");
		btncompare_p1.addActionListener(this);

		string1 = new JTextField(15);
		string1.addActionListener(this);

		JLabel labelstring1 = new JLabel("  String1", JLabel.LEFT);
		labelstring1.setVerticalTextPosition(JLabel.CENTER);
		labelstring1.setHorizontalTextPosition(JLabel.RIGHT);

		string2 = new JTextField(15);
		string2.addActionListener(this);

		JLabel labelstring2 = new JLabel("  String2", SwingConstants.LEFT);

		but1_p1 = new JRadioButton("BlockDistance");
		but1_p1.setMnemonic(KeyEvent.VK_B);
		but1_p1.setActionCommand("Block Distance");
		but1_p1.setSelected(true);

		but2_p1 = new JRadioButton("Dice Distance");
		but2_p1.setMnemonic(KeyEvent.VK_B);
		but2_p1.setActionCommand("Dice Distance");

		but3_p1 = new JRadioButton("Hamming Distance");
		but3_p1.setMnemonic(KeyEvent.VK_B);
		but3_p1.setActionCommand("Hamming Distance");

		but4_p1 = new JRadioButton("Jaro Distance");
		but4_p1.setMnemonic(KeyEvent.VK_B);
		but4_p1.setActionCommand("Jaro Distance");

		but5_p1 = new JRadioButton("Jaro - Winkler Distance");
		but5_p1.setMnemonic(KeyEvent.VK_B);
		but5_p1.setActionCommand("Jaro - Winkler Distance");

		but6_p1 = new JRadioButton("Levenstein Distance");
		but6_p1.setMnemonic(KeyEvent.VK_B);
		but6_p1.setActionCommand("Levenstein Distance");

		but8_p1 = new JRadioButton("Needleman Distance");
		but8_p1.setMnemonic(KeyEvent.VK_B);
		but8_p1.setActionCommand("Needleman Distance");

		but9_p1 = new JRadioButton("Smith - Waterman Distance");
		but9_p1.setMnemonic(KeyEvent.VK_B);
		but9_p1.setActionCommand("Smith - Waterman Distance");

		but10_p1 = new JRadioButton("Compare using all");
		but10_p1.setMnemonic(KeyEvent.VK_B);
		but10_p1.setActionCommand("Compare using all");


		but11_p1 = new JRadioButton("Localized dist");
		but11_p1.setMnemonic(KeyEvent.VK_B);
		but11_p1.setActionCommand("Localized dist");

		but12_p1 = new JRadioButton("Pair comparison");
		but12_p1.setMnemonic(KeyEvent.VK_B);
		but12_p1.setActionCommand("Pair comparison");
		
		but13_p1 = new JRadioButton("Ideal Distance");
		but13_p1.setMnemonic(KeyEvent.VK_B);
		but13_p1.setActionCommand("Ideal Distance");
		
		but14_p1 = new JRadioButton("Ngram Distance");
		but14_p1.setMnemonic(KeyEvent.VK_B);
		but14_p1.setActionCommand("Ngram Distance");
		
		check_p1 = new JCheckBox("Use normalised metrics");
		check_p1.setMnemonic(KeyEvent.VK_G);
		check_p1.setSelected(true);

		ButtonGroup group_p1 = new ButtonGroup();
		group_p1.add(but1_p1);
		group_p1.add(but2_p1);
		group_p1.add(but3_p1);
		group_p1.add(but4_p1);
		group_p1.add(but5_p1);
		group_p1.add(but6_p1);
		
		group_p1.add(but8_p1);
		group_p1.add(but9_p1);
		group_p1.add(but10_p1);
		group_p1.add(but11_p1);
		group_p1.add(but12_p1);
		group_p1.add(but13_p1);
		group_p1.add(but14_p1);

		but1_p1.addActionListener(this);
		but2_p1.addActionListener(this);
		but3_p1.addActionListener(this);
		but4_p1.addActionListener(this);
		but5_p1.addActionListener(this);
		but6_p1.addActionListener(this);
		
		but8_p1.addActionListener(this);
		but9_p1.addActionListener(this);
		but10_p1.addActionListener(this);
		but11_p1.addActionListener(this);
		but12_p1.addActionListener(this);
		but13_p1.addActionListener(this);
		but14_p1.addActionListener(this);

		check_p1.addActionListener(this);

		pane1.add(btncompare_p1);
		pane1.add(check_p1);
		pane1.add(string1);
		pane1.add(labelstring1);
		pane1.add(string2);
		pane1.add(labelstring2);
		pane1.add(but1_p1);
		pane1.add(but2_p1);
		pane1.add(but3_p1);
		pane1.add(but4_p1);
		pane1.add(but5_p1);
		pane1.add(but6_p1);
	
		pane1.add(but8_p1);
		pane1.add(but9_p1);
		pane1.add(but10_p1);
		pane1.add(but11_p1);
		pane1.add(but12_p1);
		pane1.add(but13_p1);
		pane1.add(but14_p1);
		pane1.setBorder(BorderFactory.createEmptyBorder(30, 30, 10, 30));

	}

	private void createComponentsPane2() {

		btncompare_p2 = new JButton("Compare");
		btncompare_p2.addActionListener(this);
		
		check_p2 = new JCheckBox("Use normalised metrics");
		check_p2.setMnemonic(KeyEvent.VK_G);
		check_p2.setSelected(true);

		check2_p2 = new JCheckBox("Use adjusted metrics");
		check2_p2.setMnemonic(KeyEvent.VK_G);
		check2_p2.setSelected(true);

		
		
		JLabel emptylabel6 = new JLabel();
		JLabel emptylabel7 = new JLabel();
		JLabel emptylabel8 = new JLabel();
		JLabel emptylabel9 = new JLabel();
		JLabel emptylabel10 = new JLabel();
		JLabel emptylabel11 = new JLabel();
		JLabel emptylabel12 = new JLabel();

		namef1_p2 = new JTextArea(1, 1);
		namef1_p2.setMargin(new Insets(5, 5, 5, 5));
		namef1_p2.setEditable(false);
		namef1_p2.setMaximumSize(new Dimension(200, 20));
		
		

		but1_p2 = new JButton("Choose file1");
		but1_p2.addActionListener(this);

		fc1 = new JFileChooser();

		namef2_p2 = new JTextArea(1, 1);
		namef2_p2.setMargin(new Insets(5, 5, 5, 5));
		namef2_p2.setEditable(false);
		namef2_p2.setMaximumSize(new Dimension(200, 20));

		but2_p2 = new JButton("Choose file2");
		but2_p2.addActionListener(this);

		fc2 = new JFileChooser();

		but3_p2 = new JRadioButton("Monge Elkan recursive");
		but3_p2.setMnemonic(KeyEvent.VK_B);
		but3_p2.setActionCommand("Monge Elkan recursive");

		but4_p2 = new JRadioButton("Dice Distance");
		but4_p2.setMnemonic(KeyEvent.VK_B);
		but4_p2.setActionCommand("Dice Distance");

		but5_p2 = new JRadioButton("MyMetric Distance");
		but5_p2.setMnemonic(KeyEvent.VK_B);
		but5_p2.setActionCommand("MyMetric Distance");
		
		but6_p2 = new JRadioButton("HashFile Distance");
		but6_p2.setMnemonic(KeyEvent.VK_B);
		but6_p2.setActionCommand("HashFile Distance");
		
		but7_p2 = new JRadioButton("Complete comparison");
		but7_p2.setMnemonic(KeyEvent.VK_B);
		but7_p2.setActionCommand("Complete comparison");

		but8_p2 = new JRadioButton("Localized metric");
		but8_p2.setMnemonic(KeyEvent.VK_B);
		but8_p2.setActionCommand("Localized metric");
		
		but9_p2 = new JRadioButton("Ideal metric");
		but9_p2.setMnemonic(KeyEvent.VK_B);
		but9_p2.setActionCommand("Ideal metric");
		
		ButtonGroup group_p2 = new ButtonGroup();
		group_p2.add(but3_p2);
		group_p2.add(but4_p2);
		group_p2.add(but5_p2);
		group_p2.add(but6_p2);
		group_p2.add(but7_p2);
		group_p2.add(but8_p2);
		group_p2.add(but9_p2);
				

		check_p2.addActionListener(this);
		check2_p2.addActionListener(this);
		but3_p2.addActionListener(this);
		but4_p2.addActionListener(this);
		but5_p2.addActionListener(this);
		but6_p2.addActionListener(this);
		but7_p2.addActionListener(this);
		but8_p2.addActionListener(this);
		but9_p2.addActionListener(this);

		pane2.add(btncompare_p2);
		
		
		pane2.add(check_p2);
		pane2.add(emptylabel6);
		pane2.add(check2_p2);
		pane2.add(namef1_p2);
		pane2.add(but1_p2);
		pane2.add(namef2_p2);
		pane2.add(but2_p2);
		pane2.add(but3_p2);
		pane2.add(but4_p2);
		pane2.add(but5_p2);
		pane2.add(but6_p2);
		pane2.add(but7_p2);
		pane2.add(but8_p2);
		pane2.add(but9_p2);
		
		
		//pane2.add(emptylabel5);
	
		pane2.add(emptylabel7);
		pane2.add(emptylabel8);
		pane2.add(emptylabel9);
		pane2.add(emptylabel10);
		pane2.add(emptylabel11);
		pane2.add(emptylabel12);
		pane2.setBorder(BorderFactory.createEmptyBorder(30, 30, 10, 30));

	}

	private static void createAndShowGUI() {

		JFrame.setDefaultLookAndFeelDecorated(true);
		new Gui();
	}

	public void actionPerformed(ActionEvent e) {

		CompString cs;
		CompFile cf;
		PairComparison pc;
		pc = new PairComparison(NORMALISED);
		Integer tolerance = null;
		
		StringMetric secondary_metric;

		Object x = e.getSource();
		double result = 0;

		
		if (x.equals(but1_p1)) {
			pair_comp = false;
			s_metric = new BlockDist(NORMALISED);
		}	
		else if (x.equals(but2_p1)) {
			pair_comp = false;
			s_metric = new DiceDist(NORMALISED);
		}	
		else if (x.equals(but3_p1)) {
			s_metric = new HammingDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but4_p1)) {
			s_metric = new JaroDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but5_p1)) {
			s_metric = new JaroWinklerDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but6_p1)) {
			s_metric = new LevensteinDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but8_p1)) {
			s_metric = new NeedleDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but9_p1)) {
			s_metric = new SmithWDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but10_p1)) {
			s_metric = null;
			pair_comp = false;
		}	
		else if (x.equals(but11_p1)) {
			s_metric = new LocalizedDist(NORMALISED);
			pair_comp = false;
		}	
		else if (x.equals(but12_p1)) {
			pair_comp = true;
			s_metric = null;
			ChooseFile1();
			
		}
		else if (x.equals(but13_p1)) {
			s_metric = new IdealDist(NORMALISED);
			pair_comp = false;
			
		}
		
		else if (x.equals(but14_p1)) {
			int ngrams = ShowNgramChoice();
			s_metric = new NgramDist(ngrams, NORMALISED);
			pair_comp = false;
			
		}
		else if (x.equals(check_p1)) {
			if(s_metric!=null) {
				s_metric.setNormalized(!NORMALISED);
			}
			NORMALISED = !NORMALISED;
		}	

		else if (x.equals(but1_p2)) 
			ChooseFile1();
		else if (x.equals(but2_p2))
			ChooseFile2();
		
		// MErecursice
		else if (x.equals(but3_p2)) {
			secondary_metric = ShowMetricChoice();
			f_metric = new MErecursive(secondary_metric, FILENORMALISED);
		}
		//Dice FILE
		else if (x.equals(but4_p2)) {
			f_metric = new DiceFile(FILENORMALISED);

		} 
		//My Metric File
		else if (x.equals(but5_p2)) {
			secondary_metric = ShowMetricChoice();
			tolerance = ShowToleranceChoice();
			f_metric = new MyMetricFile(tolerance, secondary_metric, FILENORMALISED);
		}
		//Hash file
		 else if (x.equals(but6_p2)) {
				f_metric = new HashFile(FILENORMALISED);
			}
		//Complete Comparison
		 else if(x.equals(but7_p2)) {
			 	f_metric = new CompleteComparison(FILENORMALISED);
		 }
		//Localized File
		 else if(x.equals(but8_p2)) {
			 	f_metric = new LocalizedMetric(FILENORMALISED);
		 }
		//Ideal metric File
		 else if(x.equals(but9_p2)) {
			 	f_metric = new IdealFile(FILENORMALISED);
		 }
		//change of state of normaliser
		else if (x.equals(check_p2)) {
			if(f_metric!=null) {
				f_metric.setNormalized(!FILENORMALISED);
			}
			FILENORMALISED = !FILENORMALISED;
		}	
		else if (x.equals(check2_p2)) {
			
			ADJUST = !ADJUST;
		}	
		//compare button on pane 1 was pressed
		if (x.equals(btncompare_p1)) {
			s1 = string1.getText();
			s2 = string2.getText();
			if(pair_comp==true) {
				if(file1!=null) {
							
					pc.compare_pairs(file1);
					
				}	
				
			}
			else if ((s1.isEmpty()) || (s2.isEmpty())) {
				JOptionPane.showMessageDialog(pane1, "Enter both strings");
			} 
			else {
				if (s_metric != null) {

					cs = new CompString(s_metric, s1, s2);
					result = cs.traverse();
				
						if (result != -1)
						JOptionPane.showMessageDialog(pane1, "Similarity: "
								+ Double.toString(result));
					s1 = null;
					s2 = null;
				} 
				else if(pair_comp==false) {
					// using all metrics
					File log = new File("log.txt");
					FileWriter fwrite;

					try {
						fwrite = new FileWriter(log);

						cs = new CompString(new BlockDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("Block Distance "
								+ Double.toString(result) + "\n");

						cs = new CompString(new DiceDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("Dice Distance " + Double.toString(result)
								+ "\n");

						cs = new CompString(new HammingDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("Hamming Distance "
								+ Double.toString(result) + "\n");

						cs = new CompString(new JaroDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("Jaro Distance " + Double.toString(result)
								+ "\n");

						cs = new CompString(new JaroWinklerDist(NORMALISED, ADJUST),
								s1, s2);
						result = cs.traverse();
						fwrite.write("JaroWinkler Distance "
								+ Double.toString(result) + "\n");

						cs = new CompString(new LevensteinDist(NORMALISED, ADJUST), s1,
								s2);
						result = cs.traverse();
						fwrite.write("Levenstein Distance "
								+ Double.toString(result) + "\n");
						
						cs = new CompString(new LocalizedDist(NORMALISED, ADJUST), s1,
								s2);
						result = cs.traverse();
						fwrite.write("Localized Distance "
								+ Double.toString(result) + "\n");
						
						cs = new CompString(new NeedleDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("Needle Distance "
								+ Double.toString(result) + "\n");
						
						cs = new CompString(new NgramDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("Ngram Distance "
								+ Double.toString(result) + "\n");

						cs = new CompString(new SmithWDist(NORMALISED, ADJUST), s1, s2);
						result = cs.traverse();
						fwrite.write("SmithWaterman Distance "
								+ Double.toString(result) + "\n");

						fwrite.close();
					} catch (IOException e1) {

						e1.printStackTrace();
						ShowMessage("Cannot write to file");

					}

				}
				
			}
			
		} 
		//compare button on pane 2 was pressed
		else if (x.equals(btncompare_p2)) {

			if (file1 != null && file2 != null) {
				// test if file1 and file2 are text files
				/*
				 * 
				 * TO DO
				 * 
				 * 
				 */
				Class<?> c = (f_metric.getClass());
				if(c.isInstance(new MErecursive(null, true)))
				{	//it is instance of MErecursive and we want to compare it all
					if(f_metric.getMetric() == null)
					{
						//using all metrics
						
						File log_file_MErecursive = new File("log_file_MErecursive_indy.txt" );
						FileWriter fwrite;

						
							try {
								//log_file_MErecursive.createNewFile();
								fwrite = new FileWriter(log_file_MErecursive);
							
							
							f_metric.setMetric(new BlockDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							
							fwrite.write("ME recursive, secondary metric = BlockDist "
									+ Double.toString(result) );

						
							f_metric.setMetric(new DiceDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = DiceDist "
									+ Double.toString(result) );

							f_metric.setMetric(new HammingDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = HammingDist "
									+ Double.toString(result) );
							
							f_metric.setMetric(new IdealDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = IdealDist "
									+ Double.toString(result) );

							f_metric.setMetric(new JaroDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = JaroDist "
									+ Double.toString(result) );
							
							f_metric.setMetric(new JaroWinklerDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = JaroWinklerDist "
									+ Double.toString(result) );
							
							f_metric.setMetric(new LevensteinDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = LevensteinDist "
									+ Double.toString(result) );
							
								
							f_metric.setMetric(new LocalizedDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = LocalizedDist "
									+ Double.toString(result) );
							
							f_metric.setMetric(new NeedleDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = NeedleDist "
									+ Double.toString(result) );
							
							f_metric.setMetric(new NgramDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = NgramDist "
									+ Double.toString(result) );
							
							f_metric.setMetric(new SmithWDist(NORMALISED, ADJUST));
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
							fwrite.write("ME recursive, secondary metric = SmithWDist "
									+ Double.toString(result) );
							
							fwrite.close();
							
							} catch (IOException e1) {
								// TODO Auto-generated catch block
								e1.printStackTrace();
							}
						}
					else
					{
						//it is instance of MErecursive, but we want to compare it only using one
						//secondary metric, we do it here
						cf = new CompFile(f_metric, file1, file2);
						result = cf.traverse();

						if (result != -1)
							JOptionPane.showMessageDialog(pane2, "Similarity: "
									+ Double.toString(result));
						
					}
				}
				else 
				{
/***********************************************************************************************/	
					if(c.isInstance(new MyMetricFile()))
					{	//it is instance of MyMetricFile and we want to compare it all
						if(f_metric.getMetric() == null)
						{
							//using all metrics
							
							File log_file_MyMetric = new File("log_file_MyMetric_zlato.txt");
							FileWriter fwrite;

							
								try {
									fwrite = new FileWriter(log_file_MyMetric);
								
								
								f_metric.setMetric(new BlockDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								
								fwrite.write("MyMetric, secondary metric = BlockDist "
										+ Double.toString(result) );

							
								f_metric.setMetric(new DiceDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = DiceDist "
										+ Double.toString(result) );

								f_metric.setMetric(new HammingDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = HammingDist "
										+ Double.toString(result) );
								
								f_metric.setMetric(new IdealDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = IdealDist "
										+ Double.toString(result) );

								f_metric.setMetric(new JaroDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = JaroDist "
										+ Double.toString(result) );
								
								f_metric.setMetric(new JaroWinklerDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = JaroWinklerDist "
										+ Double.toString(result) );
								
								f_metric.setMetric(new LevensteinDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = LevensteinDist "
										+ Double.toString(result) );
								
									
								f_metric.setMetric(new LocalizedDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = LocalizedDist "
										+ Double.toString(result) );
								
								f_metric.setMetric(new NeedleDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = NeedleDist "
										+ Double.toString(result) );
								
								f_metric.setMetric(new NgramDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = NgramDist "
										+ Double.toString(result) );
								
								f_metric.setMetric(new SmithWDist(NORMALISED));
								cf = new CompFile(f_metric, file1, file2);
								result = cf.traverse();
								fwrite.write("MyMetric, secondary metric = SmithWDist "
										+ Double.toString(result) );
								
								fwrite.close();
								
								} catch (IOException e1) {
									// TODO Auto-generated catch block
									e1.printStackTrace();
								}
							}
						else {
							//compare using My Metric, but just one secondary metric
							cf = new CompFile(f_metric, file1, file2);
							result = cf.traverse();
		
							if (result != -1)
							{
								JOptionPane.showMessageDialog(pane2, "Similarity: "
									+ Double.toString(result));
							}
						}
					}
					
/***********************************************************************************************/					
					else {
						//it is instance of any other FileMetric
						
						cf = new CompFile(f_metric, file1, file2);
						result = cf.traverse();
	
						if (result != -1)
						{
							JOptionPane.showMessageDialog(pane2, "Similarity: "
								+ Double.toString(result));
						}
					}
				}
			}
		}
		

	}
	
	private int ShowNgramChoice() {
		int n = 0;
		Object[] possibilities = { "2", "3", "4", "5"};

		String s = (String) JOptionPane.showInputDialog(frame,
				"Choose Ngram size:\n", "Customized Dialog",
				JOptionPane.PLAIN_MESSAGE, icon, possibilities, "3");

		if ((s != null) && (s.length() > 0)) {

			if (s == "2")
				n = 2;
			else if (s == "3")
				n = 3;
			else if (s == "4")
				n = 4;
			else if (s == "5")
				n = 5;
			else n = 3;
		}
		return n;
	}

	private int ShowToleranceChoice() {
		int tolerance = 0;
		Object[] possibilities = { "0", "1", "5", "10", "50", "100",
				"whole document" };

		String s = (String) JOptionPane.showInputDialog(frame,
				"Choose tolerance:\n", "Customized Dialog",
				JOptionPane.PLAIN_MESSAGE, icon, possibilities, "0");

		if ((s != null) && (s.length() > 0)) {

			if (s == "0")
				tolerance = 0;
			else if (s == "1")
				tolerance = 1;
			else if (s == "5")
				tolerance = 5;
			else if (s == "10")
				tolerance = 10;
			else if (s == "50")
				tolerance = 50;
			else if (s == "100")
				tolerance = 100;
			else
				tolerance = -1; // tolerance should be the whole document

		}
		return tolerance;
	}

	private StringMetric ShowMetricChoice() {

		StringMetric secondary_metric = null;

		Object[] possibilities = { "Block Distance", "Dice Distance", "Ideal Distance", 
				"Hamming Distance", "Jaro Distance", "Jaro - Winkler Distance",
				"Levenstein Distance", "Localized Distance", "Ngram Distance",
				"Needle Distance", "Smith - Waterman Distance", "Compare using all"};

		String s = (String) JOptionPane.showInputDialog(frame,
				"Choose secondary distance:\n", "Customized Dialog",
				JOptionPane.PLAIN_MESSAGE, icon, possibilities,
				"Block Distance");

		if ((s != null) && (s.length() > 0)) {

			if (s == "Block Distance")
				secondary_metric = new BlockDist(NORMALISED, ADJUST);
			else if (s == "Dice Distance")
				secondary_metric = new DiceDist(NORMALISED, ADJUST);
			else if (s == "Hamming Distance")
				secondary_metric = new HammingDist(NORMALISED, ADJUST);
			else if (s == "Jaro Distance")
				secondary_metric = new JaroDist(NORMALISED, ADJUST);
			else if (s == "Jaro - Winkler Distance")
				secondary_metric = new JaroWinklerDist(NORMALISED, ADJUST);
			else if (s == "Levenstein Distance")
				secondary_metric = new LevensteinDist(NORMALISED, ADJUST);
			else if (s == "Ngram Distance")
				secondary_metric = new NgramDist(NORMALISED, ADJUST);
			else if (s == "Needle Distance")
				secondary_metric = new NeedleDist(NORMALISED, ADJUST);
			else if (s == "Smith - Waterman Distance")
				secondary_metric = new SmithWDist(NORMALISED, ADJUST);
			else if (s == "Compare using all")
				secondary_metric = null;
			else if (s == "Localized Distance")
				secondary_metric = new LocalizedDist(NORMALISED, ADJUST);
			else if (s == "Ideal Distance")
				secondary_metric = new IdealDist(NORMALISED, ADJUST);
			return secondary_metric;
		} else
			return null;
	}

	private void ChooseFile1() {

		int returnVal = fc1.showOpenDialog(pane2);
		
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			file1 = fc1.getSelectedFile();
			
			namef1_p2.setText("Opening: " + file1.getName() + "." + "\n");
		} else {
			namef1_p2.setText("Open command cancelled by user." + "\n");
		}

		namef1_p2.setCaretPosition(namef1_p2.getDocument().getLength());

	}

	private void ChooseFile2() {

		int returnVal = fc2.showOpenDialog(pane2);
		namef2_p2.append("\n");
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			file2 = fc2.getSelectedFile();

			namef2_p2.setText("Opening: " + file2.getName() + "." + "\n");
		} else {
			namef1_p2.setText("Open command cancelled by user." + "\n");
		}
		namef2_p2.setCaretPosition(namef2_p2.getDocument().getLength());

	}

	public static void ShowMessage(String s) {
		System.out.println(s);
	}

	public static void main(String[] args) {

		createAndShowGUI();

	}
}
