package MainPackage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

import symMetricFiles.FileMetric;
import symMetricStrings.*;

public class StringMetricComparison {
	
	
	private StringMetric metric;
	private FileReader fread1, fread2;
	private File in = new File("strings.txt");
	private File out = new File("strings_log.txt");
	private FileWriter fwrite;
	
	private LinkedList<String> file1 = new LinkedList<String>();
	
	private LinkedList<String> file2 = new LinkedList<String>();
	
	public StringMetricComparison()
	{
		try {
			fread1 = new FileReader(in);
			fread2 = new FileReader(in);
			fwrite = new FileWriter(out);
		} catch (FileNotFoundException e) {
			
			e.printStackTrace();
			System.out.println("File Not Found");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		metric = null;
		
		ReadFiles();
		try {
		
			fwrite.write("Block Dist\n");
			metric = new BlockDist(true);
			CompareStrings();
			fwrite.write("DiceDist\n");
			metric = new DiceDist(true);
			CompareStrings();
			fwrite.write("HammingDist\n");
			metric = new HammingDist(true);
			CompareStrings();
			fwrite.write("JaroDist\n");
			metric = new JaroDist(true);
			CompareStrings();
			fwrite.write("JaroWinklerDist\n");
			metric = new JaroWinklerDist(true);
			CompareStrings();
			fwrite.write("LevensteinDist\n");
			metric = new LevensteinDist(true);
			CompareStrings();
			fwrite.write("SmithWDist\n");
			
			metric = new SmithWDist(true);
			CompareStrings();
		} 
		catch (IOException e) 
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
			
		}
		try {
			fread1.close();
			fread2.close();
			fwrite.close();
		
		} 
		catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
	}
	
	
	private void ReadFiles() {

		int c = 0;
		Character ctmp;
		String s = new String("");
		String tmp = new String("");
		
		try {
			while ((c = fread1.read()) != -1) {
				if (c != ' ' && c != '\n') {
					ctmp = (char) c;
					tmp = ctmp.toString();
					s = s + tmp;
				} else {
					
					file1.add(s.trim());
					s = "";
				}

			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// ShowMessage("Cannot read from file1");
		}

		s = "";
		tmp = "";

		
		try {
			while ((c = fread2.read()) != -1) {
				if (c != ' ' && c != '\n') {

					ctmp = (char) c;
					tmp = ctmp.toString();
					s = s + tmp;

				} else {

					file2.add(s.trim());
					s = "";
				}

			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// ShowMessage("Cannot read from file2");
		}
		try {
			fread1.close();
			fread2.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}
	
	private void CompareStrings()
	{
		String s1, s2;
		double result;
		
		
		for(ListIterator<String> i = file1.listIterator(); i.hasNext();)
		{
			s1 = i.next();
			for(ListIterator<String> j = file2.listIterator(); j.hasNext();)
			{
				s2 = j.next();
				if((s1.length()!=0) && (s2.length()!=0))
				{
					result = metric.compare(s1,s2);
				}
				else 
				{
						return;
				}
				try {
				
					fwrite.write(s1 + " " + s2 + " " + Double.toString(result) + "\n");
				
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				
			}
		}
		
		
		try {
			fwrite.write("\n\n");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		
		StringMetricComparison c = new StringMetricComparison();
		// TODO Auto-generated method stub

	}

}
