package symMetricFiles;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;

import MainPackage.Gui;

public class CompFile {
	File f1, f2;
	FileMetric metric;
	FileReader fread1, fread2;
	LinkedList<String> file1 = new LinkedList<String>();
	LinkedList<String> file2 = new LinkedList<String>();

	public CompFile(FileMetric m) {

		metric = m;
		file1 = null;
		file2 = null;
	}

	public CompFile(FileMetric m, File textfile1, File textfile2) {

		metric = m;

		if (textfile1 == null || textfile2 == null || m == null) {

			Gui.ShowMessage("Path to files or metric is null");
			return;

		}

		File f1 = textfile1;
		File f2 = textfile2;

		try {
			fread1 = new FileReader(f1);
			fread2 = new FileReader(f2);
		} catch (FileNotFoundException e) {

			e.printStackTrace();
			Gui.ShowMessage("File Not Found");
		}

		ReadFiles();

	}

	private void ReadFiles() {

		int c = 0;
		Character ctmp;
		String s = new String("");
		String tmp = new String("");

		try {
			while ((c = fread1.read()) != -1) {
				if (c != ' ' && c != '\n') {
					
					ctmp = (char) c;
					tmp = ctmp.toString();
					s = s + tmp;
				} else {
					if((s.length()>1)) {
						//to get rid of diacritics
						
						while(!Character.isLetter(s.charAt(s.length()-1))) {
							
							s = s.substring(0, s.length()-1);
							if(s.length()==0) break;
						}
						if(s.length()>0) {
							while(!Character.isLetter(s.charAt(0))) {
								s = s.substring(1, s.length());
								if(s.length()==0) break;
							}
						}
						if(s.length()>0) {
							s = s.toLowerCase();
							file1.add(s.trim());
						}	
					}	
					
					s = "";
				}

			}
			if(!s.isEmpty()) {
				//to get rid of diacritics
				if(s.length()>0) {
					while(!Character.isLetter(s.charAt(s.length()-1))) {
						s = s.substring(0, s.length()-1);
						if(s.length()==0) break;	
					}
				}
				if(s.length()>0) {
					while(!Character.isLetter(s.charAt(0))) {
						s = s.substring(1, s.length());
						if(s.length()==0) break;
					}
				}	
				if(s.length()>0) {
					s = s.toLowerCase();
					file1.add(s.trim());
				}	
			}	
			
			s = "";
		
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// ShowMessage("Cannot read from file1");
		}
	
	
	
	
		s = "";
		tmp = "";

		try {
			while ((c = fread2.read()) != -1) {
				if (c != ' ' && c != '\n') {

					ctmp = (char) c;
					tmp = ctmp.toString();
					s = s + tmp;

				} else {
					if(s.length()>0) {
						//to get rid of diacritics
						while(!Character.isLetter(s.charAt(s.length()-1))) {
							s = s.substring(0, s.length()-1);
							if(s.length()==0) break;
						}
						if(s.length()>0) {
							while(!Character.isLetter(s.charAt(0))) {
								s = s.substring(1, s.length());
								if(s.length()==0) break;
								
							}
						}	
						if(s.length()>0) {
							s = s.toLowerCase();
							file2.add(s.trim());
						}	
					}	
					s = "";
				}
				
				
			}
			if(s.length()>0) {
				//to get rid of diacritics
				while(!Character.isLetter(s.charAt(s.length()-1))) {
					s = s.substring(0, s.length()-1);
					if(s.length()==0) break;
				}
				if(s.length()>0) {
					while(!Character.isLetter(s.charAt(0))) {
						s = s.substring(1, s.length());
						if(s.length()==0) break;
					}
				}	
				if(s.length()>0) {
					s = s.toLowerCase();
					file2.add(s.trim());
				}	
			}	
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// ShowMessage("Cannot read from file2");
		}
		try {
			fread1.close();
			fread2.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	public double traverse() {
		return metric.compare(file1, file2);
	}

	public void repair() {

	}
}
