package symMetricFiles;

import java.util.LinkedList;
import java.util.ListIterator;




public class DiceFile extends FileMetric {

	/*
	 * result = 2*number of common strings / (length of file1 + length of file2)
	 * if there are no common strings similarity = 0 if the files have all
	 * common strings but not necessarily in the same order, then similarity = 1
	 * 
	 */
	private double dist;
	private double norm_dist;
	private boolean NORMALISED;
	
	public double getDist() {
		return dist;
	}

	public void setDist(double dist) {
		this.dist = dist;
	}

	public double getNorm_dist() {
		return norm_dist;
	}

	public void setNorm_dist(double norm_dist) {
		this.norm_dist = norm_dist;
	}

	public DiceFile(boolean norm) {
		
		super(null);
		
		NORMALISED = norm;
				
	}

	public double compare(LinkedList<String> file1, LinkedList<String> file2) {

		int common_terms = 0;
		String tmp;
		dist = 0;
		norm_dist = 0;
		
		int length1, length2;
		length1 = file1.size();
		length2 = file2.size();

		for (ListIterator<String> i = file1.listIterator(); i.hasNext();) {

			tmp = i.next();
			
			if (file2.contains(tmp)) {

				common_terms++;
				file2.remove(tmp);
			}

		}

		dist = (double) 2 * common_terms / (length1 + length2);
		
		if (NORMALISED) {

			FileNormaliser fn = new FileNormaliser();
			fn.normalise(this);
			return norm_dist;
		} else {
			return dist;
		}
		
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}

}
