package symMetricFiles;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;

import symMetricStrings.StringMetric;

public class HashFile extends FileMetric {
	private double dist;
	private double norm_dist;
	private int length_of_file1;
	private int length_of_file2;
	
	private boolean NORMALISED;
	ArrayList<String> list1;
	ArrayList<Integer> indexes1;	
	ArrayList<String> list2;
	ArrayList<Integer> indexes2;
	
	public double getDist() {
		return dist;
		
	}

	public void setDist(double dist) {
		this.dist = dist;
	}

	public double getNormdist() {
		return norm_dist;
	}

	public void setNorm_dist(double normdist) {
		this.norm_dist = normdist;
	}

	public HashFile() {
		super(null);
		NORMALISED = true;
	}
	
	public HashFile(StringMetric m) {
		super(m);
		NORMALISED = true;
		
	}
	
	public HashFile(boolean norm) {
		super(null);
		NORMALISED = norm;
	}
	
	public HashFile(StringMetric m, boolean norm)
	{
		super(m);
		NORMALISED = norm;
	}
	
	@Override
	public double compare(LinkedList<String> file1, LinkedList<String> file2) {
		
		length_of_file1 = file1.size();
		length_of_file2 = file1.size();
		dist = 0;
		norm_dist = 0;
		
		createIndexFiles(file1, file2);
		dist = compareIndexes();
		if (NORMALISED) {

			FileNormaliser fn = new FileNormaliser();
			fn.normalise(this);
			return norm_dist;
		} else {
			return dist;
		}
	}
	private void createIndexFiles(LinkedList<String> file1, LinkedList<String> file2)
	{
			File index1, index2;
			index1 = new File("hashfile_index1.txt");
			index2 = new File("hashfile_index2.txt");
			FileWriter fwriter;
			String str;
			String hash = "";
			Set<Character> s1 = new HashSet<Character>();
			int value;
			
			list1 = new ArrayList<String>();
			indexes1 = new ArrayList<Integer>();
			
			list2 = new ArrayList<String>();
			indexes2 = new ArrayList<Integer>();
			
			
				s1.add('B');
				s1.add('P'); 
				s1.add('F'); 
				s1.add('V');
				

			Set<Character> s2 = new HashSet<Character>();
				s2.add('C');
				s2.add('S');					
				s2.add('K'); 
				s2.add('G'); 
				s2.add('J'); 
				s2.add('Q');
				s2.add('X');
				s2.add('Z');
				
			Set<Character> s3 = new HashSet<Character>();
				s3.add('D');
				s3.add('T'); 
			
			Set<Character> s4 = new HashSet<Character>();
				s4.add('L');	
			Set<Character> s5 = new HashSet<Character>();
				s5.add('M');
				s5.add('N');
			Set<Character> s6 = new HashSet<Character>();
				s6.add('R');

			Set<Character> s7 = new HashSet<Character>();
					s7.add('A');
					s7.add('E');
					s7.add('I');
					s7.add('O');
					s7.add('U');
					s7.add('Y');
							
			for(ListIterator<String> i = file1.listIterator(); i.hasNext();)	{
				
				str = i.next();
			
				str = str.toUpperCase();
				hash = "";
				
				for(int j = 0; j< str.length(); j++)	{
					//if there weren't two same characters one after another
					
					if((j==0) || ((j>0) && str.charAt(j)!=str.charAt(j-1)) && (!s7.contains(str.charAt(j))))	{	
					
						
						if(s1.contains(str.charAt(j)))	{
							hash = hash + '1';
						}
						else if(s2.contains(str.charAt(j)))	{
							hash = hash + '2';
						}
						else if(s3.contains(str.charAt(j)))	{
							hash = hash + '3';
						}
						else if(s4.contains(str.charAt(j)))	{
							hash = hash + '4';
						}
						else if(s5.contains(str.charAt(j)))	{
							hash = hash + '5';
						}
						else if(s6.contains(str.charAt(j)))	{
							hash = hash + '6';
						}
					}
					
					
					
				}
				
				
				
				//add to arraylist and change index
				
				if(list1.indexOf(hash)==-1)	{
					list1.add(hash);
					indexes1.add(1);
				}
				else	{
					value = list1.indexOf(hash);
					indexes1.set(value, indexes1.get(value) + 1);
				}
				
			}
			
			try {
				 fwriter = new FileWriter(index1);
			
			ListIterator<Integer> j = indexes1.listIterator();
			 for(ListIterator<String> i = list1.listIterator();i.hasNext();)	 {
				 fwriter.write(i.next() + " " + j.next() + "\n");
			 }
			 fwriter.close();
			 
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
			for(ListIterator<String> i = file2.listIterator(); i.hasNext();)	{
				str = i.next();
				
				hash = "";
				str = str.toUpperCase();
				
				for(int j = 0; j< str.length(); j++)	{
					
						
					if((j==0) || ((j>0) && str.charAt(j)!=str.charAt(j-1)) && (!s7.contains(str.charAt(j))))	{	
					
						if(s1.contains(str.charAt(j)))	{
							hash = hash + '1';
						}
						else if(s2.contains(str.charAt(j)))	{
							hash = hash + '2';
						}
						else if(s3.contains(str.charAt(j)))	{
							hash = hash + '3';
						}
						else if(s4.contains(str.charAt(j)))	{
							hash = hash + '4';
						}
						else if(s5.contains(str.charAt(j)))	{
							hash = hash + '5';
						}
						else if(s6.contains(str.charAt(j)))	{
							hash = hash + '6';
						}
					}
				}
				
			
				
				
				//add to arraylist and change the index
				
				if(list2.indexOf(hash)==-1)
				{
					list2.add(hash);
					indexes2.add(1);
				}
				else
				{
					value = list2.indexOf(hash);
					indexes2.set(value, indexes2.get(value) + 1);
				}
				
			}
			
			try {
				 fwriter = new FileWriter(index2);
			
			ListIterator<Integer> j = indexes2.listIterator();
			 for(ListIterator<String> i = list2.listIterator();i.hasNext();)
			 {
				 fwriter.write(i.next() + " " + j.next() + "\n");
			 }
			 fwriter.close();
			 
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			
		
	}
	private double compareIndexes()
	{
		double dist1 = 0;
		double dist2 = 0;
		String str;
		Integer value1, value2;
		Integer index;
		ListIterator<Integer> j1 = indexes1.listIterator();
		for(ListIterator<String> i1 = list1.listIterator(); i1.hasNext();) {
			str = i1.next();
			value1 = j1.next();
			if(list2.indexOf(str)!=-1) {
				index = list2.indexOf(str);
				value2 = indexes2.get(index);
				indexes2.set(index, value2);
				dist1 = dist1 + Math.abs(value1 - value2);
			}
			else {
				dist1 = dist1 + value1;
			}	
			
		}
		ListIterator<Integer> j2 = indexes2.listIterator();
		for(ListIterator<String> i2 = list2.listIterator(); i2.hasNext();) {
			str = i2.next();
			value2 = j2.next();
			if(list1.indexOf(str)!=-1) {
				index = list1.indexOf(str);
				value1 = indexes1.get(index);
				indexes1.set(index, value1);
				dist2 = dist2 + Math.abs(value1 - value2);
			}
			else {
				dist2 = dist2 + value2;
			}
		}
		
		//return the average of distance 1 and distance 2
		return (dist1 + dist2)/2;
		
	}

	public int getLength_of_file1() {
		return length_of_file1;
	}

	public int getLength_of_file2() {
		return length_of_file2;
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}
	
	
	
