package symMetricFiles;



import java.util.*;
import symMetricStrings.*;

public class IdealFile extends FileMetric {

	private StringMetric metric = null;
	private double dist;
	private double norm_dist;
	private boolean NORMALISED;
	private int length_of_file1;
	private int length_of_file2;

	public IdealFile(boolean norm) {
		super(null);
		NORMALISED = norm;
		metric = new IdealDist(true);
	}

	public double compare(LinkedList<String> file1, LinkedList<String> file2) {

		length_of_file1 = file1.size();
		length_of_file2 = file2.size();
		dist = 0;
		norm_dist = 0;
		boolean has_changed = false;
		double r = 0;
		double min = Double.MAX_VALUE;
		int index = 0;
		int index_i = 0;
		String s1, s2;
		this.setDist(0);
while(file1.size()!=0 || file2.size()!=0) {
		for (ListIterator<String> i = file1.listIterator(); i.hasNext();) {

			s1 = i.next();

			for (ListIterator<String> j = file2.listIterator(); j.hasNext();) {

				s2 = j.next();
				
				if(s1!=null && s2!=null && s1.length()!=0 && s2.length()!=0) 
				{	
					r = metric.compare(s1, s2);
				}	
				
				if (min > r) {
					has_changed = true;
					min = r;
					index = j.previousIndex();
					index_i = i.previousIndex();
				}
				
			}
		}
			if(has_changed) {
				dist = dist + min;
				has_changed = false;
			}	
			
			if (file2.size() != 0) {
				
				file2.remove(index);
			}
			if(file1.size() !=0) {
				file1.remove(index_i);
			}

			min = Double.MAX_VALUE;
			r = 0;
			index = 0;
			index_i = 0;
			
		}
		dist = dist + file2.size() + file1.size();
		//dist = (double) dist / file1.size();

		if (NORMALISED) {

			FileNormaliser fn = new FileNormaliser();
			fn.normalise(this);
			return norm_dist;
		} else {
			return dist;
		}
	}

	public double getDist() {
		return dist;
	}

	public void setDist(double dist) {
		this.dist = dist;
	}

	public double getNorm_dist() {
		return norm_dist;
	}

	public void setNorm_dist(double norm_dist) {
		this.norm_dist = norm_dist;
	}

	public StringMetric getMetric() {
		return metric;
	}

	public void setMetric(StringMetric metric) {
		this.metric = metric;
	}
	
	public int getLength_of_file1() {
		return length_of_file1;
	}

	public int getLength_of_file2() {
		return length_of_file2;
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}

