package symMetricFiles;

import java.util.LinkedList;

import symMetricStrings.LocalizedDist;
import symMetricStrings.StringMetric;

public class LocalizedMetric extends FileMetric {

	boolean NORMALISED;
	double dist;
	double norm_dist;
	int l1;
	int l2;
	public double getDist() {
		return dist;
	}
	public void setDist(double dist) {
		this.dist = dist;
	}
	public double getNorm_dist() {
		return norm_dist;
	}
	public void setNorm_dist(double norm_dist) {
		this.norm_dist = norm_dist;
	}
	public int getL1() {
		return l1;
	}
	public int getL2() {
		return l2;
	}
	public LocalizedMetric(StringMetric m) {
		super(m);
		// TODO Auto-generated constructor stub
		NORMALISED = true;
		dist = 0;
		norm_dist = 0;
		l1 = 0;
		l2 = 0;
	}
	public LocalizedMetric(StringMetric m, boolean norm) {
		super(m);
		// TODO Auto-generated constructor stub
		NORMALISED = norm;
		dist = 0;
		norm_dist = 0;
		l1 = 0;
		l2 = 0;
	}
	public LocalizedMetric(boolean norm) {
		super(new LocalizedDist());
		// TODO Auto-generated constructor stub
		NORMALISED = norm;
		dist = 0;
		norm_dist = 0;
		l1 = 0;
		l2 = 0;
	}
	
	@Override
	public double compare(LinkedList<String> file1, LinkedList<String> file2) {
		// TODO Auto-generated method stub
		l1 = file1.size();
		l2 = file2.size();
		
		dist = 0;
		norm_dist = 0;
		FileMetric m = new MErecursive(new LocalizedDist(true), true);
		return m.compare(file1, file2);
		
	}
	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}

}
