package symMetricStrings;

public class BlockDist extends StringMetric {
	
	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean NORMALISED;
	private boolean ADJUST;
	
	public BlockDist(boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public BlockDist(boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = adj;
	}
	
	
	
	/*
	 * Distance defined as a number of places on a grid 26* 26 (size of an alphabet)
	 * needed to route from a character in string1 to a corresponding character string2
	 * 
	 * If string1 equals string2, then distance = 0
	 * (non-Javadoc)
	 * @see symMetricStrings.StringMetric#Compare(java.lang.String, java.lang.String)
	 */
	
	public double getDist() {
		return dist;
	}
	
	public int getL1() {
		return length_s1;
	}
	
	public int getL2() {
		return length_s2;
	}
	
	public double getNDist() {
		return norm_dist;
	}
	
	public void setNDist(double value) {
		norm_dist = value;
	}
	
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
	}
	public double compare(String s1, String s2) {
	
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		length_s1 = s1.length();
		length_s2 = s2.length();
		int k = 0;
		int j = min(length_s1, length_s2);
		dist = 0;
		norm_dist = 0;
		s1 = replace_slovak_spelling(s1);
		s2 = replace_slovak_spelling(s2);
		
		for(int i=0; i<j;i++) 	{
		
				k = s1.charAt(i) - s2.charAt(i);		
				dist = dist + Math.abs(k);
				
			
		}
		if(length_s1>length_s2) {
			for(int i=j; i<length_s1; i++) {
				k = s1.charAt(i) - 'a'- 1;
				dist = dist + Math.abs(k);
				
			}	
		}
		else if(length_s2>length_s1) {
			for(int i=j; i<length_s2; i++) {
				k = s2.charAt(i) - 'a' -1;
				dist = dist + Math.abs(k);
				
			}
		}
			
		
				
		if (NORMALISED) {
			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}	
			
			return norm_dist;
		}	
		
		else return dist;
		
	}
	private String replace_slovak_spelling(String s)
	{
		s = s.replace('','a');
		s =s.replace('','a');
		s =s.replace('','e');
		s =s.replace('','i');
		s =s.replace('','o');
		s =s.replace('','o');
		s =s.replace('','u');
		s =s.replace('','y');
		s =s.replace('','c');
		s =s.replace('','d');
		s =s.replace('','l');
		s =s.replace('','l');
		s =s.replace('','n');
		s =s.replace('','s');
		s =s.replace('','t');
		s =s.replace('','z');
		
		return s;
	}
	private int min(int a, int b) {
		
		if(a>b) return b;
		else return a;
	}
	
	
}
