package symMetricStrings;

public class HammingDist extends StringMetric {

	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean NORMALISED;
	private boolean ADJUST;

	public HammingDist(boolean norm) {

		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = false;

	}
	
	public HammingDist(boolean norm, boolean adj) {

		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = adj;

	}

	/*
	 * Hamming distance (HammingDist) means number of bits, in which two binary
	 * strings differ Here it means number of characters in which two strings
	 * differ, it is suitable only for strings of the same length
	 * 
	 */

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		dist = 0;
		norm_dist = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();

		if (length_s1 != length_s2) {
			if (length_s1 < length_s2) {
				for (int i = 0; i < length_s2 - length_s1; i++)
					s1 += " ";
			} else {
				for (int i = 0; i < length_s1 - length_s2; i++)
					s2 += " ";
			}
		}

		for (int i = 0; i < s1.length(); i++) {

			if (s1.charAt(i) != s2.charAt(i))
				dist++;
		}

		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else
			return dist;

	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}