package symMetricStrings;

import java.util.List;
import java.util.LinkedList;

public class JaroDist extends StringMetric {

	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean NORMALISED;
	private boolean ADJUST;

	public JaroDist(boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public JaroDist(boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = adj;
	}

	/*
	 * Jaro Distance (JaroDist) is a distance that encounters number of common
	 * characters in string1 in respect to string2 and number of common
	 * characters in string2 in respect to string1 and the number of
	 * transposition in respect to string1 and string2 the formula takes into
	 * consideration these values together with lengths of string1 and string2
	 * 
	 * 
	 * (non-Javadoc)
	 * 
	 * @see symMetricStrings.StringMetric#Compare(java.lang.String,
	 *      java.lang.String)
	 */

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		dist = 0;

		length_s1 = s1.length();
		length_s2 = s2.length();
		norm_dist = 0;

		int com1 = 0;
		int com2 = 0;
		double transp = 0;

		com1 = findCommon(s1, s2);
		com2 = findCommon(s2, s1);
		transp = findTranspositions(s1, s2);
		if(com1!=0)
		{
			dist = (double) ((double) com1 / length_s1 + (double) com2 / length_s2 + (double) (com1 - transp)
				/ com1) / 3;
			
		}
		else
		{
			//if they do not have any common char but anyway we want to compare them
			
			
			
			
		}
		
		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else
			return dist;
	}
	private List<Character> StringToList(String s)
	{
		List<Character> list = new LinkedList<Character>();
		for(int i = 0; i< s.length(); i++)
		{
			list.add(s.charAt(i));		
		}
		
		return list;
	}
	private int findCommon(String s1, String s2) {

		// finds the number of common characters in s1, s2
		int num = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();
		int i, j;
				
		List<Character> l1;
		List<Character> l2;
		
		l1 = StringToList(s1);
		l2 = StringToList(s2);
		
		boolean found = false;
		
		int min_i = 0, min_j = 0;
		int min_dist;
		min_dist = max(length_s1, length_s2);
		
		for (i = 0; i < length_s1; i++) 
		{
				for(j = 0; j < length_s2; j++) {
					if((s1.charAt(i)==s2.charAt(j)) && (l1.contains(s1.charAt(i)) && l2.contains(s2.charAt(j)))) {
						if(min_dist > Math.abs(i-j)) {
							min_dist = Math.abs(i-j);
							min_i = i;
							min_j = j;
							found = true;
							
						}
						
					}
				}
				if((min_dist <= Math.floor(max(length_s1, length_s2)/2) -1)  && (found)) {
					
					l1.remove(l1.indexOf(s1.charAt(min_i)));
					l2.remove(l2.indexOf(s2.charAt(min_j)));
					num++;
					min_dist = max(length_s1, length_s2);
					
				}
				found = false;
				
		}

		return num;
	}
	private int min(int a, int b)
	{
		if(a<b) return a;
		else return b;
	}
	
	private int max(int a, int b) {
		if(a>b) return a;
		else return b;
	}

	private double findTranspositions(String s1, String s2) {

		double transpositions = 0;
		
		for(int i = 0; i< s1.length(); i++)
		{
			for(int j = 0; j< s2.length(); j++) {
				
				//to find transpositions
				if((i!=j) && (s1.charAt(i)==s2.charAt(j)) && (Math.abs(i-j) <= Math.floor(max(s1.length(), s2.length())/2) -1)) {
					if((j<s1.length() && (s1.charAt(j)!=s2.charAt(j))) || (i<s2.length() && (s1.charAt(i) !=s2.charAt(i)))) {
						transpositions ++;
						
					}
				}
			}
		}
		
		return transpositions/2;
	}

	public boolean isNORMALISED() {
		return NORMALISED;
	}

	public void setNORMALISED(boolean normalised) {
		NORMALISED = normalised;
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}
