package symMetricStrings;

import symMetricStrings.JaroDist;

public class JaroWinklerDist extends StringMetric {

	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean NORMALISED;
	private double prefixScale;
	private boolean ADJUST;

	public JaroWinklerDist(double PS, boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		prefixScale = PS;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public JaroWinklerDist(double PS, boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		prefixScale = PS;
		NORMALISED = norm;
		ADJUST = adj;
	}

	public JaroWinklerDist(boolean norm) {

		prefixScale = 0.1;
		// maybe there is different prefixScale needed
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public JaroWinklerDist(boolean norm, boolean adj) {

		prefixScale = 0.1;
		// maybe there is different prefixScale needed
		NORMALISED = norm;
		ADJUST = adj;
	}

	/*
	 * Jaro-Winkler Distance (JaroWinklerDist) is kind of Jaro Distace
	 * JaroDist.java it counts Jaro Distance but takes into consideration also
	 * the lengths of a common prefix
	 * 
	 * 
	 */
	
	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}

	

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		dist = 0;
		norm_dist = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();
		JaroDist JD = new JaroDist(NORMALISED);
		int prefixLength = 0;
		prefixLength = findPrefix(s1, s2);
		
		
		double jarodistance;
		if(JD.isNORMALISED())
		{
			JD.setNORMALISED(false);
			jarodistance = JD.compare(s1, s2);
			JD.setNORMALISED(true);
		}
		else
		{
			jarodistance = JD.compare(s1, s2);
		}
		
		dist = (jarodistance) + prefixLength * prefixScale * (1-jarodistance);
		// to 1- bolo v sources napisane ako 1.of co to znamena???

		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else
			return dist;
	}

	private int findPrefix(String s1, String s2) {

		// finds common prefix at the beginning of two strings
		int i = 0;
		int min_length = min(length_s1, length_s2);
		while ((i < min_length) && (s1.charAt(i) == s2.charAt(i)))
			i++;

		return i;
	}

	private int min(int a, int b) {
		if (a < b)
			return a;
		else
			return b;
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}
