package symMetricStrings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class LocalizedDist extends StringMetric {
	int tolerance1, tolerance2;
	double dist;
	double norm_dist;
	double weight_begin;
	double weight_end;
	boolean NORMALISED;
	int l1, l2;
	private boolean ADJUST;
	
	public LocalizedDist(boolean NORM) {
		// TODO Auto-generated constructor stub
		dist = 0;
		norm_dist = 0;
		tolerance1 = tolerance2 = 0;
		NORMALISED = NORM;
		l1 = l2 = 0;
		ADJUST = false;
		weight_begin = 1;
		weight_end = 0.2;
	}
	public LocalizedDist(boolean NORM, double wb, double we) {
		// TODO Auto-generated constructor stub
		dist = 0;
		norm_dist = 0;
		tolerance1 = tolerance2 = 0;
		NORMALISED = NORM;
		l1 = l2 = 0;
		ADJUST = false;
		weight_begin = wb;
		weight_end = we;
	}
	public LocalizedDist() {
		// TODO Auto-generated constructor stub
		dist = 0;
		norm_dist = 0;
		tolerance1 = tolerance2 = 0;
		NORMALISED = true;
		l1 = l2 = 0;
		ADJUST = false;
		weight_begin = 1;
		weight_end = 0.2;
	}
	public LocalizedDist(boolean NORM, boolean adj) {
		// TODO Auto-generated constructor stub
		dist = 0;
		norm_dist = 0;
		tolerance1 = tolerance2 = 0;
		NORMALISED = NORM;
		l1 = l2 = 0;
		ADJUST = adj;
		weight_begin = 1;
		weight_end = 0.2;
	}
	
	

	@Override
	public double compare(String s1, String s2) {

	//Find if suffix of the world can be found in the database of suffixes, then compare words
	//without suffixes and set tolerance = length of suffix	
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		int i;
		int min_s1_s2;
		double dist1, dist2;
		dist1 = dist2 = 0;
		l1 = s1.length();
		l2 = s2.length();
		dist = 0;
		norm_dist = 0;
		tolerance1 = tolerance2 = 0;
		
		//set min_s1_s2 as minimum length of string 1 and string 2
		if(l1<=l2)	{	
			min_s1_s2 = l1;
		}
		else {
			min_s1_s2 = l2;
		}
		
		//find out if suffix of string1 is in database
		//open the database
		File f = new File("suffixes.txt");
		FileReader freader = null;
		try {
			freader = new FileReader(f);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
		//what if c==EOF???
		int c;
		Character ctmp;
		String tmp = "";
		String suffix = "";
		String s = "";
		while(tolerance1 == 0 || tolerance2 == 0) {
			try {
				while ((c = freader.read()) != -1) {
					if (!Character.isWhitespace(c)) {
						
						ctmp = (char) c;
						
						
							tmp = ctmp.toString();						
							s = s + tmp;
							
							
						
					} else if (s!="" && s!=null){
						
						suffix = s;
						
						s = "";
					
						if (s1.endsWith(suffix) && tolerance1==0) {
							tolerance1 = suffix.length();
							//System.out.println(suffix);
						}
						if (s2.endsWith(suffix) && tolerance2==0) {
							tolerance2 = suffix.length();
							
							
						}
						if(tolerance1!=0 && tolerance2!=0) {
							break;
						}
						
					}
					
	
				}
				
				
			
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// ShowMessage("Cannot read from file1");
			}
			
			if(tolerance1==0) {
				tolerance1 = 3;
			}
			if(tolerance2==0) {
				tolerance2 = 3;
			}
			
			
		
		}
		
		//System.out.println(suffix_pos1 + " " + suffix_pos2);
		//find the suffixes and compare
		
		
		for(i = 0; i< l1; i++)			{
			if(i<l1 - tolerance1 && i<l2)		{
				if(s1.charAt(i)!=s2.charAt(i)) 	{
					dist1 = dist1 + weight_begin;
				}	
			}
			else if(i<l1 && i<l2){
				if(s1.charAt(i)!=s2.charAt(i)){
					dist1 = dist1 + weight_end;
				}	
			}
			else if(i<l1) {
				dist1 = dist1 + weight_end;
			}
		}
		for(i = 0; i< l2; i++)			{
			if(i<l2 - tolerance2 && i<l1)		{
				if(s1.charAt(i)!=s2.charAt(i)) 	{
					dist2 = dist2 + weight_begin;
				}	
			}
			else if(i<l1 && i<l2){
				if(s1.charAt(i)!=s2.charAt(i)){
					dist2 = dist2 + weight_end;
				}	
			}
			else if(i<l2) {
				dist2 = dist2 + weight_end;
			}
		}
	//	System.out.println(dist1 + " " + dist1/l1 + " " + dist2 + " " + dist2/l2);
		dist = (dist1 + dist2)/2;
		if(NORMALISED) {
			Normaliser n =new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		}
		else {
			return dist;
		}
				
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		// TODO Auto-generated method stub

	}
	public double getDist() {
		return dist;
	}
	public void setDist(double dist) {
		this.dist = dist;
	}
	public double getNDist() {
		return norm_dist;
	}
	public void setNDist(double norm_dist) {
		this.norm_dist = norm_dist;
	}
	public int getL1() {
		return l1;
	}
	public int getL2() {
		return l2;
	}
	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
	public double getWeight_begin() {
		return weight_begin;
	}
	public void setWeight_begin(double weight_begin) {
		this.weight_begin = weight_begin;
	}
	public double getWeight_end() {
		return weight_end;
	}
	public void setWeight_end(double weight_end) {
		this.weight_end = weight_end;
	}

}
