package symMetricStrings;

import java.util.LinkedList;
import java.util.ListIterator;

import symMetricFiles.FileNormaliser;

public class NgramDist extends StringMetric {

	private int size_of_ngrams;
	private boolean NORMALIZED;
	private LinkedList<String> ngrams1, ngrams2;
	private double dist;
	private double norm_dist;
	private int num_of_ngrams1, num_of_ngrams2;
	private boolean ADJUST;
	
	public NgramDist(int size_of_ngrams, boolean norm) {
		
		this.size_of_ngrams = size_of_ngrams;
		NORMALIZED = norm;
		num_of_ngrams1 = num_of_ngrams2 = 0;
		ADJUST = false;
	}
	public NgramDist(int size_of_ngrams, boolean norm, boolean adj) {
		
		this.size_of_ngrams = size_of_ngrams;
		NORMALIZED = norm;
		num_of_ngrams1 = num_of_ngrams2 = 0;
		ADJUST = adj;
	}
	
	public NgramDist(boolean norm) {
		
		this.size_of_ngrams = 3;
		NORMALIZED = norm;
		num_of_ngrams1 = num_of_ngrams2 = 0;
		ADJUST = false;
	}
	

	public NgramDist(boolean norm, boolean adj) {
		
		this.size_of_ngrams = 3;
		NORMALIZED = norm;
		num_of_ngrams1 = num_of_ngrams2 = 0;
		ADJUST = adj;
	}
	
	
	public NgramDist(int size_of_ngrams) {
		
		this.size_of_ngrams = size_of_ngrams;
		NORMALIZED = true;
		num_of_ngrams1 = num_of_ngrams2 = 0;
		ADJUST = false;
	}
	
	public NgramDist() {
		
		this.size_of_ngrams = 3;
		NORMALIZED = true;
		num_of_ngrams1 = num_of_ngrams2 = 0;
		ADJUST = false;
	}
	
	@Override
	public double compare(String s1, String s2) {
		String tmp;
		tmp = "";
		int i, j, k, l;
		ngrams1 = new LinkedList();
		ngrams2 = new LinkedList();
		dist = 0;
		norm_dist = 0;
		
		num_of_ngrams1 = s1.length() + size_of_ngrams -1;
		num_of_ngrams2 = s2.length() + size_of_ngrams -1;
		
		//separate s1 into n grams
		for(i = 0; i<=s1.length(); i++) {
			j = i;
			if(i<size_of_ngrams-1) {
				for(j = i; j<size_of_ngrams-1; j++) {
					tmp = tmp.concat("$");
					
				}
				j--;
			}	
			
			for(k = j; tmp.length() < size_of_ngrams && (k<=s1.length()); k++) {
				tmp = tmp.concat(s1.substring(k-1, k));
			}
			for(l = k; tmp.length() < size_of_ngrams; l++) {
				tmp = tmp.concat("#");
			}
			if(tmp!="") {
				ngrams1.add(tmp);
			}	
			
			tmp = "";
		}
		
		//separate s2 into n grams
		for(i = 0; i<=s2.length(); i++) {
			j = i;
			if(i<size_of_ngrams-1) {
				for(j = i; j<size_of_ngrams-1; j++) {
					tmp = tmp.concat("$");
				}
				j--;
			}	
			for(k = j; tmp.length() <size_of_ngrams && (k<=s2.length()); k++) {
				tmp = tmp.concat(s2.substring(k-1, k));
			}
			for(l = k; tmp.length() < size_of_ngrams; l++) {
				tmp = tmp.concat("#");
			}
			if(tmp!="") {
				ngrams2.add(tmp);
			}	
			
			tmp = "";
		}
		
		//compare ngrams
		for(ListIterator<String> iter1 = ngrams1.listIterator(); iter1.hasNext();) {
			tmp = iter1.next();
			if(!ngrams2.contains(tmp)) {
				dist = dist + 1;
			}
			else {
				ngrams2.remove(tmp);
			}
		}
		dist = dist + ngrams2.size();
		if(NORMALIZED) {
			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		}
		else {
			return dist;
		}
		
		
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALIZED = norm;
	}

	public double getDist() {
		return dist;
	}

	public int getNum_of_ngrams1() {
		return num_of_ngrams1;
	}

	public int getNum_of_ngrams2() {
		return num_of_ngrams2;
	}

	public void setNDist(double norm_dist) {
		this.norm_dist = norm_dist;
	}

	public double getNDist() {
		
		return norm_dist;
	}

}
