package MainPackage;
import java.util.LinkedList;

import symMetricFiles.*;
import symMetricStrings.*;

public class CompleteComparison extends FileMetric {
	private double max_dist;
	private LinkedList<String> max_metric;
	private double min_dist;
	private LinkedList<String> min_metric;
	private double avg_dist;
	private double sum_dist;
	private int num_dist;
	private boolean NORMALISED;
	
	public CompleteComparison(boolean norm)
	{
		super(null);
		
	/* 	max possible distance is 1 and minimum possible distance is 0. So as not to loose this values, max and min_dist are
	 * 	initialized as -1 and 2.
	 */
		
		max_dist = -1; 
		min_dist = 2;
		avg_dist = 0;
		sum_dist = 0;
		num_dist = 0;
		max_metric = new LinkedList<String>();
		min_metric = new LinkedList<String>();
		NORMALISED = norm;
		
	}


	@Override
	public double compare(LinkedList<String> file1, LinkedList<String> file2) {
		// TODO Auto-generated method stub
		
				
		/*compare using Dice metric*/
		compare_with_DiceFile(file1, file2);
		
		/*compare using hash file metric*/
		compare_with_HashFile(file1, file2);
		
		/*compare using hash file metric*/
		compare_with_IdealFile(file1, file2);
		
		
		/* compare using MErecursive metric with different secondary metrices*/
		compare_with_MErecursive(file1, file2);
		
		/*Compare using MyMetricFile metrics with other secondary distances and other parameters*/
		compare_with_MyMetricFile(file1, file2, 0);
		compare_with_MyMetricFile(file1, file2, 1);
		compare_with_MyMetricFile(file1, file2, 5);
		compare_with_MyMetricFile(file1, file2, 10);
		compare_with_MyMetricFile(file1, file2, 50);
		compare_with_MyMetricFile(file1, file2, 100);
				
		
		avg_dist = (double)(sum_dist / num_dist);
	
	
		
		return 0;
	}
	private void compare_distances(double tmp_dist,String name_of_metrics)
	{
		if(tmp_dist<=min_dist)
		{
			if(tmp_dist!=min_dist)
			{
				min_metric.clear();
				min_dist = tmp_dist;
			}
			min_metric.add(name_of_metrics);
			
		}
		else if(tmp_dist>=max_dist)
		{
			if(tmp_dist!=max_dist)
			{
				max_metric.clear();
				max_dist = tmp_dist;
			}
			max_metric.add(name_of_metrics);
		}
		sum_dist += tmp_dist;
		num_dist++;
	}	

	private void compare_with_MErecursive(LinkedList<String> file1, LinkedList<String> file2)
	{
		double tmp_dist;
		FileMetric m;
		
		m = new MErecursive(new BlockDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_BlockDist");
		
		m = new MErecursive(new DiceDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_DiceDist");
		
		m = new MErecursive(new HammingDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_HammingDist");
		
		m = new MErecursive(new IdealDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_IdealDist");
		
		m = new MErecursive(new JaroDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_JaroDist");
		
		m = new MErecursive(new JaroWinklerDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_JaroWinklerDist");
		
		m = new MErecursive(new LevensteinDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_LevensteinDist");
		
		m = new MErecursive(new NeedleDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_NeedleDist");
		
		m = new MErecursive(new NgramDist(3, NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_NgramDist_Trigram");

		m = new MErecursive(new SmithWDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MErecursive_SmithWDist");
		

		
	}
	
	private void compare_with_IdealFile(LinkedList<String> file1, LinkedList<String> file2)
	{
		double tmp_dist;
		FileMetric m;
		
		m = new IdealFile(NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "IdealFile");
	}

	private void compare_with_HashFile(LinkedList<String> file1, LinkedList<String> file2)
	{
		double tmp_dist;
		FileMetric m;
		
		m = new HashFile(NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "HashFile");
	}
	
	private void compare_with_DiceFile(LinkedList<String> file1, LinkedList<String> file2)
	{
		double tmp_dist;
		FileMetric m;
		
		m = new DiceFile(NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "DiceFile");
	}
	
	
	private void compare_with_MyMetricFile(LinkedList<String> file1, LinkedList<String> file2, int tolerance)
	{
		double tmp_dist;
		FileMetric m;
		
		m = new MyMetricFile(tolerance, new BlockDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_BlockDist");
		
		m = new MyMetricFile(tolerance, new DiceDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_DiceDist");
		
		m = new MyMetricFile(tolerance, new IdealDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_IdealDist");
		
		
		m = new MyMetricFile(tolerance, new HammingDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_HammingDist");
		
		m = new MyMetricFile(tolerance, new JaroDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_JaroDist");
		
		m = new MyMetricFile(tolerance, new JaroWinklerDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_JaroWinklerDist");
		
		m = new MyMetricFile(tolerance, new LevensteinDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_LevensteinDist");
		

		m = new MyMetricFile(tolerance, new NeedleDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_NeedleDist");
		
		m = new MyMetricFile(tolerance, new NgramDist(3, NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_NgramDist_Trigram");

		m = new MyMetricFile(tolerance, new SmithWDist(NORMALISED), NORMALISED);
		tmp_dist = m.compare(file1, file2);
		compare_distances(tmp_dist, "MyMetricFile_SmithWDist");
		
		
		
	}
	
	public double getMax_dist() {
		return max_dist;
	}

	public void setMax_dist(double max_dist) {
		this.max_dist = max_dist;
	}

	public double getMin_dist() {
		return min_dist;
	}

	public void setMin_dist(double min_dist) {
		this.min_dist = min_dist;
	}

	public double getAvg_dist() {
		return avg_dist;
	}

	public void setAvg_dist(double avg_dist) {
		this.avg_dist = avg_dist;
	}


	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}