package MainPackage;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.ListIterator;

import symMetricStrings.BlockDist;
import symMetricStrings.CompString;
import symMetricStrings.DiceDist;
import symMetricStrings.HammingDist;
import symMetricStrings.IdealDist;
import symMetricStrings.JaroDist;
import symMetricStrings.JaroWinklerDist;
import symMetricStrings.LevensteinDist;
import symMetricStrings.LocalizedDist;
import symMetricStrings.NeedleDist;
import symMetricStrings.NgramDist;
import symMetricStrings.SmithWDist;


public class PairComparison {
	//using all metrics
	LinkedList<String> l1;
	boolean NORMALISED;
	public PairComparison() {
		
		l1 = null;
		NORMALISED = true;
	}
	public PairComparison(boolean norm) {
		l1 = null;
		NORMALISED = norm;
		
	}
	public void hello() {
		
	}
	public double compare_pairs(File f)  {
		
		String s1, s2;
		CompString cs;
		double result;
		l1 = new LinkedList<String>();
		try {
			readFile(f);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		String filename = "pair_comparison_" + f.getName();
		
		File log = new File(filename);
		PrintWriter fwrite;
		try {
			fwrite = new PrintWriter(log);
			
			
			for(ListIterator<String> i = l1.listIterator(); i.hasNext(); ) {
				s1 = i.next();
				if(i.hasNext()) {
					s2 = i.next();
				}
				else {
				//	("Nie je par" + s1);
					break;
				}
				
				fwrite.println(s1 + " " + s2 );
		
	
					cs = new CompString(new BlockDist(false), s1, s2);
					result = cs.traverse();
					fwrite.println("Block Distance "+ Double.toString(result) );
	
					cs = new CompString(new DiceDist(NORMALISED), s1, s2);
					result = cs.traverse();
					fwrite.println("Dice Distance " + Double.toString(result)	);
	
					cs = new CompString(new HammingDist(NORMALISED), s1, s2);
					result = cs.traverse();
					fwrite.println("Hamming Distance " + Double.toString(result));
				
					cs = new CompString(new IdealDist(NORMALISED), s1, s2);
					result = cs.traverse();
					fwrite.println("Ideal Distance " + Double.toString(result) );
	
					cs = new CompString(new JaroDist(NORMALISED), s1, s2);
					result = cs.traverse();
					fwrite.println("Jaro Distance " + Double.toString(result)	);
	
					cs = new CompString(new JaroWinklerDist(NORMALISED),s1, s2);
					result = cs.traverse();
					fwrite.println("JaroWinkler Distance "+ Double.toString(result) );
	
					cs = new CompString(new LevensteinDist(NORMALISED), s1,
							s2);
					result = cs.traverse();
					fwrite.println("Levenstein Distance 0.1 "	+ Double.toString(result) );
					
					cs = new CompString(new LocalizedDist(NORMALISED, 1, 0.1), s1,
							s2);
					
					result = cs.traverse();
					fwrite.println("Localized Distance "	+ Double.toString(result) );
					
					cs = new CompString(new NeedleDist(NORMALISED, 0.5), s1, s2);
					result = cs.traverse();
					fwrite.println("Needle Distance gap 0,5"	+ Double.toString(result) );
					
					cs = new CompString(new NgramDist(NORMALISED), s1, s2);
					result = cs.traverse();
					fwrite.println("Ngram Distance "	+ Double.toString(result) );
	
	
					cs = new CompString(new SmithWDist(NORMALISED), s1, s2);
					result = cs.traverse();
					fwrite.println("SmithWaterman Distance " + Double.toString(result) );
	
				}		
				fwrite.close();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return 0;
	}
	
	private void readFile(File f) throws FileNotFoundException {
		int c = 0;
		Character ctmp;
		String s = new String("");
		String tmp = new String("");
		FileReader fread;
		try {
			fread = new FileReader(f);
				
			while ((c = fread.read()) != -1) {
				if (c != ' ' && c != '\n') {
					
					ctmp = (char) c;
					tmp = ctmp.toString();
					s = s + tmp;
				} else {
					if(!s.isEmpty()) {
						
						s = s.toLowerCase();
						
						l1.add(s.trim());
						
					}	
					
					s = "";
				}

			}
			if(!s.isEmpty()) {

				s = s.toLowerCase();
				
				l1.add(s.trim());
			}	
			
			s = "";
		
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			// ShowMessage("Cannot read from file1");
		}
	
	
	
	
	}
	
}
