package symMetricFiles;


import java.util.LinkedList;


import symMetricStrings.*;

public class MyMetricFile extends FileMetric {

	// tolerance is how far will we search for indicated string
	private int tolerance;
	private StringMetric metric;
	private double dist;
	private double norm_dist;
	private boolean NORMALISED;
	private int length1;
	private int length2;
	private int length_of_file1;
	private int length_of_file2;

	public MyMetricFile() {
		
		super(new DiceDist(true));
		tolerance = 1;
		metric = new DiceDist(true);
		dist = 0;
		norm_dist = 0;
		NORMALISED = true;
		length1 = 0;
		length2 = 0;
	}

	public MyMetricFile(int tolerance) {
		super(new DiceDist(true));
		dist = 0;
		norm_dist = 0;
		NORMALISED = true;
		this.tolerance = tolerance;
		length1 = 0;
		length2 = 0;
		metric = new DiceDist(true);
	}

	public MyMetricFile(int tolerance, StringMetric secondary_metric, boolean norm) {

		super(secondary_metric);
		this.tolerance = tolerance;
		this.metric = secondary_metric;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		length1 = 0;
		length2 = 0;
	}

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length1;
	}

	public int getL2() {
		return length2;
	}

	public void setNDist(double norm_dist) {
		this.norm_dist = norm_dist;
	}

	public double compare(LinkedList<String> file1, LinkedList<String> file2) {

		String s1, s2;
		dist = 0;
		int index1, index2;
		double result = 0;
		double min_result = 10;
		int min_index = 0;
		int min_index_i = 0;
		boolean was_changed = false;
		dist = 0;
		norm_dist = 0;
		
		length_of_file1 = file1.size();
		length_of_file2 = file2.size();

		if (tolerance == -1) {

			// whole document
			MErecursive m = new MErecursive(metric, NORMALISED);
			result = m.compare(file1, file2);
			return result;
		}
while((file1.size()!=0) && (file2.size()!=0)) {
	
		for (int i = 0; i < file1.size(); i++) {
			
			index1 = i;
			s1 = file1.get(index1);
			int k = min(file2.size(), index1);
			for (int j = k; (j - k <= tolerance) && (j < file2.size()); j++) {

				index2 = j;
				s2 = file2.get(index2);
				if(s1.length()!=0 && s2.length()!=0) { 
					
					result = metric.compare(s1, s2);
				}	

				if (min_result > result) {
					was_changed = true;
					min_result = result;
					min_index = index2;
					min_index_i = index1;
				}
			}

			for (int j = k-1; ((k - j) <= tolerance && (j > 1)); j--) {

				index2 = j;
				s2 = file2.get(index2);
				result = metric.compare(s1, s2);
				

				if (min_result > result) {
					was_changed = true;
					min_result = result;
					min_index = index2;
					min_index_i = index1;
				}

			}
		}
			if(was_changed)
			{
				if (file2.size() != 0) {
					System.out.println(file2.get(min_index));
					file2.remove(min_index);
				}
				if(file1.size()!=0) {
					System.out.println(file1.get(min_index_i));
					file1.remove(min_index_i);
				}
				was_changed = false;
			}
			/*
			 * what way should it be? if(was_changed) { file2.remove(min_index); }
			 */
			System.out.println(file1.size()+ "  " + file2.size());
			was_changed = false;

			dist += (double) min_result;
			min_result = 10;

		}
		dist = dist + file1.size() + file2.size();

		if (NORMALISED) {
			FileNormaliser n = new FileNormaliser();
			n.normalise(this);
			return norm_dist;
		} else {
			return dist;
		}
	}

	private int min(int a, int b) {
		if (a > b)
			return b;
		else
			return a;
	}

	public double getNorm_dist() {
		return norm_dist;
	}

	public void setNorm_dist(double norm_dist) {
		this.norm_dist = norm_dist;
	}

	public void setDist(double dist) {
		this.dist = dist;
	}

	public StringMetric getMetric() {
		return metric;
	}

	public void setMetric(StringMetric secondary_metric) {
		this.metric = secondary_metric;
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}

	public int getLength_of_file1() {
		return length_of_file1;
	}

	public int getLength_of_file2() {
		return length_of_file2;
	}

}
