package symMetricStrings;

import java.util.LinkedList;
import java.util.List;

public class DiceDist extends StringMetric {

	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean ADJUST;
	private boolean NORMALISED;

	public DiceDist(boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public DiceDist(boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = adj;
	}

	/*
	 * 
	 * 
	 * Dice distance (DiceDist) is a similarity s_metric based on terms (0,1),
	 * and is counted according to a formula based on 2*number of common terms,
	 * which it divides by sum of lengths of strings string1 and string2
	 * 
	 * Value 1 of Dice coefficient means identical strings and value 0 means
	 * completely different strings
	 * 
	 * 
	 */

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}
	private List<Character> StringToList(String s)
	{
		List<Character> list = new LinkedList<Character>();
		for(int i = 0; i< s.length(); i++)
		{
			list.add(s.charAt(i));		
		}
		
		return list;
	}
	
	private int findCommon(String s1, String s2) {

		// finds the number of common characters in s1, s2
		int num = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();
		int i;
				
		List<Character> l1;
		List<Character> l2;
		
		l1 = StringToList(s1);
		l2 = StringToList(s2);
		

		for (i = 0; i < length_s1; i++) 
		{
				if(l2.contains(l1.get(i)))
				{
						num++;
						l2.remove(l1.get(i));
				}
		}

		return num;
	}

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		
		int common = findCommon(s1, s2);
	
		dist = 0;
		norm_dist = 0;
		dist = (((2* (double) common)) / (s1.length() + s2.length()));

		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else {
			return dist;
		}
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}
