package symMetricStrings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class IdealDist extends StringMetric {
	int suffix_pos1, suffix_pos2;
	int prefix_pos1, prefix_pos2;
	double dist;
	double norm_dist;
	double weight_begin;
	double weight_end;
	boolean NORMALISED;
	int l1, l2;
	private boolean ADJUST;
	
	public IdealDist(boolean NORM) {
		// TODO Auto-generated constructor stub
		dist = 0;
		norm_dist = 0;
		suffix_pos1 = suffix_pos2 = 0;
		prefix_pos1 = prefix_pos2 = 0;
		NORMALISED = NORM;
		l1 = l2 = 0;
		ADJUST = false;
		
		
	}
	
	public IdealDist(boolean NORM, boolean adj) {
		// TODO Auto-generated constructor stub
		dist = 0;
		norm_dist = 0;
		suffix_pos1 = suffix_pos2 = 0;
		prefix_pos1 = prefix_pos2 = 0;
		NORMALISED = NORM;
		l1 = l2 = 0;
		ADJUST = adj;
		
		
	}
	public IdealDist() {
		
		dist = 0;
		norm_dist = 0;
		suffix_pos1 = suffix_pos2 = 0;
		prefix_pos1 = prefix_pos2 = 0;
		NORMALISED = true;
		l1 = l2 = 0;
		ADJUST = false;
		
	}
	
	

	
	@Override
	public double compare(String s1, String s2) {
		
	//Find if suffix of the world can be found in the database of suffixes, then compare words
	//without suffixes and set tolerance = length of suffix	
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		int i;
		int min_s1_s2;
		double dist1 = 0, dist2 = 0;
		
		l1 = s1.length();
		l2 = s2.length();
		suffix_pos1 = suffix_pos2 = 0;
		prefix_pos1 = prefix_pos2 = 0;
		double prefix_dist = 0;
		double mainword_dist = 0;
		double suffix_dist = 0;
		dist = 0;
		norm_dist = 0;
		boolean not_eof = true;
		
		//used for normalisation to prevent division by 0
		int prefix_length;
		int main_length;
		int suffix_length;
		//set min_s1_s2 as minimum length of string 1 and string 2
		if(l1<=l2)	{	
			min_s1_s2 = l1;
		}
		else {
			min_s1_s2 = l2;
		}
		
		//find out if suffix of string1 is in database......................................................
		//open the database
		File f = new File("suffixes.txt");
		FileReader freader = null;
		try {
			freader = new FileReader(f);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
		
		//what if c==EOF???
		int c;
		Character ctmp;
		String tmp = "";
		String suffix = "";
		String s = "";
		not_eof = true;
		while((suffix_pos1 == 0 || suffix_pos2 == 0) && (not_eof)) {
			
			try {
				while ((c = freader.read()) != -1) {
					if (!Character.isWhitespace(c)) {
						
						ctmp = (char) c;
						
						
							tmp = ctmp.toString();						
							s = s + tmp;
							
							
						
					} else if (s!="" && s!=null){
						
						suffix = s;
						
						s = "";
					
						if (s1.endsWith(suffix) && suffix_pos1==0) {
							suffix_pos1 = suffix.length();
							
						}
						if (s2.endsWith(suffix) && suffix_pos2==0) {
							suffix_pos2 = suffix.length();
							
							
						}
						if(suffix_pos1!=0 && suffix_pos2!=0) {
							break;
						}
						
					}
					
	
				}
				not_eof  = false;
				
				
			
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// ShowMessage("Cannot read from file1");
			}
			
			
			
			
		
		}
	
		//end find out if suffix of string1 is in database......................................................
		//prefix setup ....................................................................................
		
		
		//find out if prefix of string1 is in database
		//open the database
		File f2 = new File("prefixes.txt");
		FileReader freader2 = null;
		try {
			freader2 = new FileReader(f2);
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}	
		
		//what if c==EOF???
		int c2;
		Character ctmp2;
		String tmp2 = "";
		String prefix = "";
		String s_prefix = "";
		not_eof = true;
		while((prefix_pos1 == 0 || prefix_pos2 == 0) && (not_eof)) {
			
			try {
				while ((c2 = freader2.read()) != -1) {
					
					if (!Character.isWhitespace(c2)) {
						
						ctmp2 = (char) c2;
						
						
							tmp2 = ctmp2.toString();						
							s_prefix = s_prefix + tmp2;
							
							
						
					} else if (s_prefix!="" && s_prefix!=null){
						
						prefix = s_prefix;
						
						s_prefix = "";
					
						if (s1.startsWith(prefix) && prefix_pos1==0) {
							prefix_pos1 = prefix.length();
							
						}
						if (s2.startsWith(prefix) && prefix_pos2==0) {
							prefix_pos2 = prefix.length();
							
							
						}
						if(prefix_pos1!=0 && prefix_pos2!=0) {
							break;
						}
						
					}
					
	
				}
				not_eof = false;
				
				
			
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// ShowMessage("Cannot read from file1");
			}
		
		}
		
		
		
		
		//separate prefixes and suffixes from the word *****************************************************
		
		
		String prefix1, prefix2, suffix1, suffix2, mainword1, mainword2;
		if(prefix_pos1>0) {
			prefix1 = s1.substring(0, prefix_pos1);
		}
		else {
			prefix1 = "";
		}
		if(prefix_pos2>0) {
			prefix2 = s2.substring(0, prefix_pos2);
		}
		else {
			prefix2 = "";
		}
		if(prefix_pos1<s1.length() - suffix_pos1 -1) {
			mainword1 = s1.substring(prefix_pos1, s1.length() - suffix_pos1 -1);
		}
		else {
			mainword1 = "";
		}
		
		if(prefix_pos2< s2.length() - suffix_pos2 -1) {
			mainword2 = s2.substring(prefix_pos2, s2.length() - suffix_pos2 -1);
		}
		else {
			mainword2 = "";
		}
		if((s1.length() - suffix_pos1 -1< s1.length()) &&(s1.length() - suffix_pos1 -1>=0)) {
			suffix1 = s1.substring(s1.length() - suffix_pos1 -1, s1.length());
		}
		else {
			suffix1 = "";
		}
		if((s2.length() - suffix_pos2 -1< s2.length()) && (s2.length() - suffix_pos2 -1>=0)) {
			suffix2 = s2.substring(s2.length() - suffix_pos2 -1, s2.length());
		}
		else {
			suffix2 = "";
		}
		
		
		
		//compare separate parts of the word *********************************************************************
		
		
		
		StringMetric m = new LevensteinDist(false);
	
		if(prefix1.length()==0) {
			prefix_dist = prefix2.length();
		}
		else if(prefix2.length()==0) {
			prefix_dist = prefix1.length();
		}
		else {
			prefix_dist = m.compare(prefix1, prefix2);
		}
	
		if(mainword1.length()==0) {
			mainword_dist = mainword2.length();
		}
		else if(mainword2.length()==0) {
			mainword_dist = mainword1.length();
		}
		else {
			mainword_dist = m.compare(mainword1, mainword2);
		}
		
		if(suffix1.length()== 0) {
			suffix_dist = suffix2.length();
		}
		else if(suffix2.length()== 0) {
			suffix_dist = suffix1.length();
		}
		else {
			suffix_dist = m.compare(suffix1, suffix2);
		}	
		
		dist = prefix_dist * 0.5 + mainword_dist + suffix_dist* 0.1;
		if(NORMALISED) {
			prefix_length = max((prefix1.length() + prefix2.length()), 1);
			main_length = max((mainword1.length() + mainword2.length()), 1);
			suffix_length = max((suffix1.length() + suffix2.length()),1);
			norm_dist = (prefix_dist / prefix_length) * 0.5 + (mainword_dist / main_length) + (suffix_dist / suffix_length) * 0.1;
			norm_dist = norm_dist / 1.6;
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		}
		return dist;
				
	}

	/**
	 * @param args
	 */
	
	public double getDist() {
		return dist;
	}
	public void setDist(double dist) {
		this.dist = dist;
	}
	public double getNDist() {
		return norm_dist;
	}
	public void setNDist(double norm_dist) {
		this.norm_dist = norm_dist;
	}
	public int getL1() {
		return l1;
	}
	public int getL2() {
		return l2;
	}
	
	private int max(int i, int j) {
		if(i<j) return j;
		else return i;
	}
	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}

}
