package symMetricStrings;

public class LevensteinDist extends StringMetric {

	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean NORMALISED;
	private boolean ADJUST;

	public LevensteinDist(boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public LevensteinDist(boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		NORMALISED = norm;
		ADJUST = adj;
	}

	/*
	 * Levenstein Distance (LevensteinDist) is the minimum edit distance needed
	 * to transform string1 to string2 Copy character from string1 over to
	 * string2 (cost 0)
	 * 
	 * Delete a character in string1 (cost 1) Insert a character in string2
	 * (cost 1) Substitute one character for another (cost 1)
	 * D(i,j) = min D(i-1,j)+1 //insert
	 * 				D(i-1,j-1) + d(si,tj) //subst/copy 
	 * 				D(i,j-1)+1 //delete
	 * 
	 * d(i,j) is a function whereby d(c,d)=0 if c=d, 1 else
	 * 
	 * If string1 equals string 2, then Levenstein Distance is 0
	 */

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}

	private int min(int i, int j, int k) {

		if ((i <= j) && (i <= k))
			return i;
		else if ((j <= i) && (j <= k))
			return j;
		else
			return k;
	}

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		dist = 0;
		norm_dist = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();
		
		if(length_s1==0 || length_s2==0) {
			return 0;
		}
		
		int[][] D = new int[length_s1][length_s2];

		for (int i = 0; i < length_s1; i++) {
			D[i][0] = i + 1;
		}

		for (int j = 0; j < length_s2; j++) {
			D[0][j] = j + 1;
		}
		D[0][0] = d(s1.charAt(0), s2.charAt(0));
		for (int i = 1; i < length_s1; i++) {
			for (int j = 1; j < length_s2; j++) {
				D[i][j] = min(D[i - 1][j - 1] + d(s1.charAt(i), s2.charAt(j)),
						D[i - 1][j] + 1, D[i][j - 1] + 1);
			}
		}

		dist = D[length_s1 - 1][length_s2 - 1];

		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else
			return dist;
	}

	private int d(char a, char b) {
		if (a == b)
			return 0;
		else
			return 1;
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}
}
