package symMetricStrings;

public class NeedleDist extends StringMetric {
	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private double gap;
	private boolean NORMALISED;
	private boolean ADJUST;

	public NeedleDist(boolean norm, double g) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		gap = g;
		NORMALISED = norm;
		ADJUST = false;
	}
	public NeedleDist(boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		gap = 1.5;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public NeedleDist(boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		gap = 1.5;
		NORMALISED = norm;
		ADJUST = adj;
	}

	/*
	 * Needleman-Wunsch distance (NeedleDist) je pododobna LevensteinDist, ale
	 * navyse pridava cenu vymazania/pridania medzery - gap
	 * 
	 * 				D(i-1,j-1) + d(si,tj) //subst/copy
	 * D(i,j) = min D(i-1,j)+G //insert
	 * 				D(i,j-1)+G //delete
	 * 
	 * 
	 * Ak sa string1 rovna string2, potom Needleman-Wunsch distance je 0
	 * 
	 * 
	 */

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}

	public double getGap() {
		return gap;
	}

	public void setGap(double gap) {
		this.gap = gap;
	}

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		dist = 0;
		norm_dist = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();

		if(length_s1==0 || length_s2==0) {
			return 0;
		}
		
		double[][] D = new double[length_s1][length_s2];
		for (int i = 0; i < length_s1; i++) {
			D[i][0] = i + 1;
		}

		for (int j = 0; j < length_s2; j++) {
			D[0][j] = j + 1;
		}
		D[0][0] = d(s1.charAt(0), s2.charAt(0));
		for (int i = 1; i < length_s1; i++) {
			for (int j = 1; j < length_s2; j++) {
				D[i][j] = min(D[i - 1][j - 1] + d(s1.charAt(i), s2.charAt(j)),
						D[i - 1][j] + gap, D[i][j - 1] + gap);
			}
		}

		dist = D[length_s1 - 1][length_s2 - 1];

		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else
			return dist;

	}

	private double min(double i, double j, double k) {

		if ((i <= j) && (i <= k))
			return i;
		else if ((j <= i) && (j <= k))
			return j;
		else
			return k;

	}

	private int d(char a, char b) {
		if (a == b)
			return 0;
		else
			return 1;
	}

	
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}

}
