package symMetricStrings;

public class Normaliser {

	public Normaliser() {

	}

	public void normalise(BlockDist x) {
		x.setNDist(x.getDist() / (max(x.getL1(), x.getL2()) * 25));
	}

	public void normalise(DiceDist x) {
		x.setNDist(1 - x.getDist());
	}

	public void normalise(HammingDist x) {
		x.setNDist(x.getDist() / (max(x.getL1(), x.getL2())));
	}

	public void normalise(JaroDist x) {
		// to do later
		x.setNDist(1-x.getDist());
	}

	public void normalise(JaroWinklerDist x) {
		// to do later
		x.setNDist(1-x.getDist());
	}

	public void normalise(LevensteinDist x) {
		x.setNDist(x.getDist() / ((x.getL1() + x.getL2())));
	}

	public void normalise(NeedleDist x) {
		x.setNDist(x.getDist() / ((x.getL1() + x.getL2()) * x.getGap()));
	}

	public void normalise(SmithWDist x) {
		// to do later
		x.setNDist(1- (x.getDist()/(x.getL1() + x.getL2())));
	}
	
	public void normalise(LocalizedDist x) {
		
		x.setNDist(2*x.getDist()/(x.getL1() + x.getL2()));
	}
	
	public void normalise(IdealDist x) {
		
		x.setNDist(2*x.getDist()/(x.getL1() + x.getL2()));
	}
	
	public void normalise(NgramDist x) {
		
		x.setNDist(x.getDist()/(x.getNum_of_ngrams1() + x.getNum_of_ngrams2()));
	}

	private int min(int a, int b) {
		if (a < b)
			return a;
		else
			return b;
	}

	private int max(int a, int b) {
		if (a > b)
			return a;
		else
			return b;
	}
}
