package symMetricStrings;

public class SmithWDist extends StringMetric {

	private int gap;
	private double dist;
	private double norm_dist;
	private int length_s1, length_s2;
	private boolean NORMALISED;
	private boolean ADJUST;

	public SmithWDist(boolean norm) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		gap = 1;
		NORMALISED = norm;
		ADJUST = false;
	}
	
	public SmithWDist(boolean norm, boolean adj) {
		length_s1 = 0;
		length_s2 = 0;
		dist = 0;
		norm_dist = 0;
		gap = 1;
		NORMALISED = norm;
		ADJUST = adj;
	}

	/*
	 * Smith-Waterman Distance (SmithWDist) hlada vzdialenost dvoch retazcov,
	 * podobna LevensteinDist, vyvinuta na hladanie optimalneho zarovnania DNA
	 * retazcov, pretoze hlada, kde konci najvacsia spolocna podpostupnost
	 * tychto retazcov, pripadne textu gap predstavuje hodnotu
	 * pridania/vymazania medzery, standartne je 1
	 * 
	 * 0 //start over 
	 * 			D(i-1,j-1) -d(si,tj) //subst/copy 
	 * D(i,j) = max D(i-1,j)-G	 * //insert 
	 * 			D(i,j-1)-G //delete
	 * 
	 * Distance is maximum over all i,j in table of D(i,j)
	 * 
	 * Ak sa string1 rovna string2, potom je Smith-Waterman distance rovna dlzke
	 * string1 (= string2)
	 * 
	 */

	public int getGap() {
		return gap;
	}

	public void setGap(int gap) {
		this.gap = gap;
	}

	public double getDist() {
		return dist;
	}

	public int getL1() {
		return length_s1;
	}

	public int getL2() {
		return length_s2;
	}

	public double getNDist() {
		return norm_dist;
	}

	public void setNDist(double value) {
		norm_dist = value;
	}

	public double compare(String s1, String s2) {
		s1 = s1.toLowerCase();
		s2 = s2.toLowerCase();
		dist = Integer.MIN_VALUE;
		norm_dist = 0;
		length_s1 = s1.length();
		length_s2 = s2.length();
		if(length_s1==0 || length_s2==0) {
			return 0;
		}
		int[][] D = new int[length_s1][length_s2];

		for (int i = 0; i < length_s1; i++) {
			D[i][0] = max(0, -d(s1.charAt(i), s2.charAt(0)));
			if (D[i][0] >= dist)
				dist = D[i][0];
		}

		for (int j = 0; j < length_s2; j++) {
			D[0][j] = max(0, -d(s1.charAt(0), s2.charAt(j)));
			if (D[0][j] >= dist)
				dist = D[0][j];

		}

		for (int i = 1; i < length_s1; i++) {
			for (int j = 1; j < length_s2; j++) {

				D[i][j] = max(D[i - 1][j - 1] - d(s1.charAt(i), s2.charAt(j)),
						D[i - 1][j]- gap, D[i][j - 1] - gap);
				if(D[i][j]<0) {
					D[i][j]=0;
				}
			//	System.out.println(D[i][j] + " " + i + "  " + j);
				// SKONTROLOVAT, CI V OBOCH PRIPADOCH MA BYT -GAP A NIE NAHODOU
				// RAZ + GAP A RAZ -GAP
			
				if (D[i][j] >= dist)
					dist = D[i][j];
			}
			
		}
		
		

		if (NORMALISED) {

			Normaliser n = new Normaliser();
			n.normalise(this);
			
			if (ADJUST) {
				Adjuster a = new Adjuster();
				a.adjust(this);
			}
			
			return norm_dist;
		} else {
			return dist;
		}	
	}

	private int max(int i, int j, int k) {

		if ((i >= j) && (i >= k)) {
			return i;
		}	
		else if ((j >= i) && (j >= k)) {
			return j;
		}	
		else {
			return k;
		}	

	}
	
	private int max(int i, int j) {
		if(i>j) return i;
		else return j;
	}

	private int d(char a, char b) {
		if (a == b) {
			return -2;
		}	
		else {
			return 1;
		}	
	}

	@Override
	public void setNormalized(boolean norm) {
		NORMALISED = norm;
		
	}

}
