/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.AdministraciaHistoria;
import bakalarka.BakalarkaMainFrame;
import bakalarka.Editor;
import bakalarka.Format;
import bakalarka.HistoriaAddedFormat;
import bakalarka.HistoriaAddedOkruh;
import bakalarka.HistoriaAddedTransformacia;
import bakalarka.HistoriaChangedPredpis;
import bakalarka.HistoriaDeletedFormat;
import bakalarka.HistoriaDeletedOkruh;
import bakalarka.HistoriaDeletedTransformacia;
import bakalarka.JednoduchaTransformacia;
import bakalarka.Okruh;
import bakalarka.PathManager;
import bakalarka.ProgramSettingsHandler;
import bakalarka.SettingsPanel;
import bakalarka.VstupnySubor;
import bakalarka.VystupnySubor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class AdministraciaFrame
extends JFrame {
    public BakalarkaMainFrame parentFrame = null;
    public Editor e = null;
    public boolean changed = false;
    public AdministraciaHistoria historia = new AdministraciaHistoria(this);
    JMenuBar AdministraciaMenuBar;
    JMenu SuborMenu;
    JMenuItem newFileItem;
    JMenuItem SaveMenuItem;
    JMenuItem SaveAsMenuItem;
    JMenuItem SaveAsDefaultMenuItem;
    JMenuItem LoadMenuItem;
    JMenuItem LoadDefaultMenuItem;
    JMenu EditMenu;
    JMenuItem UndoMenuItem;
    JMenuItem RedoMenuItem;
    JMenuItem QuitMenuItem;
    SettingsPanel mainPanel;
    JLabel nadpisLabel;
    JLabel okruhLabel;
    JComboBox okruhyComboBox;
    JButton addOkruhButton;
    JButton deleteOkruhButton;
    JLabel format1Label;
    JComboBox vstupnyFormatComboBox;
    JButton addFormatButton;
    JButton deleteFormatButton;
    JComboBox vystupnyFormatComboBox;
    JLabel format2Label;
    JLabel transformaciaLabel;
    JComboBox transformaciaComboBox;
    JButton addTransformaciaButton;
    JButton deleteTransformaciaButton;
    JTextArea predpisArea;
    JScrollPane predpisAreaScrollPane;
    JSeparator jSeparator1;
    JPanel prikazPanel;
    JTextArea prikazArea;
    JScrollPane prikazPanelScrollPane;
    SettingsPanel nodesPanel;
    JScrollPane nodePanelScrollPane;
    JLabel errorLabel;
    JSeparator menuSeparator1;
    JSeparator menuSeparator2;

    public AdministraciaFrame() {
        this.e = new Editor();
        try {
            ProgramSettingsHandler psh = new ProgramSettingsHandler();
            this.e.loadConfiguration(psh.getTransformationsFilePath());
            this.setTitle(this.e.nacitanyKonfiguracnySubor.getAbsolutePath());
        }
        catch (ParserConfigurationException ex) {
            this.showError(ex.getMessage());
        }
        catch (IOException ex) {
            this.showError(ex.getMessage());
        }
        catch (SAXException ex) {
            this.showError(ex.getMessage());
        }
        this.setVisible(true);
        this.initComponents();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AdministraciaFrame.this.formWindowClosing(evt);
            }
        });
    }

    public void loadNewConfiguration(File f) {
        try {
            this.e.loadConfiguration(f);
            this.mainPanel.removeAll();
            this.initComponents();
            if (this.errorLabel != null) {
                this.errorLabel.setVisible(false);
            }
            this.changed = false;
            this.setTitle(f.getAbsolutePath());
            this.repaint();
            this.pack();
            this.myCorrection();
        }
        catch (ParserConfigurationException ex) {
            JOptionPane.showMessageDialog(null, "Chyba!", "", 0);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
        }
        catch (SAXException ex) {
            JOptionPane.showMessageDialog(null, "Chyba v \u0161trukt\u00fare s\u00faboru!", "", 0);
        }
    }

    public void refreshTitle() {
        String title = "Nov\u00fd s\u00fabor";
        if (this.e.nacitanyKonfiguracnySubor != null) {
            title = this.e.nacitanyKonfiguracnySubor.getAbsolutePath();
        }
        if (this.changed) {
            title = "*" + title;
        }
        this.setTitle(title);
    }

    public void setParentFrame(BakalarkaMainFrame bmf) {
        this.parentFrame = bmf;
        bmf.setEnabled(false);
    }

    private void initComponents() {
        final AdministraciaFrame helpReference = this;
        this.mainPanel = new SettingsPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.AdministraciaMenuBar = new JMenuBar();
        this.SuborMenu = new JMenu("S\u00fabor");
        this.newFileItem = new JMenuItem("Nov\u00fd");
        this.newFileItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.LoadMenuItem = new JMenuItem("Na\u010d\u00edta\u0165 s\u00fabor");
        this.LoadMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.LoadDefaultMenuItem = new JMenuItem("Na\u010d\u00edta\u0165 defaultn\u00fd s\u00fabor");
        this.menuSeparator1 = new JSeparator();
        this.SaveMenuItem = new JMenuItem("Ulo\u017ei\u0165");
        this.SaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.SaveAsMenuItem = new JMenuItem("Ulo\u017ei\u0165 ako");
        this.SaveAsDefaultMenuItem = new JMenuItem("Ulo\u017ei\u0165 ako predvolen\u00e9");
        this.SaveAsDefaultMenuItem.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.menuSeparator2 = new JSeparator();
        this.QuitMenuItem = new JMenuItem("Koniec");
        this.QuitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.SuborMenu.add(this.newFileItem);
        this.SuborMenu.add(this.LoadMenuItem);
        this.SuborMenu.add(this.LoadDefaultMenuItem);
        this.SuborMenu.add(this.menuSeparator1);
        this.SuborMenu.add(this.SaveMenuItem);
        this.SuborMenu.add(this.SaveAsMenuItem);
        this.SuborMenu.add(this.SaveAsDefaultMenuItem);
        this.SuborMenu.add(this.menuSeparator2);
        this.SuborMenu.add(this.QuitMenuItem);
        this.AdministraciaMenuBar.add(this.SuborMenu);
        this.EditMenu = new JMenu("Editova\u0165");
        this.UndoMenuItem = new JMenuItem("Sp\u00e4\u0165");
        this.UndoMenuItem.setEnabled(false);
        this.UndoMenuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.RedoMenuItem = new JMenuItem("Dopredu");
        this.RedoMenuItem.setEnabled(false);
        this.RedoMenuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), true));
        this.EditMenu.add(this.UndoMenuItem);
        this.EditMenu.add(this.RedoMenuItem);
        this.AdministraciaMenuBar.add(this.EditMenu);
        this.setJMenuBar(this.AdministraciaMenuBar);
        this.newFileItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.e = new Editor();
                AdministraciaFrame.this.mainPanel.removeAll();
                AdministraciaFrame.this.initComponents();
                AdministraciaFrame.this.changed = false;
                AdministraciaFrame.this.refreshTitle();
            }
        });
        this.LoadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PathManager pm = new PathManager();
                JFileChooser fc = new JFileChooser(pm.getProjectPath());
                fc.setFileSelectionMode(0);
                int returnVal = fc.showOpenDialog(AdministraciaFrame.this.LoadMenuItem);
                if (returnVal == 0) {
                    File file = fc.getSelectedFile();
                    AdministraciaFrame.this.loadNewConfiguration(file);
                }
            }
        });
        this.LoadDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    ProgramSettingsHandler psh = new ProgramSettingsHandler();
                    File f = new File(psh.getTransformationsFilePath());
                    AdministraciaFrame.this.loadNewConfiguration(f);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "Neexistuj\u00faci deklarovan\u00fd defaultn\u00fd konfigura\u010dn\u00fd s\u00fabor!", "", 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
                }
            }
        });
        this.SaveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.saveConfiguration(evt);
            }
        });
        this.SaveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.saveAsConfiguration(evt);
            }
        });
        this.SaveAsDefaultMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    AdministraciaFrame.this.saveConfiguration(evt);
                    ProgramSettingsHandler psh = new ProgramSettingsHandler();
                    psh.writeTransformationsFile(AdministraciaFrame.this.e.nacitanyKonfiguracnySubor.getAbsolutePath());
                    JOptionPane.showMessageDialog(null, "Defaultn\u00fd s\u00fabor transform\u00e1cii zmenen\u00fd na " + AdministraciaFrame.this.e.nacitanyKonfiguracnySubor.getAbsolutePath() + "!", "", 1);
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "Neexistuj\u00faci s\u00fabor!", "", 0);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
                }
            }
        });
        this.UndoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                helpReference.historia.undo();
                if (!AdministraciaFrame.this.changed) {
                    AdministraciaFrame.this.changed = true;
                    AdministraciaFrame.this.refreshTitle();
                }
            }
        });
        this.RedoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                helpReference.historia.redo();
                if (!AdministraciaFrame.this.changed) {
                    AdministraciaFrame.this.changed = true;
                    AdministraciaFrame.this.refreshTitle();
                }
            }
        });
        this.QuitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.QuitMenuItemActionPerformed(evt);
            }
        });
        this.setDefaultCloseOperation(2);
        GridBagConstraints mainGridBagConstraints = new GridBagConstraints();
        mainGridBagConstraints.fill = 2;
        mainGridBagConstraints.anchor = 23;
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 0;
        mainGridBagConstraints.gridwidth = 3;
        mainGridBagConstraints.insets = new Insets(10, 50, 10, 0);
        this.nadpisLabel = new JLabel();
        this.nadpisLabel.setFont(new Font("DejaVu Sans", 1, 14));
        this.nadpisLabel.setText("Administr\u00e1cia programu");
        this.mainPanel.add((Component)this.nadpisLabel, mainGridBagConstraints);
        mainGridBagConstraints.insets = new Insets(5, 5, 5, 5);
        mainGridBagConstraints.anchor = 21;
        mainGridBagConstraints.gridwidth = 1;
        this.okruhLabel = new JLabel();
        this.okruhLabel.setText("Okruh:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.okruhLabel, mainGridBagConstraints);
        this.okruhyComboBox = new JComboBox();
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.okruhyComboBox, mainGridBagConstraints);
        this.okruhyComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.refreshOkruhy((String)AdministraciaFrame.this.okruhyComboBox.getSelectedItem());
            }
        });
        this.addOkruhButton = new JButton();
        this.addOkruhButton.setFont(new Font("DejaVu Sans", 1, 14));
        this.addOkruhButton.setText("+");
        mainGridBagConstraints.gridx = 2;
        mainGridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.addOkruhButton, mainGridBagConstraints);
        this.addOkruhButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.addOkruhButtonActionPerformed(evt);
            }
        });
        this.deleteOkruhButton = new JButton();
        this.deleteOkruhButton.setFont(new Font("DejaVu Sans", 1, 14));
        this.deleteOkruhButton.setText("-");
        this.deleteOkruhButton.setEnabled(this.e.aktualnyOkruh != null);
        mainGridBagConstraints.gridx = 3;
        mainGridBagConstraints.gridy = 1;
        this.mainPanel.add((Component)this.deleteOkruhButton, mainGridBagConstraints);
        this.deleteOkruhButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.deleteOkruhButtonActionPerformed(evt);
            }
        });
        this.refreshOkruhy(null);
        this.format1Label = new JLabel();
        this.format1Label.setText("Format:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 2;
        this.mainPanel.add((Component)this.format1Label, mainGridBagConstraints);
        this.vstupnyFormatComboBox = new JComboBox();
        this.vystupnyFormatComboBox = new JComboBox();
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 2;
        this.mainPanel.add((Component)this.vstupnyFormatComboBox, mainGridBagConstraints);
        this.vstupnyFormatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.refreshVstupneFormaty((String)AdministraciaFrame.this.vstupnyFormatComboBox.getSelectedItem());
            }
        });
        this.addFormatButton = new JButton();
        this.addFormatButton.setFont(new Font("DejaVu Sans", 1, 14));
        this.addFormatButton.setText("+");
        if (this.e.aktualnyOkruh == null) {
            this.addFormatButton.setEnabled(false);
        }
        mainGridBagConstraints.gridx = 2;
        mainGridBagConstraints.gridy = 2;
        this.mainPanel.add((Component)this.addFormatButton, mainGridBagConstraints);
        this.addFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.addFormatButtonActionPerformed(evt);
            }
        });
        this.deleteFormatButton = new JButton();
        this.deleteFormatButton.setFont(new Font("DejaVu Sans", 1, 14));
        this.deleteFormatButton.setText("-");
        if (this.e.aktualnyVstupnyFormat == null) {
            this.deleteFormatButton.setEnabled(false);
        }
        mainGridBagConstraints.gridx = 3;
        mainGridBagConstraints.gridy = 2;
        this.mainPanel.add((Component)this.deleteFormatButton, mainGridBagConstraints);
        this.deleteFormatButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.deleteFormatButtonActionPerformed(evt);
            }
        });
        this.refreshVstupneFormaty(null);
        this.format2Label = new JLabel();
        this.format2Label.setText("V\u00fdstup:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 3;
        this.mainPanel.add((Component)this.format2Label, mainGridBagConstraints);
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 3;
        this.mainPanel.add((Component)this.vystupnyFormatComboBox, mainGridBagConstraints);
        this.vystupnyFormatComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.refreshVystupnyFormat((String)AdministraciaFrame.this.vystupnyFormatComboBox.getSelectedItem());
            }
        });
        this.transformaciaLabel = new JLabel();
        this.transformaciaLabel.setText("Transform\u00e1cia:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 4;
        this.mainPanel.add((Component)this.transformaciaLabel, mainGridBagConstraints);
        this.transformaciaComboBox = new JComboBox();
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 4;
        this.mainPanel.add((Component)this.transformaciaComboBox, mainGridBagConstraints);
        this.transformaciaComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.refreshTransformacie((String)AdministraciaFrame.this.transformaciaComboBox.getSelectedItem());
            }
        });
        this.addTransformaciaButton = new JButton();
        this.addTransformaciaButton.setFont(new Font("DejaVu Sans", 1, 14));
        this.addTransformaciaButton.setText("+");
        this.addTransformaciaButton.setEnabled(false);
        mainGridBagConstraints.gridx = 2;
        mainGridBagConstraints.gridy = 4;
        this.mainPanel.add((Component)this.addTransformaciaButton, mainGridBagConstraints);
        this.addTransformaciaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.addTransformaciaButtonActionPerformed(evt);
            }
        });
        this.deleteTransformaciaButton = new JButton();
        this.deleteTransformaciaButton.setFont(new Font("DejaVu Sans", 1, 14));
        this.deleteTransformaciaButton.setText("-");
        this.deleteTransformaciaButton.setEnabled(false);
        mainGridBagConstraints.gridx = 3;
        mainGridBagConstraints.gridy = 4;
        this.mainPanel.add((Component)this.deleteTransformaciaButton, mainGridBagConstraints);
        this.deleteTransformaciaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AdministraciaFrame.this.deleteTransformaciaButtonActionPerformed(evt);
            }
        });
        this.predpisArea = new JTextArea();
        this.predpisArea.setLineWrap(true);
        this.predpisArea.setWrapStyleWord(true);
        this.predpisArea.setRows(15);
        this.predpisArea.setColumns(50);
        mainGridBagConstraints.gridwidth = 4;
        mainGridBagConstraints.gridheight = 4;
        mainGridBagConstraints.gridx = 5;
        mainGridBagConstraints.gridy = 1;
        mainGridBagConstraints.insets = new Insets(0, 30, 0, 0);
        this.predpisAreaScrollPane = new JScrollPane(this.predpisArea);
        this.predpisAreaScrollPane.setVerticalScrollBarPolicy(22);
        this.predpisArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent evt) {
                AdministraciaFrame.this.predpisAreaActionPerformed(evt);
            }
        });
        this.mainPanel.add((Component)this.predpisAreaScrollPane, mainGridBagConstraints);
        mainGridBagConstraints.gridwidth = 1;
        mainGridBagConstraints.gridheight = 1;
        this.jSeparator1 = new JSeparator(0);
        mainGridBagConstraints.fill = 2;
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 5;
        mainGridBagConstraints.gridwidth = 4;
        this.mainPanel.add((Component)this.jSeparator1, mainGridBagConstraints);
        mainGridBagConstraints.gridwidth = 1;
        this.prikazPanel = new JPanel(new GridBagLayout());
        this.prikazPanel.setVisible(false);
        GridBagConstraints prikazPanelGBC = new GridBagConstraints();
        prikazPanelGBC.insets = new Insets(0, 0, 0, 0);
        prikazPanelGBC.fill = 0;
        prikazPanelGBC.anchor = 21;
        prikazPanelGBC.gridx = 0;
        prikazPanelGBC.gridy = 0;
        this.prikazPanel.add((Component)new JLabel("Pr\u00edkaz:"), prikazPanelGBC);
        prikazPanelGBC.gridx = 1;
        prikazPanelGBC.gridy = 0;
        prikazPanelGBC.insets = new Insets(0, 15, 0, 0);
        this.prikazArea = new JTextArea(1, 70);
        this.prikazArea.setEditable(false);
        this.prikazPanelScrollPane = new JScrollPane(this.prikazArea);
        this.prikazPanelScrollPane.setVerticalScrollBarPolicy(22);
        this.prikazPanelScrollPane.setHorizontalScrollBarPolicy(31);
        this.prikazPanel.add((Component)this.prikazPanelScrollPane, prikazPanelGBC);
        mainGridBagConstraints.gridx = 0;
        ++mainGridBagConstraints.gridy;
        mainGridBagConstraints.gridwidth = 100;
        mainGridBagConstraints.fill = 0;
        mainGridBagConstraints.insets = new Insets(10, 15, 0, 0);
        this.mainPanel.add((Component)this.prikazPanel, mainGridBagConstraints);
        mainGridBagConstraints.gridwidth = 1;
        this.nodesPanel = new SettingsPanel();
        this.nodesPanel.parent = this.mainPanel;
        this.nodesPanel.setLayout(new GridBagLayout());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.nodesPanel, "West");
        this.nodePanelScrollPane = new JScrollPane(panel);
        this.nodePanelScrollPane.setVerticalScrollBarPolicy(20);
        this.nodePanelScrollPane.setHorizontalScrollBarPolicy(30);
        this.nodePanelScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.nodePanelScrollPane.setPreferredSize(new Dimension(this.mainPanel.getPreferredSize().width, this.predpisAreaScrollPane.getPreferredSize().height * 1));
        this.nodePanelScrollPane.setVisible(false);
        mainGridBagConstraints.gridx = 0;
        ++mainGridBagConstraints.gridy;
        mainGridBagConstraints.gridwidth = 100;
        mainGridBagConstraints.anchor = 23;
        mainGridBagConstraints.fill = 0;
        mainGridBagConstraints.insets = new Insets(15, 0, 5, 0);
        this.mainPanel.add((Component)this.nodePanelScrollPane, mainGridBagConstraints);
        mainGridBagConstraints.fill = 1;
        mainGridBagConstraints.gridwidth = 1;
        this.errorLabel = new JLabel("");
        this.errorLabel.setFont(new Font("DejaVu Sans", 0, 12));
        this.errorLabel.setForeground(Color.RED);
        this.errorLabel.setVisible(false);
        mainGridBagConstraints.insets = new Insets(10, 10, 5, 0);
        mainGridBagConstraints.gridx = 0;
        ++mainGridBagConstraints.gridy;
        mainGridBagConstraints.gridwidth = 100;
        mainGridBagConstraints.anchor = 23;
        mainGridBagConstraints.fill = 0;
        this.mainPanel.add((Component)this.errorLabel, mainGridBagConstraints);
        this.refreshTransformacie(null);
        this.getContentPane().add(this.mainPanel);
        this.pack();
    }

    public void refreshOkruhy(String setOkruh) {
        if (this.e.confLoaded() && this.e.conf.okruhy != null) {
            if (this.e.conf.okruhy.size() > 0) {
                int newIndex = -1;
                String[] okruhyMena = new String[this.e.conf.okruhy.size()];
                int counter = 0;
                for (Okruh spracovavany : this.e.conf.okruhy) {
                    okruhyMena[counter] = spracovavany.meno;
                    if (setOkruh != null && spracovavany.getMeno().compareTo(setOkruh) == 0) {
                        newIndex = counter;
                    }
                    ++counter;
                }
                this.okruhyComboBox.setModel(new DefaultComboBoxModel<String>(okruhyMena));
                if (setOkruh != null && newIndex != -1) {
                    this.okruhyComboBox.setSelectedIndex(newIndex);
                }
                this.e.aktualnyOkruh = this.e.conf.getOkruh((String)this.okruhyComboBox.getSelectedItem());
            } else {
                this.okruhyComboBox.setModel(new DefaultComboBoxModel());
                this.e.aktualnyOkruh = null;
            }
        } else {
            this.e.aktualnyOkruh = null;
        }
        this.addOkruhButton.setEnabled(true);
        if (this.e.aktualnyOkruh != null) {
            this.deleteOkruhButton.setEnabled(true);
        } else {
            this.deleteOkruhButton.setEnabled(false);
            this.e.aktualnyVstupnyFormat = null;
            this.e.aktualnyVystupnyFormat = null;
            this.e.aktualnaTransformacia = null;
        }
        if (this.vstupnyFormatComboBox != null) {
            this.refreshVstupneFormaty(null);
        }
        if (this.transformaciaComboBox != null) {
            this.refreshTransformacie(null);
        }
    }

    private void addOkruhButtonActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(this, "N\u00e1zov nov\u00e9ho okruhu form\u00e1tov:", "Prid\u00e1vanie okruhu", -1, null, null, "");
        if (s != null) {
            boolean pridane = this.e.conf.pridajOkruh(s);
            HistoriaAddedOkruh hao = new HistoriaAddedOkruh(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, this.e.conf.getOkruh(s));
            if (pridane) {
                this.changed = true;
                this.historia.pridajZaznam(hao);
                this.refreshTitle();
                this.refreshOkruhy(s);
            } else {
                JOptionPane.showMessageDialog(this, "Okruh s tak\u00fdmto menom u\u017e existuje.", "U\u017e existuj\u00faci okruh!", 0);
            }
        }
    }

    private void deleteOkruhButtonActionPerformed(ActionEvent evt) {
        int n = JOptionPane.showConfirmDialog(this, "Skuto\u010dne chcete vymaza\u0165 dan\u00fd okruh?", "Mazanie okruhu", 0);
        if (n == 0) {
            if (this.e.aktualnyOkruh != null) {
                HistoriaDeletedOkruh hdo = new HistoriaDeletedOkruh(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, this.e.aktualnyOkruh, this.e.conf.okruhy.indexOf(this.e.aktualnyOkruh));
                this.e.conf.zmazOkruh(this.e.aktualnyOkruh.getMeno());
                this.historia.pridajZaznam(hdo);
                this.changed = true;
                this.refreshTitle();
            }
            this.refreshOkruhy(null);
        }
    }

    public void refreshVstupneFormaty(String setFormat) {
        if (this.e.aktualnyOkruh != null) {
            String oldVystupnyFormat = (String)this.vystupnyFormatComboBox.getSelectedItem();
            String newVystupnyFormat = null;
            this.addFormatButton.setEnabled(true);
            if (this.e.aktualnyOkruh.formaty.size() > 0) {
                int newIndex = -1;
                String[] vstupneFormaty = new String[this.e.aktualnyOkruh.formaty.size()];
                int counter = 0;
                for (Format f : this.e.aktualnyOkruh.formaty) {
                    if (setFormat != null && setFormat.compareTo(f.getMeno()) == 0) {
                        newIndex = counter;
                    }
                    vstupneFormaty[counter] = f.getMeno();
                    if (oldVystupnyFormat != null && oldVystupnyFormat.compareTo(vstupneFormaty[counter]) == 0) {
                        newVystupnyFormat = vstupneFormaty[counter];
                    }
                    ++counter;
                }
                this.vstupnyFormatComboBox.setModel(new DefaultComboBoxModel<String>(vstupneFormaty));
                this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel<String>(vstupneFormaty));
                if (newVystupnyFormat != null) {
                    this.vystupnyFormatComboBox.setSelectedItem(newVystupnyFormat);
                }
                if (setFormat != null && newIndex != -1) {
                    this.vstupnyFormatComboBox.setSelectedIndex(newIndex);
                }
                this.e.aktualnyVstupnyFormat = this.e.aktualnyOkruh.getFormat((String)this.vstupnyFormatComboBox.getSelectedItem());
                this.e.aktualnyVystupnyFormat = this.e.aktualnyOkruh.getFormat((String)this.vystupnyFormatComboBox.getSelectedItem());
                this.deleteFormatButton.setEnabled(true);
            } else {
                this.vstupnyFormatComboBox.setModel(new DefaultComboBoxModel());
                this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel());
                this.e.aktualnyVstupnyFormat = null;
                this.e.aktualnyVystupnyFormat = null;
                this.deleteFormatButton.setEnabled(false);
                this.e.aktualnaTransformacia = null;
            }
        } else {
            this.vstupnyFormatComboBox.setModel(new DefaultComboBoxModel());
            this.addFormatButton.setEnabled(false);
            this.deleteFormatButton.setEnabled(false);
            this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel());
            this.e.aktualnyVstupnyFormat = null;
            this.e.aktualnyVystupnyFormat = null;
            this.e.aktualnaTransformacia = null;
        }
        if (this.transformaciaComboBox != null) {
            this.refreshTransformacie((String)this.transformaciaComboBox.getSelectedItem());
        }
    }

    private void QuitMenuItemActionPerformed(ActionEvent evt) {
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, 201));
    }

    private void addFormatButtonActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(this, "N\u00e1zov nov\u00e9ho form\u00e1tu:", "Prid\u00e1vanie form\u00e1tu", -1, null, null, "");
        if (s != null && this.e.aktualnyOkruh != null) {
            boolean pridane = this.e.aktualnyOkruh.pridajFormat(s);
            HistoriaAddedFormat haf = new HistoriaAddedFormat(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, this.e.aktualnyOkruh.getFormat(s));
            if (pridane) {
                this.changed = true;
                this.historia.pridajZaznam(haf);
                this.refreshTitle();
                this.refreshVstupneFormaty(s);
            } else {
                JOptionPane.showMessageDialog(this, "Form\u00e1t s tak\u00fdmto menom u\u017e existuje.", "U\u017e existuj\u00faci form\u00e1t!", 0);
            }
        }
    }

    private void deleteFormatButtonActionPerformed(ActionEvent evt) {
        int n = JOptionPane.showConfirmDialog(this, "Skuto\u010dne chcete vymaza\u0165 dan\u00fd form\u00e1t?", "Mazanie form\u00e1tu", 0);
        if (n == 0) {
            if (this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null) {
                HistoriaDeletedFormat hdf = new HistoriaDeletedFormat(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, this.e.aktualnyVstupnyFormat, this.e.aktualnyOkruh.formaty.indexOf(this.e.aktualnyVstupnyFormat));
                this.e.aktualnyOkruh.zmazFormat(this.e.aktualnyVstupnyFormat.getMeno());
                this.historia.pridajZaznam(hdf);
                this.changed = true;
                this.refreshTitle();
            }
            this.refreshVstupneFormaty(null);
        }
    }

    public void refreshVystupnyFormat(String vystupnyFormatMeno) {
        this.vystupnyFormatComboBox.removeAllItems();
        if (this.e.conf != null && this.e.aktualnyOkruh != null) {
            if (this.e.aktualnyOkruh.formaty.size() > 0) {
                String[] vystupneFormaty = new String[this.e.aktualnyOkruh.formaty.size()];
                int selectedIndex = 0;
                int counter = 0;
                for (Format f : this.e.aktualnyOkruh.formaty) {
                    if (vystupnyFormatMeno != null && vystupnyFormatMeno.compareTo(f.getMeno()) == 0) {
                        selectedIndex = counter;
                    }
                    vystupneFormaty[counter] = f.getMeno();
                    ++counter;
                }
                this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel<String>(vystupneFormaty));
                this.vystupnyFormatComboBox.setSelectedIndex(selectedIndex);
                this.e.aktualnyVystupnyFormat = (Format)this.e.aktualnyOkruh.formaty.get(selectedIndex);
            } else {
                this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel());
                this.e.aktualnyVystupnyFormat = null;
            }
            this.refreshTransformacie(null);
            return;
        }
        this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel());
        this.refreshTransformacie(null);
    }

    private void addTransformaciaButtonActionPerformed(ActionEvent evt) {
        if (this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null && this.e.aktualnyVystupnyFormat != null) {
            JednoduchaTransformacia newJt = new JednoduchaTransformacia(this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnyOkruh);
            int newId = newJt.id;
            boolean pridane = this.e.aktualnyVstupnyFormat.pridajJednoduchuTransformaciu(newJt);
            if (pridane) {
                HistoriaAddedTransformacia hat = new HistoriaAddedTransformacia(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, newJt);
                this.historia.pridajZaznam(hat);
                JOptionPane.showMessageDialog(this, "Nov\u00e1 transform\u00e1cia \u00faspe\u0161ne pridan\u00e1.", "Pridan\u00e1 transform\u00e1cia.", 1);
                this.refreshTransformacie(new Integer(newId).toString());
                this.changed = true;
                this.refreshTitle();
            } else {
                JOptionPane.showMessageDialog(this, "Nepodarilo sa prida\u0165 transform\u00e1ciu.", "Nepridan\u00e1 transform\u00e1cia!", 0);
            }
        }
    }

    private void deleteTransformaciaButtonActionPerformed(ActionEvent evt) {
        int n;
        if (this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null && this.e.aktualnyVystupnyFormat != null && (n = JOptionPane.showConfirmDialog(this, "Skuto\u010dne chcete vymaza\u0165 dan\u00fa transform\u00e1ciu?", "Mazanie transform\u00e1cie", 0)) == 0 && this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null) {
            HistoriaDeletedTransformacia hdt = new HistoriaDeletedTransformacia(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, this.e.aktualnaTransformacia, this.e.aktualnyVstupnyFormat.jednoducheTransformacie.indexOf(this.e.aktualnaTransformacia));
            boolean odstranene = this.e.aktualnyVstupnyFormat.zmazJTpodlaId(Integer.parseInt((String)this.transformaciaComboBox.getSelectedItem()));
            if (odstranene) {
                this.changed = true;
                this.historia.pridajZaznam(hdt);
                this.refreshTitle();
                this.refreshTransformacie(null);
            }
        }
    }

    private void predpisAreaActionPerformed(KeyEvent evt) {
        try {
            String novyObsahPredpisu;
            String sucasnyObsahPredpisu;
            if (!this.navigationKeyPressed(evt.getKeyCode()) && (sucasnyObsahPredpisu = this.e.aktualnaTransformacia.predpis.printFormattedXML("")).compareTo(novyObsahPredpisu = this.predpisArea.getText()) != 0) {
                this.e.aktualnaTransformacia.predpis.setPredpis(novyObsahPredpisu, "");
                this.changed = true;
                this.refreshTitle();
                this.refreshNodesPanel();
                if (this.errorLabel != null && this.errorLabel.isVisible()) {
                    this.errorLabel.setVisible(false);
                    this.pack();
                    this.myCorrection();
                }
                this.e.aktualnaTransformacia.predpis.lastValue = sucasnyObsahPredpisu;
                HistoriaChangedPredpis hcp = new HistoriaChangedPredpis(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, sucasnyObsahPredpisu, novyObsahPredpisu);
                this.historia.pridajZaznam(hcp);
            }
        }
        catch (ParserConfigurationException ex) {
            this.showError(ex.getMessage());
        }
        catch (SAXException ex) {
            this.showError(ex.getMessage());
        }
        catch (IOException ex) {
            this.showError(ex.getMessage());
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.parentFrame != null) {
            this.parentFrame.setEnabled(true);
            this.parentFrame.reinit();
        }
    }

    public void refreshTransformacie(String setTransformation) {
        if (this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null && this.e.aktualnyVystupnyFormat != null) {
            ArrayList transformacie = this.e.aktualnyVstupnyFormat.getJednoducheTransformacieNaFormat(this.e.aktualnyVystupnyFormat.getMeno());
            if (transformacie.size() > 0) {
                int counter = 0;
                String[] transformacieId = new String[transformacie.size()];
                boolean nastavene = false;
                int newIndex = -1;
                for (JednoduchaTransformacia jt : transformacie) {
                    if (!nastavene) {
                        this.e.aktualnaTransformacia = jt;
                        nastavene = true;
                        this.addTransformaciaButton.setEnabled(true);
                        this.deleteTransformaciaButton.setEnabled(true);
                    }
                    transformacieId[counter] = Integer.valueOf(jt.id).toString();
                    if (setTransformation != null && setTransformation.compareTo(Integer.valueOf(jt.id).toString()) == 0) {
                        newIndex = counter;
                    }
                    ++counter;
                }
                this.transformaciaComboBox.setModel(new DefaultComboBoxModel<String>(transformacieId));
                if (setTransformation != null) {
                    this.transformaciaComboBox.setSelectedIndex(newIndex);
                }
                Integer transfID = Integer.parseInt((String)this.transformaciaComboBox.getSelectedItem());
                this.e.aktualnaTransformacia = this.e.aktualnyVstupnyFormat.getJTPodlaId(transfID);
                this.transformaciaComboBox.setEnabled(true);
                this.transformaciaComboBox.repaint();
                this.predpisArea.setRows(15);
                this.predpisArea.setColumns(50);
                this.refreshPredpisArea(false);
                this.predpisArea.setEnabled(true);
                this.refreshNodesPanel();
                return;
            }
            this.e.aktualnaTransformacia = null;
            this.transformaciaComboBox.setModel(new DefaultComboBoxModel());
            this.transformaciaComboBox.setEnabled(false);
            this.addTransformaciaButton.setEnabled(true);
            this.deleteTransformaciaButton.setEnabled(false);
            this.transformaciaComboBox.repaint();
            this.predpisArea.setEnabled(false);
            this.predpisArea.setText("");
            this.refreshNodesPanel();
            return;
        }
        this.e.aktualnaTransformacia = null;
        this.transformaciaComboBox.setModel(new DefaultComboBoxModel());
        this.addTransformaciaButton.setEnabled(false);
        this.deleteTransformaciaButton.setEnabled(false);
        this.transformaciaComboBox.repaint();
        this.predpisArea.setEnabled(false);
        this.predpisArea.setText("");
        this.mainPanel.validate();
        this.refreshNodesPanel();
    }

    public void refreshPredpisArea() {
        this.refreshPredpisArea(true);
    }

    public void refreshPredpisArea(boolean changedKonfiguracia) {
        if (this.predpisArea != null && this.e.aktualnaTransformacia != null) {
            String sucasnyObsahPredpisu = this.predpisArea.getText();
            String novyObsahPredpisu = new String(this.e.aktualnaTransformacia.predpis.printFormattedXML(""));
            this.predpisArea.setText(novyObsahPredpisu);
            this.predpisArea.getCaret().setDot(0);
            if (changedKonfiguracia) {
                this.changed = true;
                this.e.aktualnaTransformacia.predpis.lastValue = sucasnyObsahPredpisu;
                HistoriaChangedPredpis hcp = new HistoriaChangedPredpis(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, this.e.aktualnaTransformacia, sucasnyObsahPredpisu, novyObsahPredpisu);
                this.historia.pridajZaznam(hcp);
                this.refreshTitle();
                if (this.errorLabel != null && this.errorLabel.isVisible()) {
                    this.errorLabel.setVisible(false);
                    this.pack();
                    this.myCorrection();
                }
            } else if (this.errorLabel != null && this.errorLabel.isVisible()) {
                this.errorLabel.setVisible(false);
                this.pack();
                this.myCorrection();
            }
        }
    }

    public void refreshPrikazPanel() {
        if (this.e.aktualnaTransformacia != null) {
            this.e.aktualnaTransformacia.setVstup(new VstupnySubor("<vstup>"));
            this.e.aktualnaTransformacia.setVystup(new VystupnySubor("<v\u00fdstup>"));
            this.prikazArea.setText(this.e.aktualnaTransformacia.predpis.getValue());
            this.prikazPanel.setVisible(true);
        } else {
            this.prikazPanel.setVisible(false);
        }
        this.repaint();
        this.pack();
    }

    public void refreshNodesPanel() {
        if (this.e.aktualnaTransformacia != null) {
            this.nodePanelScrollPane.setVisible(false);
            this.e.aktualnaTransformacia.setVstup(new VstupnySubor("<vstup>"));
            this.e.aktualnaTransformacia.setVystup(new VystupnySubor("<v\u00fdstup>"));
            this.prikazArea.setText(this.e.aktualnaTransformacia.predpis.getValue());
            this.prikazPanel.setVisible(true);
            this.nodesPanel.removeAll();
            GridBagConstraints nodePanelGbc = new GridBagConstraints();
            nodePanelGbc.fill = 2;
            nodePanelGbc.gridx = 0;
            nodePanelGbc.gridy = 0;
            nodePanelGbc.insets = new Insets(15, 5, 5, 0);
            JLabel nadpis = new JLabel();
            nadpis.setFont(new Font("DejaVu Sans", 1, 12));
            nadpis.setText("Uzly predpisu:");
            this.nodesPanel.add((Component)nadpis, nodePanelGbc);
            nodePanelGbc.insets = new Insets(0, 0, 0, 0);
            SettingsPanel addedPanel = new SettingsPanel();
            addedPanel.parent = this.nodesPanel;
            this.e.aktualnaTransformacia.predpis.paintEditorialPanel(addedPanel, this, new String(""));
            nodePanelGbc.gridy = 1;
            nodePanelGbc.gridwidth = 500;
            nodePanelGbc.fill = 0;
            this.nodesPanel.add((Component)addedPanel, nodePanelGbc);
            if (this.nodesPanel.getPreferredSize().height < this.predpisAreaScrollPane.getPreferredSize().height * 1) {
                this.nodePanelScrollPane.setPreferredSize(new Dimension(this.nodePanelScrollPane.getPreferredSize().width, this.nodesPanel.getPreferredSize().height + 50));
            } else {
                this.nodePanelScrollPane.setPreferredSize(new Dimension(this.mainPanel.getPreferredSize().width, this.predpisAreaScrollPane.getPreferredSize().height * 1));
            }
            this.nodePanelScrollPane.setVisible(true);
        } else {
            this.nodesPanel.removeAll();
            this.nodePanelScrollPane.setVisible(false);
            this.prikazPanel.setVisible(false);
        }
        this.pack();
        this.myCorrection();
    }

    public void refreshAll() {
        String nazovVstupnehoFormatu = this.e.aktualnyVstupnyFormat != null ? new String(this.e.aktualnyVstupnyFormat.getMeno()) : null;
        String nazovVystupnehoFormatu = this.e.aktualnyVystupnyFormat != null ? new String(this.e.aktualnyVystupnyFormat.getMeno()) : null;
        Integer idTransformacie = null;
        if (this.e.aktualnaTransformacia != null) {
            idTransformacie = this.e.aktualnaTransformacia.id;
        }
        this.okruhyComboBox.setModel(new DefaultComboBoxModel());
        this.vstupnyFormatComboBox.setModel(new DefaultComboBoxModel());
        this.vystupnyFormatComboBox.setModel(new DefaultComboBoxModel());
        this.transformaciaComboBox.setModel(new DefaultComboBoxModel());
        this.addOkruhButton.setEnabled(true);
        this.deleteOkruhButton.setEnabled(false);
        this.addFormatButton.setEnabled(false);
        this.deleteFormatButton.setEnabled(false);
        if (!this.e.conf.okruhy.isEmpty()) {
            String[] okruhy = new String[this.e.conf.okruhy.size()];
            int selectedOkruh = 0;
            int counter = 0;
            for (Okruh o : this.e.conf.okruhy) {
                okruhy[counter] = o.getMeno();
                if (this.e.aktualnyOkruh != null && o.getMeno().compareTo(this.e.aktualnyOkruh.getMeno()) == 0) {
                    selectedOkruh = counter;
                }
                ++counter;
            }
            this.okruhyComboBox.setModel(new DefaultComboBoxModel<String>(okruhy));
            this.okruhyComboBox.setSelectedIndex(selectedOkruh);
            this.addOkruhButton.setEnabled(true);
            this.deleteOkruhButton.setEnabled(true);
            if (!this.e.aktualnyOkruh.formaty.isEmpty()) {
                String[] formaty = new String[this.e.aktualnyOkruh.formaty.size()];
                int selectedFormat = 0;
                counter = 0;
                for (Format f : this.e.aktualnyOkruh.formaty) {
                    formaty[counter] = f.getMeno();
                    if (nazovVstupnehoFormatu != null && f.getMeno().compareTo(nazovVstupnehoFormatu) == 0) {
                        selectedFormat = counter;
                    }
                    ++counter;
                }
                this.vstupnyFormatComboBox.setModel(new DefaultComboBoxModel<String>(formaty));
                this.vstupnyFormatComboBox.setSelectedIndex(selectedFormat);
                this.addFormatButton.setEnabled(true);
                this.deleteFormatButton.setEnabled(true);
                if (nazovVystupnehoFormatu != null) {
                    this.refreshVystupnyFormat(nazovVystupnehoFormatu);
                } else {
                    this.refreshVystupnyFormat(null);
                }
            }
        }
        if (idTransformacie != null) {
            this.refreshTransformacie(new Integer(idTransformacie).toString());
        } else {
            this.refreshTransformacie(null);
        }
    }

    public void showError(String error) {
        if (error.compareTo("") == 0) {
            this.errorLabel.setText(error);
            if (this.errorLabel.isVisible()) {
                this.errorLabel.setVisible(false);
                this.mainPanel.repaint();
                this.pack();
                this.myCorrection();
            }
            return;
        }
        this.errorLabel.setText(error);
        this.errorLabel.setVisible(true);
        this.mainPanel.repaint();
        this.pack();
        this.myCorrection();
    }

    public void myCorrection() {
        this.setSize(this.getWidth() + 1, this.getHeight() + 1);
        this.setSize(this.getWidth() - 1, this.getHeight() - 1);
    }

    public boolean navigationKeyPressed(int key) {
        ArrayList<Integer> navigationKeys = new ArrayList<Integer>();
        navigationKeys.add(38);
        navigationKeys.add(40);
        navigationKeys.add(39);
        navigationKeys.add(37);
        return navigationKeys.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfiguration(ActionEvent evt) {
        if (this.e.conf != null) {
            if (this.e.nacitanyKonfiguracnySubor != null) {
                FileOutputStream erasor = null;
                String cesta = this.e.nacitanyKonfiguracnySubor.getAbsolutePath();
                try {
                    erasor = new FileOutputStream(cesta);
                    erasor.write(new String().getBytes());
                    FileOutputStream writer = new FileOutputStream(cesta);
                    writer.write(this.e.conf.printFormattedXML().getBytes());
                    writer.flush();
                    writer.close();
                    this.changed = false;
                    this.refreshTitle();
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
                }
                finally {
                    try {
                        erasor.close();
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
                    }
                }
            } else {
                this.saveAsConfiguration(evt);
            }
        }
    }

    public void saveAsConfiguration(ActionEvent evt) {
        PathManager pm = new PathManager();
        JFileChooser fc = new JFileChooser(pm.getProjectPath());
        fc.setFileSelectionMode(0);
        fc.setSelectedFile(new File("newConfiguration.xml"));
        int returnVal = fc.showSaveDialog(this.SaveAsMenuItem);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String cesta = file.getAbsolutePath();
            if (file.exists()) {
                try {
                    FileOutputStream erasor = new FileOutputStream(cesta);
                    try {
                        erasor.write(new String().getBytes());
                    }
                    catch (IOException ex) {
                        JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
                    }
                }
                catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null, "Chyba na\u010d\u00edtavania s\u00faboru!", "", 0);
                }
            }
            try {
                FileOutputStream writer = new FileOutputStream(cesta);
                writer.write(this.e.conf.printFormattedXML().getBytes());
                writer.flush();
                writer.close();
                this.e.nacitanyKonfiguracnySubor = new File(cesta);
                this.changed = false;
                this.refreshTitle();
                JOptionPane.showMessageDialog(null, "S\u00fabor \u00faspe\u0161ne ulo\u017een\u00fd!", "", 1);
            }
            catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null, "Chyba z\u00e1pisu do s\u00faboru!", "", 0);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Chyba z\u00e1pisu do s\u00faboru!", "", 0);
            }
        }
    }
}

