/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.BCrypt;
import bakalarka.PathManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class ProgramSettingsHandler {
    boolean existingPassword = false;
    String hashedPassword = "";
    static final String tabulator = "   ";
    String transformacieConfigurationFile;

    public ProgramSettingsHandler() throws FileNotFoundException, IOException {
        PathManager pm = new PathManager();
        this.transformacieConfigurationFile = pm.getProjectPath().concat("/Transformations.xml");
        this.loadPassword();
        this.loadTransformationsFile();
    }

    public String getConfigPath() {
        PathManager pm = new PathManager();
        return pm.getProjectPath().concat("/settings.conf");
    }

    public boolean loadTransformationsFile() throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.getConfigPath()));
        String transFile = in.readLine();
        while (transFile != null) {
            if (transFile.startsWith("TransformationsFile") && (transFile = transFile.substring(19).trim()).compareTo("") != 0) {
                PathManager pm = new PathManager();
                this.transformacieConfigurationFile = this.isRelativePath(transFile) ? pm.getProjectPath().concat("/").concat(transFile) : transFile;
                in.close();
                return true;
            }
            transFile = in.readLine();
        }
        in.close();
        return false;
    }

    public String getTransformationsFilePath() throws FileNotFoundException, IOException {
        this.loadTransformationsFile();
        return this.transformacieConfigurationFile;
    }

    public boolean loadPassword() throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.getConfigPath()));
        String riadok = in.readLine();
        while (riadok != null) {
            String password;
            if (riadok.startsWith("Password") && (password = riadok.substring(8).trim()).compareTo("") != 0) {
                this.hashedPassword = password;
                in.close();
                this.existingPassword = true;
                return true;
            }
            riadok = in.readLine();
        }
        in.close();
        this.existingPassword = false;
        return false;
    }

    public boolean checkPassword(String candidate) throws FileNotFoundException, IOException {
        this.loadPassword();
        if (!this.existingPassword) {
            return true;
        }
        return BCrypt.checkpw(candidate, this.hashedPassword);
    }

    public boolean isPasswordSet() throws FileNotFoundException, IOException {
        this.loadPassword();
        return this.existingPassword;
    }

    public void writePassword(String password) throws FileNotFoundException, IOException {
        String salt = BCrypt.gensalt();
        String hashed = BCrypt.hashpw(password, salt);
        String new_content = new String("");
        BufferedReader in = new BufferedReader(new FileReader(this.getConfigPath()));
        String riadok = in.readLine();
        boolean oldPasswordFound = false;
        while (riadok != null) {
            if (riadok.startsWith("Password")) {
                oldPasswordFound = true;
                new_content = new_content.concat("Password ").concat(hashed).concat(System.getProperty("line.separator"));
            } else if (riadok.compareTo("") != 0) {
                new_content = new_content.concat(riadok).concat(System.getProperty("line.separator"));
            }
            riadok = in.readLine();
        }
        FileOutputStream erasor = new FileOutputStream(this.getConfigPath());
        erasor.write(new String().getBytes());
        if (!oldPasswordFound) {
            new_content = new_content.concat("Password ").concat(hashed).concat(System.getProperty("line.separator"));
        }
        FileOutputStream writer = new FileOutputStream(this.getConfigPath());
        writer.write(new_content.getBytes());
        writer.flush();
        writer.close();
    }

    public void writeTransformationsFile(String path) throws FileNotFoundException, IOException {
        BufferedReader in = new BufferedReader(new FileReader(this.getConfigPath()));
        String riadok = in.readLine();
        String new_content = new String("");
        while (riadok != null) {
            if (riadok.startsWith("TransformationsFile")) {
                new_content = new_content.concat("TransformationsFile ").concat(path).concat(System.getProperty("line.separator"));
            } else if (riadok.compareTo("") != 0) {
                new_content = new_content.concat(riadok).concat(System.getProperty("line.separator"));
            }
            riadok = in.readLine();
        }
        FileOutputStream erasor = new FileOutputStream(this.getConfigPath());
        erasor.write(new String().getBytes());
        FileOutputStream writer = new FileOutputStream(this.getConfigPath());
        writer.write(new_content.getBytes());
        writer.flush();
        writer.close();
    }

    public boolean isRelativePath(String path) {
        return path.length() <= 0 || path.charAt(0) != '/';
    }
}

