/*
 * Decompiled with CFR 0.152.
 */
package bakalarka;

import bakalarka.Format;
import bakalarka.JednoduchaTransformacia;
import bakalarka.Okruh;
import bakalarka.VstupnySubor;
import bakalarka.VystupnySubor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class TransformacnaRetaz {
    public Format from;
    public Format to;
    public int dlzka;
    public ArrayList transformacie;
    public int id;
    public Okruh mojOkruh;

    public TransformacnaRetaz(JednoduchaTransformacia jt) {
        this.transformacie = new ArrayList();
        this.from = jt.from;
        this.to = jt.to;
        this.mojOkruh = this.from.mojOkruh;
        this.dlzka = 1;
        this.id = this.mojOkruh.getTransformacneRetazeCounter();
        this.transformacie.add(jt);
    }

    private TransformacnaRetaz(TransformacnaRetaz tr) {
        this.from = tr.from;
        this.to = tr.to;
        this.dlzka = tr.dlzka;
        this.mojOkruh = tr.mojOkruh;
        this.id = this.mojOkruh.getTransformacneRetazeCounter();
        this.transformacie = new ArrayList();
        Iterator i = tr.transformacie.iterator();
        while (i.hasNext()) {
            this.transformacie.add(i.next());
        }
    }

    public boolean pridajTransformaciu(JednoduchaTransformacia jt) {
        boolean pridane = false;
        if (!this.mojOkruh.equals(jt.mojOkruh)) {
            return false;
        }
        if (jt.from.getMeno().compareTo(((JednoduchaTransformacia)this.transformacie.get((int)(this.transformacie.size() - 1))).to.getMeno()) != 0) {
            return false;
        }
        pridane = this.transformacie.add(jt);
        if (pridane) {
            this.to = jt.to;
            ++this.dlzka;
        }
        return pridane;
    }

    public boolean pridajTransformacnuRetaz(TransformacnaRetaz tr) {
        boolean pridane = false;
        if (!this.mojOkruh.equals(tr.mojOkruh)) {
            return false;
        }
        if (this.to.getMeno().compareTo(tr.from.getMeno()) != 0) {
            return false;
        }
        pridane = this.transformacie.addAll(tr.transformacie);
        if (pridane) {
            this.to = tr.to;
            this.dlzka += tr.dlzka;
        }
        return pridane;
    }

    public TransformacnaRetaz zretaz(JednoduchaTransformacia jt) {
        TransformacnaRetaz kopia = new TransformacnaRetaz(this);
        kopia.pridajTransformaciu(jt);
        return kopia;
    }

    public TransformacnaRetaz zretaz(TransformacnaRetaz tr) {
        TransformacnaRetaz kopia = new TransformacnaRetaz(this);
        kopia.pridajTransformacnuRetaz(tr);
        return kopia;
    }

    public void vypis() {
        System.out.println("Transformacna retaz dlzky " + this.dlzka + " s id " + this.id + " z okruhu " + this.mojOkruh.getMeno() + ": " + this.from.getMeno() + " -> " + this.to.getMeno());
        int counter = 1;
        Iterator i = this.transformacie.iterator();
        while (i.hasNext()) {
            System.out.print("Krok " + counter + ":");
            ++counter;
            ((JednoduchaTransformacia)i.next()).vypis();
        }
        System.out.println();
        System.out.println();
    }

    public boolean spolocnyFormat(TransformacnaRetaz tr) {
        if (this.dlzka == 0 || tr.dlzka == 0) {
            return false;
        }
        Object[] formaty = new String[this.dlzka + tr.dlzka + 1];
        int counter = 0;
        String lastTo = "";
        Iterator i = this.transformacie.iterator();
        while (i.hasNext()) {
            JednoduchaTransformacia jt = (JednoduchaTransformacia)i.next();
            formaty[counter] = jt.from.getMeno();
            if (!i.hasNext()) {
                lastTo = jt.to.getMeno();
            }
            ++counter;
        }
        formaty[counter] = lastTo;
        ++counter;
        i = tr.transformacie.iterator();
        while (i.hasNext()) {
            formaty[counter] = ((JednoduchaTransformacia)i.next()).to.getMeno();
            ++counter;
        }
        Arrays.sort(formaty);
        for (int j = 0; j < formaty.length - 1; ++j) {
            if (((String)formaty[j]).compareTo((String)formaty[j + 1]) != 0) continue;
            return true;
        }
        return false;
    }

    public String vypisCesty() {
        String vysledok = "";
        Iterator i = this.transformacie.iterator();
        while (i.hasNext()) {
            JednoduchaTransformacia jt = (JednoduchaTransformacia)i.next();
            vysledok = vysledok.concat(jt.from.getMeno() + "->" + jt.to.getMeno());
            if (!i.hasNext()) continue;
            vysledok = vysledok.concat(", ");
        }
        return vysledok;
    }

    public boolean isConfigurable() {
        for (JednoduchaTransformacia jt : this.transformacie) {
            if (!jt.isConfigurable()) continue;
            return true;
        }
        return false;
    }

    public void setVstup(VstupnySubor vstup) {
        for (JednoduchaTransformacia jt : this.transformacie) {
            jt.setVstup(vstup);
        }
    }

    public void setVystup(VystupnySubor vystup) {
        for (JednoduchaTransformacia jt : this.transformacie) {
            jt.setVystup(vystup);
        }
    }
}

