package bakalarka;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;
import javax.swing.KeyStroke;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;


public class AdministraciaFrame extends javax.swing.JFrame {
        
    public BakalarkaMainFrame parentFrame = null;
    public Editor e = null;
    public boolean changed = false;
    public AdministraciaHistoria historia = new AdministraciaHistoria(this);
    
    JMenuBar AdministraciaMenuBar;
    JMenu SuborMenu;
    JMenuItem newFileItem;
    JMenuItem SaveMenuItem;
    JMenuItem SaveAsMenuItem;
    JMenuItem SaveAsDefaultMenuItem;
    JMenuItem LoadMenuItem;
    JMenuItem LoadDefaultMenuItem;    
    JMenu EditMenu;
    JMenuItem UndoMenuItem;
    JMenuItem RedoMenuItem;
    JMenuItem QuitMenuItem;
    
    SettingsPanel mainPanel;
    JLabel nadpisLabel;
    JLabel okruhLabel;
    JComboBox okruhyComboBox;
    JButton addOkruhButton;
    JButton deleteOkruhButton;
    JLabel format1Label;
    JComboBox vstupnyFormatComboBox;
    JButton addFormatButton;
    JButton deleteFormatButton;
    JComboBox vystupnyFormatComboBox;
    JLabel format2Label;
    JLabel transformaciaLabel;
    JComboBox transformaciaComboBox;
    JButton addTransformaciaButton;
    JButton deleteTransformaciaButton;
    JTextArea predpisArea;
    JScrollPane predpisAreaScrollPane;    
    JSeparator jSeparator1;
    JPanel prikazPanel;
    JTextArea prikazArea;
    JScrollPane prikazPanelScrollPane;
    SettingsPanel nodesPanel;
    JScrollPane nodePanelScrollPane;
    JLabel errorLabel;

    JSeparator menuSeparator1;
    JSeparator menuSeparator2;
    
    
    /** Creates new form SettingsFrame */
    public AdministraciaFrame() {
        e = new Editor();
        try {
            ProgramSettingsHandler psh = new ProgramSettingsHandler();
            e.loadConfiguration(psh.getTransformationsFilePath());
            this.setTitle(e.nacitanyKonfiguracnySubor.getAbsolutePath());
        } catch (ParserConfigurationException ex) {
            showError(ex.getMessage());
        } catch (IOException ex) {
            showError(ex.getMessage());
        } catch (SAXException ex) {
            showError(ex.getMessage());
        }        
        this.setVisible(true);
        initComponents();
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
    }
    
    public void loadNewConfiguration(File f) {
        try {
            e.loadConfiguration(f);
            mainPanel.removeAll();
            initComponents();
            if (errorLabel != null) {
                errorLabel.setVisible(false);
            }
            this.changed = false;
            this.setTitle(f.getAbsolutePath());
            repaint();
            pack();
            myCorrection();
            
        } catch (ParserConfigurationException ex) {
            JOptionPane.showMessageDialog(null,
                "Chyba!",
                "",
                JOptionPane.ERROR_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(null,
                "Chyba načítavania súboru!",
                "",
                JOptionPane.ERROR_MESSAGE);
        } catch (SAXException ex) {
            JOptionPane.showMessageDialog(null,
                "Chyba v štruktúre súboru!",
                "",
                JOptionPane.ERROR_MESSAGE);
        }
    }
    
    
    public void refreshTitle() {        
        String title = "Nový súbor";
        if (e.nacitanyKonfiguracnySubor != null) {
            title = this.e.nacitanyKonfiguracnySubor.getAbsolutePath();
        }
        if (changed) {
            title = "*" + title;
        }
        this.setTitle(title);
    }

   public void setParentFrame(BakalarkaMainFrame bmf) {
        this.parentFrame = bmf;
        bmf.setEnabled(false);
    }    
    
    private void initComponents() {
        final AdministraciaFrame helpReference = this;
        
        mainPanel = new SettingsPanel();
        mainPanel.setLayout(new java.awt.GridBagLayout());
        
        AdministraciaMenuBar = new JMenuBar();
        
        SuborMenu = new JMenu("Súbor");
        
        newFileItem = new JMenuItem("Nový");
        newFileItem.setAccelerator(KeyStroke.getKeyStroke('N',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
        LoadMenuItem = new JMenuItem("Načítať súbor");
        LoadMenuItem.setAccelerator(KeyStroke.getKeyStroke('O',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
        LoadDefaultMenuItem = new JMenuItem("Načítať defaultný súbor");

        menuSeparator1 = new JSeparator();

        SaveMenuItem = new JMenuItem("Uložiť");
        SaveMenuItem.setAccelerator(KeyStroke.getKeyStroke('S',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
        
        
        SaveAsMenuItem = new JMenuItem("Uložiť ako");
        SaveAsDefaultMenuItem = new JMenuItem("Uložiť ako predvolené");
        SaveAsDefaultMenuItem.setAccelerator(KeyStroke.getKeyStroke('D',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));

        menuSeparator2 = new JSeparator();

        QuitMenuItem = new JMenuItem("Koniec");
        QuitMenuItem.setAccelerator(KeyStroke.getKeyStroke('Q',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));

        SuborMenu.add(newFileItem);
        SuborMenu.add(LoadMenuItem);
        SuborMenu.add(LoadDefaultMenuItem);
        SuborMenu.add(menuSeparator1);
        SuborMenu.add(SaveMenuItem);
        SuborMenu.add(SaveAsMenuItem);
        SuborMenu.add(SaveAsDefaultMenuItem);
        SuborMenu.add(menuSeparator2);
        SuborMenu.add(QuitMenuItem);
        
        AdministraciaMenuBar.add(SuborMenu);
        
        
        EditMenu = new JMenu("Editovať");
        
        UndoMenuItem = new JMenuItem("Späť");
        UndoMenuItem.setEnabled(false);
        UndoMenuItem.setAccelerator(KeyStroke.getKeyStroke('Z',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
        RedoMenuItem = new JMenuItem("Dopredu");
        RedoMenuItem.setEnabled(false);
        RedoMenuItem.setAccelerator(KeyStroke.getKeyStroke('Y',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
        
        EditMenu.add(UndoMenuItem);
        EditMenu.add(RedoMenuItem);
        
        AdministraciaMenuBar.add(EditMenu);
        
        setJMenuBar(AdministraciaMenuBar);
        
        
        newFileItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                e = new Editor();
                mainPanel.removeAll();
                initComponents();
                changed = false;
                refreshTitle();
            }
        });
        
        LoadMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PathManager pm = new PathManager();                
                JFileChooser fc = new JFileChooser(pm.getProjectPath());
                fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
                int returnVal = fc.showOpenDialog(LoadMenuItem);
                if (returnVal == JFileChooser.APPROVE_OPTION) {
                    File file = fc.getSelectedFile();
                    loadNewConfiguration(file);
                }
            }
        });
        
        LoadDefaultMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                try {
                    ProgramSettingsHandler psh = new ProgramSettingsHandler();
                    File f = new File(psh.getTransformationsFilePath());
                    loadNewConfiguration(f);
                } catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null,
                        "Neexistujúci deklarovaný defaultný konfiguračný súbor!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                } catch (IOException ex) {
                    JOptionPane.showMessageDialog(null,
                        "Chyba načítavania súboru!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                }
                
            }
        });
        
        SaveMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveConfiguration(evt);
            }
        });
        
        SaveAsMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveAsConfiguration(evt);
            }
        });
        
        SaveAsDefaultMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                try {
                    saveConfiguration(evt);
                    ProgramSettingsHandler psh = new ProgramSettingsHandler();
                    psh.writeTransformationsFile(e.nacitanyKonfiguracnySubor.getAbsolutePath());
                    JOptionPane.showMessageDialog(null,
                                "Defaultný súbor transformácii zmenený na "+e.nacitanyKonfiguracnySubor.getAbsolutePath()+"!",
                                "",
                                JOptionPane.INFORMATION_MESSAGE);
                } catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null,
                                "Neexistujúci súbor!",
                                "",
                                JOptionPane.ERROR_MESSAGE);
                } catch (IOException ex) {
                    JOptionPane.showMessageDialog(null,
                                "Chyba načítavania súboru!",
                                "",
                                JOptionPane.ERROR_MESSAGE);
                }
               
        }
        });
        
        UndoMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpReference.historia.undo();
                if (! changed) {
                    changed = true;
                    refreshTitle();
                }
            }
        });
        
        RedoMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                helpReference.historia.redo();
                if (! changed) {
                    changed = true;
                    refreshTitle();
                }
            }
        });

        QuitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                QuitMenuItemActionPerformed(evt);
            }
        });
        
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        
        
        GridBagConstraints mainGridBagConstraints = new GridBagConstraints();
        mainGridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        mainGridBagConstraints.anchor = java.awt.GridBagConstraints.FIRST_LINE_START;
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 0;
        mainGridBagConstraints.gridwidth = 3;
        mainGridBagConstraints.insets = new Insets(10, 50, 10, 0);
        
        nadpisLabel = new javax.swing.JLabel();
        nadpisLabel.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        nadpisLabel.setText("Administrácia programu");        
        mainPanel.add(nadpisLabel, mainGridBagConstraints);
        mainGridBagConstraints.insets = new Insets(5, 5, 5, 5);
        mainGridBagConstraints.anchor = GridBagConstraints.LINE_START;
        mainGridBagConstraints.gridwidth = 1;
        
        
        
        
        okruhLabel = new JLabel();
        okruhLabel.setText("Okruh:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 1;
        mainPanel.add(okruhLabel, mainGridBagConstraints);
        
        okruhyComboBox = new javax.swing.JComboBox();
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 1;
        mainPanel.add(okruhyComboBox, mainGridBagConstraints);
        okruhyComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshOkruhy((String) okruhyComboBox.getSelectedItem());
            }
        });
        
        addOkruhButton = new javax.swing.JButton();
        addOkruhButton.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        addOkruhButton.setText("+");
        mainGridBagConstraints.gridx = 2;
        mainGridBagConstraints.gridy = 1;
        mainPanel.add(addOkruhButton, mainGridBagConstraints);
        addOkruhButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addOkruhButtonActionPerformed(evt);
            }
        });
        
        deleteOkruhButton = new javax.swing.JButton();
        deleteOkruhButton.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        deleteOkruhButton.setText("-");
        deleteOkruhButton.setEnabled(this.e.aktualnyOkruh != null);
        mainGridBagConstraints.gridx = 3;
        mainGridBagConstraints.gridy = 1;
        mainPanel.add(deleteOkruhButton, mainGridBagConstraints);
        deleteOkruhButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteOkruhButtonActionPerformed(evt);
            }
        });
        refreshOkruhy(null);
        
        
        format1Label = new JLabel();
        format1Label.setText("Format:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 2;
        mainPanel.add(format1Label, mainGridBagConstraints);        
        
        vstupnyFormatComboBox = new javax.swing.JComboBox();
        vystupnyFormatComboBox = new javax.swing.JComboBox();
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 2;
        mainPanel.add(vstupnyFormatComboBox, mainGridBagConstraints);
        vstupnyFormatComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshVstupneFormaty((String) vstupnyFormatComboBox.getSelectedItem());
            }
        });
        
        addFormatButton = new javax.swing.JButton();
        addFormatButton.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        addFormatButton.setText("+");
        if (this.e.aktualnyOkruh == null) {
            addFormatButton.setEnabled(false);
        }
        mainGridBagConstraints.gridx = 2;
        mainGridBagConstraints.gridy = 2;
        mainPanel.add(addFormatButton, mainGridBagConstraints);
        addFormatButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addFormatButtonActionPerformed(evt);
            }
        });
        
        deleteFormatButton = new javax.swing.JButton();
        deleteFormatButton.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        deleteFormatButton.setText("-");
        if (this.e.aktualnyVstupnyFormat == null) {
            deleteFormatButton.setEnabled(false);
        }
        mainGridBagConstraints.gridx = 3;
        mainGridBagConstraints.gridy = 2;
        mainPanel.add(deleteFormatButton, mainGridBagConstraints);
        deleteFormatButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteFormatButtonActionPerformed(evt);
            }
        });
        refreshVstupneFormaty(null);
        
        format2Label = new JLabel();
        format2Label.setText("Výstup:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 3;
        mainPanel.add(format2Label, mainGridBagConstraints);
        
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 3;
        mainPanel.add(vystupnyFormatComboBox, mainGridBagConstraints);
        vystupnyFormatComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {               
                refreshVystupnyFormat((String) vystupnyFormatComboBox.getSelectedItem());
            }
        });
        
        transformaciaLabel = new JLabel();
        transformaciaLabel.setText("Transformácia:");
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 4;
        mainPanel.add(transformaciaLabel, mainGridBagConstraints);
        
        transformaciaComboBox = new javax.swing.JComboBox();
        mainGridBagConstraints.gridx = 1;
        mainGridBagConstraints.gridy = 4;
        mainPanel.add(transformaciaComboBox, mainGridBagConstraints);
        transformaciaComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshTransformacie((String) transformaciaComboBox.getSelectedItem());
            }
        });
        
        addTransformaciaButton = new javax.swing.JButton();
        addTransformaciaButton.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        addTransformaciaButton.setText("+");
        addTransformaciaButton.setEnabled(false);
        mainGridBagConstraints.gridx = 2;
        mainGridBagConstraints.gridy = 4;
        mainPanel.add(addTransformaciaButton, mainGridBagConstraints);
        addTransformaciaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addTransformaciaButtonActionPerformed(evt);
            }
        });
        
        deleteTransformaciaButton = new javax.swing.JButton();
        deleteTransformaciaButton.setFont(new java.awt.Font("DejaVu Sans", 1, 14));
        deleteTransformaciaButton.setText("-");
        deleteTransformaciaButton.setEnabled(false);
        mainGridBagConstraints.gridx = 3;
        mainGridBagConstraints.gridy = 4;
        mainPanel.add(deleteTransformaciaButton, mainGridBagConstraints);
        deleteTransformaciaButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteTransformaciaButtonActionPerformed(evt);
            }
        });
        
        predpisArea = new JTextArea();
        
        predpisArea.setLineWrap(true);
        predpisArea.setWrapStyleWord(true);
        predpisArea.setRows(15);
        predpisArea.setColumns(50);
        
        mainGridBagConstraints.gridwidth = 4;
        mainGridBagConstraints.gridheight = 4;
        mainGridBagConstraints.gridx = 5;
        mainGridBagConstraints.gridy = 1;
        mainGridBagConstraints.insets = new Insets(0, 30, 0, 0);
        predpisAreaScrollPane = new JScrollPane(predpisArea);
        predpisAreaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        
        predpisArea.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyReleased(java.awt.event.KeyEvent evt) {
                predpisAreaActionPerformed(evt);                
            }
        });
        
        mainPanel.add(predpisAreaScrollPane, mainGridBagConstraints);
        mainGridBagConstraints.gridwidth = 1;
        mainGridBagConstraints.gridheight = 1;
        
        
        jSeparator1 = new javax.swing.JSeparator(JSeparator.HORIZONTAL);
        mainGridBagConstraints.fill = GridBagConstraints.HORIZONTAL;
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy = 5;
        mainGridBagConstraints.gridwidth = 4;        
        mainPanel.add(jSeparator1, mainGridBagConstraints);
        mainGridBagConstraints.gridwidth = 1;
        
        
        prikazPanel = new JPanel(new GridBagLayout());
        prikazPanel.setVisible(false);
        GridBagConstraints prikazPanelGBC = new GridBagConstraints();
        prikazPanelGBC.insets = new Insets(0, 0, 0, 0);
        prikazPanelGBC.fill = GridBagConstraints.NONE;
        prikazPanelGBC.anchor = GridBagConstraints.LINE_START;
        prikazPanelGBC.gridx = 0;
        prikazPanelGBC.gridy = 0;
        prikazPanel.add(new JLabel("Príkaz:"), prikazPanelGBC);
        
        prikazPanelGBC.gridx = 1;
        prikazPanelGBC.gridy = 0;
        prikazPanelGBC.insets = new Insets(0, 15, 0, 0);
        prikazArea = new JTextArea(1, 70);
        prikazArea.setEditable(false);
        prikazPanelScrollPane = new JScrollPane(prikazArea);
        prikazPanelScrollPane.setVerticalScrollBarPolicy(
                JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        prikazPanelScrollPane.setHorizontalScrollBarPolicy(
                JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        prikazPanel.add(prikazPanelScrollPane, prikazPanelGBC);
        
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy++;
        mainGridBagConstraints.gridwidth = 100;
        mainGridBagConstraints.fill = GridBagConstraints.NONE;
        mainGridBagConstraints.insets = new Insets(10, 15, 0, 0);
        mainPanel.add(prikazPanel, mainGridBagConstraints);
        mainGridBagConstraints.gridwidth = 1;
        
        

        nodesPanel = new SettingsPanel();
        nodesPanel.parent = mainPanel;
        nodesPanel.setLayout(new java.awt.GridBagLayout());

        JPanel panel = new JPanel(new java.awt.BorderLayout());
        panel.add(nodesPanel, java.awt.BorderLayout.WEST);
        
        nodePanelScrollPane = new JScrollPane(panel);
        nodePanelScrollPane.setVerticalScrollBarPolicy(
                JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
        nodePanelScrollPane.setHorizontalScrollBarPolicy(
                JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        nodePanelScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        nodePanelScrollPane.setPreferredSize(new Dimension(mainPanel.getPreferredSize().width, predpisAreaScrollPane.getPreferredSize().height*1));
        nodePanelScrollPane.setVisible(false);
        

        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy++;
        mainGridBagConstraints.gridwidth = 100;
        mainGridBagConstraints.anchor = GridBagConstraints.FIRST_LINE_START;
        mainGridBagConstraints.fill = GridBagConstraints.NONE;
        mainGridBagConstraints.insets = new Insets(15, 0, 5, 0);
        mainPanel.add(nodePanelScrollPane, mainGridBagConstraints);
        mainGridBagConstraints.fill = GridBagConstraints.BOTH;
        mainGridBagConstraints.gridwidth = 1;
        
        errorLabel = new JLabel("");
        errorLabel.setFont(new Font("DejaVu Sans", 0, 12));
        errorLabel.setForeground(Color.RED);
        errorLabel.setVisible(false);
        mainGridBagConstraints.insets = new Insets(10, 10, 5, 0);
        mainGridBagConstraints.gridx = 0;
        mainGridBagConstraints.gridy++;
        mainGridBagConstraints.gridwidth = 100;
        mainGridBagConstraints.anchor = GridBagConstraints.FIRST_LINE_START;
        mainGridBagConstraints.fill = GridBagConstraints.NONE;
        mainPanel.add(errorLabel, mainGridBagConstraints);
        
        
        refreshTransformacie(null);
        
        getContentPane().add(mainPanel);
        
        pack();
    }
    
    public void refreshOkruhy(String setOkruh) {
        if (e.confLoaded() && e.conf.okruhy != null) {
            if (e.conf.okruhy.size() > 0) {
                int newIndex = -1;
                String[] okruhyMena = new String[e.conf.okruhy.size()];
                int counter = 0;
                for (Iterator i = this.e.conf.okruhy.iterator(); i.hasNext();) {
                    Okruh spracovavany = ((Okruh) i.next());
                    okruhyMena[counter] = spracovavany.meno;
                    if (setOkruh != null && spracovavany.getMeno().compareTo(setOkruh) == 0) {
                        newIndex = counter;
                    }
                    counter++;
                }
                okruhyComboBox.setModel(new javax.swing.DefaultComboBoxModel(okruhyMena));
                if (setOkruh != null && newIndex != -1) {
                    okruhyComboBox.setSelectedIndex(newIndex);
                }
                this.e.aktualnyOkruh = e.conf.getOkruh((String) okruhyComboBox.getSelectedItem());
            }
            else {
                okruhyComboBox.setModel(new javax.swing.DefaultComboBoxModel());
                this.e.aktualnyOkruh = null;
            }
        }
        else {
            e.aktualnyOkruh = null;
        }
        addOkruhButton.setEnabled(true);
        if (e.aktualnyOkruh != null) {
            deleteOkruhButton.setEnabled(true);
        }
        else {
            deleteOkruhButton.setEnabled(false);
            this.e.aktualnyVstupnyFormat = null;
            this.e.aktualnyVystupnyFormat = null;
            this.e.aktualnaTransformacia = null;
        }
        if (vstupnyFormatComboBox != null) {
            refreshVstupneFormaty(null);
        }
        if (transformaciaComboBox != null) {
            refreshTransformacie(null);
        }
    }
    
    private void addOkruhButtonActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(
                    this,
                    "Názov nového okruhu formátov:",
                    "Pridávanie okruhu",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    "");
        if (s != null) {
            boolean pridane = this.e.conf.pridajOkruh(s);
            HistoriaAddedOkruh hao = new HistoriaAddedOkruh(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, 
                    this.e.aktualnaTransformacia, this.e.conf.getOkruh(s));
            if (pridane) {
                this.changed = true;
                this.historia.pridajZaznam(hao);
                refreshTitle();
                refreshOkruhy(s);
            }
            else {
                JOptionPane.showMessageDialog(this,
                    "Okruh s takýmto menom už existuje.",
                    "Už existujúci okruh!",
                    JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
    private void deleteOkruhButtonActionPerformed(ActionEvent evt) {
        int n = JOptionPane.showConfirmDialog(
                    this,
                    "Skutočne chcete vymazať daný okruh?",
                    "Mazanie okruhu",
                    JOptionPane.YES_NO_OPTION);
        if (n == 0) {
            if (e.aktualnyOkruh != null) {
                HistoriaDeletedOkruh hdo = new HistoriaDeletedOkruh(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, 
                    this.e.aktualnaTransformacia, this.e.aktualnyOkruh, this.e.conf.okruhy.indexOf(this.e.aktualnyOkruh));
                this.e.conf.zmazOkruh(e.aktualnyOkruh.getMeno());
                this.historia.pridajZaznam(hdo);
                this.changed = true;
                refreshTitle();
            }
            refreshOkruhy(null);
        }
    }
    
    public void refreshVstupneFormaty(String setFormat) {
        if (this.e.aktualnyOkruh != null) {
            String oldVystupnyFormat = (String) this.vystupnyFormatComboBox.getSelectedItem();
            String newVystupnyFormat = null;
            addFormatButton.setEnabled(true);
            if (this.e.aktualnyOkruh.formaty.size() > 0) {
                int newIndex = -1;
                String[] vstupneFormaty = new String[this.e.aktualnyOkruh.formaty.size()];
                int counter = 0;
                for (Iterator i = this.e.aktualnyOkruh.formaty.iterator(); i.hasNext();) {
                    Format f = (Format) i.next();
                    if (setFormat != null && setFormat.compareTo(f.getMeno()) == 0) {
                        newIndex = counter;
                    }
                    vstupneFormaty[counter] = f.getMeno();
                    if (oldVystupnyFormat!= null && oldVystupnyFormat.compareTo(vstupneFormaty[counter]) == 0) {
                        newVystupnyFormat = vstupneFormaty[counter];
                    }
                    counter++;
                }            
                vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
                vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
                if (newVystupnyFormat != null) {
                    vystupnyFormatComboBox.setSelectedItem(newVystupnyFormat);
                }
                if (setFormat != null && newIndex != -1) {
                    this.vstupnyFormatComboBox.setSelectedIndex(newIndex);
                }
                this.e.aktualnyVstupnyFormat = this.e.aktualnyOkruh.getFormat((String) this.vstupnyFormatComboBox.getSelectedItem()) ;
                this.e.aktualnyVystupnyFormat = this.e.aktualnyOkruh.getFormat((String) this.vystupnyFormatComboBox.getSelectedItem()) ;
                deleteFormatButton.setEnabled(true);
            }
            else {
                vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
                vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
                this.e.aktualnyVstupnyFormat = null;
                this.e.aktualnyVystupnyFormat = null;
                deleteFormatButton.setEnabled(false);
                this.e.aktualnaTransformacia = null;
            }
        }
        else {
            vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
            addFormatButton.setEnabled(false);
            deleteFormatButton.setEnabled(false);
            vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
            this.e.aktualnyVstupnyFormat = null;
            this.e.aktualnyVystupnyFormat = null;
            this.e.aktualnaTransformacia = null;
        }
        if (transformaciaComboBox != null) {
            refreshTransformacie((String) this.transformaciaComboBox.getSelectedItem());
        }
    }

    private void QuitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }
    
    private void addFormatButtonActionPerformed(ActionEvent evt) {
        String s = (String)JOptionPane.showInputDialog(
                    this,
                    "Názov nového formátu:",
                    "Pridávanie formátu",
                    JOptionPane.PLAIN_MESSAGE,
                    null,
                    null,
                    "");
        if (s != null && e.aktualnyOkruh != null) {
            boolean pridane = this.e.aktualnyOkruh.pridajFormat(s);
            HistoriaAddedFormat haf = new HistoriaAddedFormat(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, 
                    this.e.aktualnaTransformacia, this.e.aktualnyOkruh.getFormat(s));
            if (pridane) {
                this.changed = true;
                this.historia.pridajZaznam(haf);
                refreshTitle();
                refreshVstupneFormaty(s);
            }
            else {
                JOptionPane.showMessageDialog(this,
                    "Formát s takýmto menom už existuje.",
                    "Už existujúci formát!",
                    JOptionPane.ERROR_MESSAGE);
            }
        }
    }
    
    private void deleteFormatButtonActionPerformed(ActionEvent evt) {
        int n = JOptionPane.showConfirmDialog(
                    this,
                    "Skutočne chcete vymazať daný formát?",
                    "Mazanie formátu",
                    JOptionPane.YES_NO_OPTION);
        if (n == 0) {
            if (e.aktualnyOkruh != null && e.aktualnyVstupnyFormat != null) {
                HistoriaDeletedFormat hdf = new HistoriaDeletedFormat(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, 
                    this.e.aktualnaTransformacia, this.e.aktualnyVstupnyFormat, e.aktualnyOkruh.formaty.indexOf(this.e.aktualnyVstupnyFormat));
                this.e.aktualnyOkruh.zmazFormat(e.aktualnyVstupnyFormat.getMeno());
                this.historia.pridajZaznam(hdf);
                this.changed = true;
                refreshTitle();
            }
            refreshVstupneFormaty(null);
        }
    }
    
     public void refreshVystupnyFormat(String vystupnyFormatMeno) {
        vystupnyFormatComboBox.removeAllItems();
        if (e.conf != null && e.aktualnyOkruh != null) {
            if (this.e.aktualnyOkruh.formaty.size() > 0) {
                String[] vystupneFormaty = new String[this.e.aktualnyOkruh.formaty.size()];
                int selectedIndex = 0;
                int counter = 0;
                for (Iterator i = this.e.aktualnyOkruh.formaty.iterator(); i.hasNext();) {
                    Format f = (Format) i.next();
                    if (vystupnyFormatMeno != null && vystupnyFormatMeno.compareTo(f.getMeno()) == 0) {
                        selectedIndex = counter;
                    }
                    vystupneFormaty[counter] = f.getMeno();
                    counter++;
                }
                vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vystupneFormaty));
                vystupnyFormatComboBox.setSelectedIndex(selectedIndex);
                this.e.aktualnyVystupnyFormat = (Format) this.e.aktualnyOkruh.formaty.get(selectedIndex);
            }
            else {
                vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
                this.e.aktualnyVystupnyFormat = null;
            }
            refreshTransformacie(null);
            return;
        }
        vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        refreshTransformacie(null);
    }    
    
    private void addTransformaciaButtonActionPerformed(ActionEvent evt) {
        if (this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null && this.e.aktualnyVystupnyFormat != null) {            
            JednoduchaTransformacia newJt = new JednoduchaTransformacia(e.aktualnyVstupnyFormat, e.aktualnyVystupnyFormat, e.aktualnyOkruh);
            int newId = newJt.id;
            boolean pridane = this.e.aktualnyVstupnyFormat.pridajJednoduchuTransformaciu(newJt);
            if (pridane) {
                HistoriaAddedTransformacia hat = new HistoriaAddedTransformacia(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, 
                    this.e.aktualnaTransformacia, newJt);
                this.historia.pridajZaznam(hat);
                JOptionPane.showMessageDialog(this,
                    "Nová transformácia úspešne pridaná.", 
                    "Pridaná transformácia.", JOptionPane.INFORMATION_MESSAGE);
                refreshTransformacie(((new Integer(newId)).toString()));
                this.changed = true;
                refreshTitle();
            }
            else {
                JOptionPane.showMessageDialog(this,
                    "Nepodarilo sa pridať transformáciu.",
                    "Nepridaná transformácia!",
                    JOptionPane.ERROR_MESSAGE);
            }
        }        
    }
    
    private void deleteTransformaciaButtonActionPerformed(ActionEvent evt) {
        if (this.e.aktualnyOkruh != null && this.e.aktualnyVstupnyFormat != null && this.e.aktualnyVystupnyFormat != null) {
            int n = JOptionPane.showConfirmDialog(
                        this,
                        "Skutočne chcete vymazať danú transformáciu?",
                        "Mazanie transformácie",
                        JOptionPane.YES_NO_OPTION);
            if (n == 0 && e.aktualnyOkruh != null && e.aktualnyVstupnyFormat != null) {        
                HistoriaDeletedTransformacia hdt = new HistoriaDeletedTransformacia(this, this.e.aktualnyOkruh, this.e.aktualnyVstupnyFormat, this.e.aktualnyVystupnyFormat, 
                    this.e.aktualnaTransformacia, this.e.aktualnaTransformacia, e.aktualnyVstupnyFormat.jednoducheTransformacie.indexOf(this.e.aktualnaTransformacia));
                boolean odstranene = this.e.aktualnyVstupnyFormat.zmazJTpodlaId(Integer.parseInt((String) this.transformaciaComboBox.getSelectedItem()));
                if (odstranene) {
                    this.changed = true;
                    this.historia.pridajZaznam(hdt);
                    refreshTitle();
                    refreshTransformacie(null);
                }
            }
        }
    }
    
    private void predpisAreaActionPerformed(KeyEvent evt) {
        try {
            if (!navigationKeyPressed(evt.getKeyCode())) {                
                String sucasnyObsahPredpisu = this.e.aktualnaTransformacia.predpis.printFormattedXML("");
                String novyObsahPredpisu = predpisArea.getText();
                if (sucasnyObsahPredpisu.compareTo(novyObsahPredpisu) != 0) {
                    e.aktualnaTransformacia.predpis.setPredpis(novyObsahPredpisu, "");
                    this.changed = true;
                    refreshTitle();
                    refreshNodesPanel();
                    if (errorLabel != null) {
                        if (errorLabel.isVisible()) {
                            errorLabel.setVisible(false);
                            pack();
                            myCorrection();
                        }
                    }

                    this.e.aktualnaTransformacia.predpis.lastValue = sucasnyObsahPredpisu;
                    HistoriaChangedPredpis hcp = new HistoriaChangedPredpis(this, e.aktualnyOkruh, e.aktualnyVstupnyFormat,
                        e.aktualnyVystupnyFormat, e.aktualnaTransformacia, sucasnyObsahPredpisu, novyObsahPredpisu);
                    this.historia.pridajZaznam(hcp);
                }
            }                
        } catch (ParserConfigurationException ex) {
            showError(ex.getMessage());
        } catch (SAXException ex) {
            showError(ex.getMessage());
        } catch (IOException ex) {
            showError(ex.getMessage());
        }
    }
            
            
    private void formWindowClosing(java.awt.event.WindowEvent evt) {
        if (this.parentFrame != null) {
            this.parentFrame.setEnabled(true);
            this.parentFrame.reinit();
        }
    }
    
    public void refreshTransformacie(String setTransformation) {
        if (this.e.aktualnyOkruh!= null && this.e.aktualnyVstupnyFormat != null && this.e.aktualnyVystupnyFormat!= null) {
            ArrayList transformacie = this.e.aktualnyVstupnyFormat.getJednoducheTransformacieNaFormat(this.e.aktualnyVystupnyFormat.getMeno());
            if (transformacie.size() > 0) {
                int counter = 0;
                String[] transformacieId = new String[transformacie.size()];
                boolean nastavene = false;
                int newIndex = -1;
                for (Iterator i = transformacie.iterator(); i.hasNext(); ) {
                    JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                    if (!nastavene) {
                        this.e.aktualnaTransformacia = jt;
                        nastavene = true;
                        addTransformaciaButton.setEnabled(true);
                        deleteTransformaciaButton.setEnabled(true);
                    }
                    transformacieId[counter] = ((Integer) jt.id).toString();
                    if (setTransformation != null && setTransformation.compareTo(((Integer) jt.id).toString()) == 0) {
                        newIndex = counter;
                    }
                    counter++;
                }
                transformaciaComboBox.setModel(new javax.swing.DefaultComboBoxModel(transformacieId));
                if (setTransformation != null) {
                    this.transformaciaComboBox.setSelectedIndex(newIndex);
                }
                Integer transfID = Integer.parseInt((String) this.transformaciaComboBox.getSelectedItem());
                this.e.aktualnaTransformacia = this.e.aktualnyVstupnyFormat.getJTPodlaId(transfID);
                transformaciaComboBox.setEnabled(true);
                transformaciaComboBox.repaint();
                
                predpisArea.setRows(15);
                predpisArea.setColumns(50);
                refreshPredpisArea(false);
                this.predpisArea.setEnabled(true);
                refreshNodesPanel();
                return;
            }
            this.e.aktualnaTransformacia = null;
            transformaciaComboBox.setModel(new javax.swing.DefaultComboBoxModel());
            transformaciaComboBox.setEnabled(false);
            addTransformaciaButton.setEnabled(true);
            deleteTransformaciaButton.setEnabled(false);
            transformaciaComboBox.repaint();            
            
            this.predpisArea.setEnabled(false);
            this.predpisArea.setText("");
            
            refreshNodesPanel();
            return;
        }
        this.e.aktualnaTransformacia = null;
        transformaciaComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        addTransformaciaButton.setEnabled(false);
        deleteTransformaciaButton.setEnabled(false);
        transformaciaComboBox.repaint();
        
       
        this.predpisArea.setEnabled(false);
        this.predpisArea.setText("");
        mainPanel.validate();
        
        refreshNodesPanel();
    }
    
    public void refreshPredpisArea() {
        refreshPredpisArea(true);
    }
    
    public void refreshPredpisArea(boolean changedKonfiguracia) {
        if (this.predpisArea != null && e.aktualnaTransformacia != null) {
            String sucasnyObsahPredpisu = this.predpisArea.getText();
            String novyObsahPredpisu = new String(this.e.aktualnaTransformacia.predpis.printFormattedXML(""));
            this.predpisArea.setText(novyObsahPredpisu);
            this.predpisArea.getCaret().setDot(0);
            if (changedKonfiguracia) {
                this.changed = true;

                this.e.aktualnaTransformacia.predpis.lastValue = sucasnyObsahPredpisu;
                HistoriaChangedPredpis hcp = new HistoriaChangedPredpis(this, e.aktualnyOkruh, e.aktualnyVstupnyFormat,
                    e.aktualnyVystupnyFormat, e.aktualnaTransformacia, sucasnyObsahPredpisu, novyObsahPredpisu);
                this.historia.pridajZaznam(hcp);

                this.refreshTitle();
                if (errorLabel != null) {
                    if (errorLabel.isVisible()) {
                        errorLabel.setVisible(false);
                        pack();
                        myCorrection();
                    }
                }
            }
            else {
                if (errorLabel != null) {
                    if (errorLabel.isVisible()) {
                        errorLabel.setVisible(false);
                        pack();
                        myCorrection();
                    }
                }
            }
        }
    }
    
    public void refreshPrikazPanel() {
        if (this.e.aktualnaTransformacia != null) {
            this.e.aktualnaTransformacia.setVstup(new VstupnySubor("<vstup>"));
            this.e.aktualnaTransformacia.setVystup(new VystupnySubor("<výstup>"));
            prikazArea.setText(this.e.aktualnaTransformacia.predpis.getValue());
            prikazPanel.setVisible(true);
        }
        else {
            prikazPanel.setVisible(false);
        }
        repaint();
        pack();
    }
    
    public void refreshNodesPanel() {
        if (this.e.aktualnaTransformacia != null) {
            this.nodePanelScrollPane.setVisible(false);
            this.e.aktualnaTransformacia.setVstup(new VstupnySubor("<vstup>"));
            this.e.aktualnaTransformacia.setVystup(new VystupnySubor("<výstup>"));
            prikazArea.setText(this.e.aktualnaTransformacia.predpis.getValue());
            prikazPanel.setVisible(true);
            nodesPanel.removeAll();
            GridBagConstraints nodePanelGbc = new GridBagConstraints();
            nodePanelGbc.fill = GridBagConstraints.HORIZONTAL;
            nodePanelGbc.gridx = 0;
            nodePanelGbc.gridy = 0;
            nodePanelGbc.insets = new Insets(15, 5, 5, 0);
            JLabel nadpis = new javax.swing.JLabel();
            nadpis.setFont(new java.awt.Font("DejaVu Sans", 1, 12));
            nadpis.setText("Uzly predpisu:");
            nodesPanel.add(nadpis, nodePanelGbc);
            nodePanelGbc.insets = new Insets(0, 0, 0, 0);
            
            SettingsPanel addedPanel = new SettingsPanel();
            addedPanel.parent = this.nodesPanel;
            this.e.aktualnaTransformacia.predpis.paintEditorialPanel(addedPanel, this, new String(""));
            
            nodePanelGbc.gridy = 1;
            
            nodePanelGbc.gridwidth = 500;
            nodePanelGbc.fill = GridBagConstraints.NONE;
            
            nodesPanel.add(addedPanel, nodePanelGbc);
            
            if ((nodesPanel.getPreferredSize().height) < (predpisAreaScrollPane.getPreferredSize().height*1)) {
                nodePanelScrollPane.setPreferredSize(new Dimension(nodePanelScrollPane.getPreferredSize().width, nodesPanel.getPreferredSize().height+50));
            }
            else {
                nodePanelScrollPane.setPreferredSize(new Dimension(mainPanel.getPreferredSize().width, predpisAreaScrollPane.getPreferredSize().height*1));
            }
            
            this.nodePanelScrollPane.setVisible(true);
        }
        else {
            nodesPanel.removeAll();
            this.nodePanelScrollPane.setVisible(false);
            prikazPanel.setVisible(false);
        }        
        pack();
        myCorrection();
    }
    
    public void refreshAll() {
        String nazovVstupnehoFormatu;
        if (e.aktualnyVstupnyFormat != null) {
            nazovVstupnehoFormatu = new String(e.aktualnyVstupnyFormat.getMeno());
        }
        else {
            nazovVstupnehoFormatu = null;
        }
        
        String nazovVystupnehoFormatu;
        if (e.aktualnyVystupnyFormat != null) {
            nazovVystupnehoFormatu = new String(e.aktualnyVystupnyFormat.getMeno());
        }
        else {
            nazovVystupnehoFormatu = null;
        }
        
        Integer idTransformacie = null;
        if (e.aktualnaTransformacia != null) {
            idTransformacie = e.aktualnaTransformacia.id;
        }
        
        okruhyComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        transformaciaComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        
        addOkruhButton.setEnabled(true);
        deleteOkruhButton.setEnabled(false);
        
        addFormatButton.setEnabled(false);
        deleteFormatButton.setEnabled(false);
        
        if (!this.e.conf.okruhy.isEmpty()) {
            String okruhy[] = new String[e.conf.okruhy.size()];
            int selectedOkruh = 0;
            int counter = 0;
            for (Iterator i = e.conf.okruhy.iterator(); i.hasNext(); counter++) {
                Okruh o = (Okruh) i.next();
                okruhy[counter] = o.getMeno();
                if (e.aktualnyOkruh != null && o.getMeno().compareTo(e.aktualnyOkruh.getMeno()) == 0) {
                    selectedOkruh = counter;
                }
            }
            okruhyComboBox.setModel(new javax.swing.DefaultComboBoxModel(okruhy));
            okruhyComboBox.setSelectedIndex(selectedOkruh);
            addOkruhButton.setEnabled(true);
            deleteOkruhButton.setEnabled(true);
            
            if (!e.aktualnyOkruh.formaty.isEmpty()) {
                String formaty[] = new String[e.aktualnyOkruh.formaty.size()];
                int selectedFormat = 0;
                counter = 0;
                for (Iterator i = e.aktualnyOkruh.formaty.iterator(); i.hasNext(); counter++) {
                    Format f = (Format) i.next();
                    formaty[counter] = f.getMeno();
                    if (nazovVstupnehoFormatu != null && f.getMeno().compareTo(nazovVstupnehoFormatu) == 0) {
                        selectedFormat = counter;
                    }
                }
                vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(formaty));
                vstupnyFormatComboBox.setSelectedIndex(selectedFormat);
                addFormatButton.setEnabled(true);
                deleteFormatButton.setEnabled(true);
                
                if (nazovVystupnehoFormatu != null) {
                    refreshVystupnyFormat(nazovVystupnehoFormatu);
                }
                else {
                    refreshVystupnyFormat(null);
                }
            }
            
        }
        
        if (idTransformacie != null) {
            refreshTransformacie(new Integer(idTransformacie).toString());
        }
        else {
            refreshTransformacie(null);
        }
        
    }
    
    public void showError(String error) {
        if (error.compareTo("") == 0) {
            this.errorLabel.setText(error);
            if (this.errorLabel.isVisible()) {
                this.errorLabel.setVisible(false);
                mainPanel.repaint();
                pack();
                myCorrection();
            }
            return;
        }
        else {
            this.errorLabel.setText(error);
            this.errorLabel.setVisible(true);
            mainPanel.repaint();
            pack();
            myCorrection();
        }
    }
   
    
    public void myCorrection() {
        this.setSize(this.getWidth()+1, this.getHeight()+1);
        this.setSize(this.getWidth()-1, this.getHeight()-1);
    }
    
    
    public boolean navigationKeyPressed(int key) {
        ArrayList navigationKeys = new ArrayList();
        navigationKeys.add(KeyEvent.VK_UP);
        navigationKeys.add(KeyEvent.VK_DOWN);
        navigationKeys.add(KeyEvent.VK_RIGHT);
        navigationKeys.add(KeyEvent.VK_LEFT);
        return (navigationKeys.contains(key));
    }

    public void saveConfiguration(ActionEvent evt) {
        if (e.conf != null) {
            if (e.nacitanyKonfiguracnySubor != null) {
                FileOutputStream erasor = null;
                String cesta = e.nacitanyKonfiguracnySubor.getAbsolutePath();
                try {
                    erasor = new FileOutputStream(cesta);
                    erasor.write((new String()).getBytes());

                    FileOutputStream writer = new FileOutputStream(cesta);
                    writer.write(e.conf.printFormattedXML().getBytes());
                    writer.flush();
                    writer.close();
                    this.changed = false;
                    refreshTitle();
                } catch (IOException ex) {
                    JOptionPane.showMessageDialog(null,
                        "Chyba načítavania súboru!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                }
                finally {
                    try {
                        erasor.close();
                    } catch (IOException ex) {
                        JOptionPane.showMessageDialog(null,
                            "Chyba načítavania súboru!",
                            "",
                            JOptionPane.ERROR_MESSAGE);
                    }
                }
            }
            else {
                saveAsConfiguration(evt);
            }
        }
    }

    public void saveAsConfiguration(ActionEvent evt) {
        PathManager pm = new PathManager();
        JFileChooser fc = new JFileChooser(pm.getProjectPath());
        fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
        fc.setSelectedFile(new File("newConfiguration.xml"));
        int returnVal = fc.showSaveDialog(SaveAsMenuItem);
        if (returnVal == JFileChooser.APPROVE_OPTION) {
            File file = fc.getSelectedFile();
            String cesta = file.getAbsolutePath();
            if (file.exists()) {
                FileOutputStream erasor;
                try {
                    erasor = new FileOutputStream(cesta);
                    try {
                        erasor.write((new String()).getBytes());
                    } catch (IOException ex) {
                        JOptionPane.showMessageDialog(null,
                            "Chyba načítavania súboru!",
                            "",
                            JOptionPane.ERROR_MESSAGE);
                    }
                } catch (FileNotFoundException ex) {
                    JOptionPane.showMessageDialog(null,
                        "Chyba načítavania súboru!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                }
            }

            FileOutputStream writer;
            try {
                writer = new FileOutputStream(cesta);
                writer.write(e.conf.printFormattedXML().getBytes());
                writer.flush();
                writer.close();
                e.nacitanyKonfiguracnySubor = new File(cesta);
                this.changed = false;
                refreshTitle();
                JOptionPane.showMessageDialog(null,
                        "Súbor úspešne uložený!",
                        "",
                        JOptionPane.INFORMATION_MESSAGE);
            } catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null,
                        "Chyba zápisu do súboru!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
            }
            catch (IOException ex) {
                    JOptionPane.showMessageDialog(null,
                        "Chyba zápisu do súboru!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
            }
        }
    }
}
