package bakalarka;

import java.util.ArrayList;

public class AdministraciaHistoria {
    
    private AdministraciaFrame af;
    private ArrayList zaznamy = new ArrayList();
    private int aktualneCisloZaznamu = 0;
    
    public AdministraciaHistoria(AdministraciaFrame af) {
        this.af = af;
    }
    
    public void vyprazdniHistoriu() {
        this.zaznamy.clear();
        this.aktualneCisloZaznamu = 0;
        af.UndoMenuItem.setEnabled(false);
        af.RedoMenuItem.setEnabled(false);
    }
    
    public void vyprazdniRedoMoznosti() {
        for (int i = aktualneCisloZaznamu; i < zaznamy.size(); i++) {
            zaznamy.remove(i);
        }
        af.RedoMenuItem.setEnabled(false);
    }
    
    public void pridajZaznam(HistoriaZaznam zaznam) {
        this.vyprazdniRedoMoznosti();
        zaznamy.add(zaznam);
        aktualneCisloZaznamu++;
        refreshEditMenu();
    }
    
    public void refreshEditMenu() {
        if (aktualneCisloZaznamu > 0) {
            af.UndoMenuItem.setEnabled(true);
        }
        else {
            af.UndoMenuItem.setEnabled(false);
        }
        
        if (aktualneCisloZaznamu < zaznamy.size()) {
            af.RedoMenuItem.setEnabled(true);
        }
        else {
            af.RedoMenuItem.setEnabled(false);
        }
    }
    
    public void undo() {
        if (aktualneCisloZaznamu > 0) {
            aktualneCisloZaznamu--;
            ((HistoriaZaznam) zaznamy.get(aktualneCisloZaznamu) ).undoAction();
        }
        refreshEditMenu();
    }
    
    public void redo() {
        if (aktualneCisloZaznamu < zaznamy.size()) {
            aktualneCisloZaznamu++;
            ((HistoriaZaznam) zaznamy.get(aktualneCisloZaznamu-1) ).redoAction();
        }
        refreshEditMenu();
    }

    public void vypis() {
        System.out.println("Pocet zaznamov:"+zaznamy.size()+", aktualny zaznam:"+(aktualneCisloZaznamu));
    }
    
}
