package bakalarka;

import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import java.awt.Toolkit;


import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;



public class BakalarkaMainFrame extends javax.swing.JFrame {
    
    public BakalarkaMainFrame() {
        this.setLocation(500, 300);
        p = new Program();
        try {
            ProgramSettingsHandler psh = new ProgramSettingsHandler();
            p.setKonfiguracnySubor(psh.getTransformationsFilePath());
            p.nacitajKonfiguraciu();
            p.conf.vypocitajUzaver();
        } catch (Exception e) {
            JOptionPane.showMessageDialog(null,
                "Chyba načítavania súboru!",
                "",
                JOptionPane.ERROR_MESSAGE);
        }
        this.initComponents();
    }

    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        MainPanel = new javax.swing.JPanel();
        transfInfoPanel = new javax.swing.JPanel();
        this.transfInfoPanel.setVisible(false);
        TransfCestaLabel = new javax.swing.JLabel();
        TransfCestaDetaily = new javax.swing.JLabel();
        pocetTransformaciiLabel = new javax.swing.JLabel();
        pocetTransformaciiDetaily = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        convertButton = new javax.swing.JButton();
        vstupnyFormatLabel = new javax.swing.JLabel();
        vystupnyFormatLabel = new javax.swing.JLabel();
        settingsButton = new javax.swing.JButton();
        Transformácia = new javax.swing.JLabel();
        sourceLabel = new javax.swing.JLabel();
        destinationLabel = new javax.swing.JLabel();
        okruhLabel = new javax.swing.JLabel();
        sourcePath = new javax.swing.JTextField();
        findSourceButton = new javax.swing.JButton();
        okruhComboBox = new javax.swing.JComboBox();
        vstupnyFormatComboBox = new javax.swing.JComboBox();
        destinationPath = new javax.swing.JTextField();
        vystupnyFormatComboBox = new javax.swing.JComboBox();
        TransformaciaComboBox = new javax.swing.JComboBox();
        findDestinationButton = new javax.swing.JButton();
        MainFrameMenuBar = new javax.swing.JMenuBar();
        AdminstraciaMenu = new javax.swing.JMenu();
        AdministraciaMenuItem = new javax.swing.JMenuItem();
        HesloMenuItem = new javax.swing.JMenuItem();
        QuitMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setResizable(false);
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        MainPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());
        getContentPane().add(MainPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, -1, -1));

        transfInfoPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        TransfCestaLabel.setText("Transformačná cesta:");
        transfInfoPanel.add(TransfCestaLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 100, -1, -1));
        transfInfoPanel.add(TransfCestaDetaily, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 120, 370, 70));

        pocetTransformaciiLabel.setText("Počet transformácii:");
        transfInfoPanel.add(pocetTransformaciiLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 20, -1, -1));
        transfInfoPanel.add(pocetTransformaciiDetaily, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 40, 370, 50));

        jSeparator1.setOrientation(javax.swing.SwingConstants.VERTICAL);
        transfInfoPanel.add(jSeparator1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 4, 10, 180));

        getContentPane().add(transfInfoPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(200, 80, 410, 210));

        convertButton.setText("Konverzia");
        convertButton.setActionCommand("jButton1");
        convertButton.setEnabled(false);
        convertButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                convertButtonActionPerformed(evt);
            }
        });
        getContentPane().add(convertButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(120, 260, -1, -1));

        vstupnyFormatLabel.setText("Vstupný formát:");
        getContentPane().add(vstupnyFormatLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 130, -1, -1));

        vystupnyFormatLabel.setText("Výstupný formát:");
        getContentPane().add(vystupnyFormatLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 170, -1, -1));

        settingsButton.setText("Nastavenia");
        settingsButton.setEnabled(false);
        settingsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                settingsButtonActionPerformed(evt);
            }
        });
        getContentPane().add(settingsButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 260, -1, -1));

        Transformácia.setText("Transformácia");
        Transformácia.setEnabled(false);
        getContentPane().add(Transformácia, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 210, -1, -1));

        sourceLabel.setText("Zdroj:");
        getContentPane().add(sourceLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 10, -1, -1));

        destinationLabel.setText("Cieľ:");
        getContentPane().add(destinationLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 40, -1, -1));

        okruhLabel.setText("Okruh:");
        getContentPane().add(okruhLabel, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 90, -1, -1));

        sourcePath.setEditable(false);
        getContentPane().add(sourcePath, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 10, 480, -1));

        findSourceButton.setText("...");
        findSourceButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findSourceButtonActionPerformed(evt);
            }
        });
        getContentPane().add(findSourceButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(560, 10, -1, -1));

        if (p.conf != null && p.conf.okruhy != null && (p.conf.okruhy.size() > 0)) {
            String[] okruhyMena = new String[p.conf.okruhy.size()];
            int counter = 0;
            for (Iterator i = this.p.conf.okruhy.iterator(); i.hasNext();) {
                Okruh spracovavany = ((Okruh) i.next());
                if (counter == 0) {
                    this.p.o = spracovavany;
                }
                okruhyMena[counter] = spracovavany.meno;
                counter++;
            }
            okruhComboBox.setModel(new javax.swing.DefaultComboBoxModel(okruhyMena));
            okruhComboBox.setSelectedIndex(0);
        }
        else {
            okruhComboBox.setModel(new javax.swing.DefaultComboBoxModel());
        }
        okruhComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okruhComboBoxActionPerformed(evt);
            }
        });
        getContentPane().add(okruhComboBox, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 90, -1, -1));

        String okruhMeno = (String) this.okruhComboBox.getSelectedItem();
        this.p.o = p.conf.getOkruh(okruhMeno);
        int size = 1;
        if (this.p.o != null) {
            size = this.p.o.formaty.size()+1;
        }

        String[] vstupneFormaty = new String[size];
        vstupneFormaty[0] = "";
        if (this.p.o != null) {
            int counter = 1;
            for (Iterator i = this.p.o.formaty.iterator(); i.hasNext();) {
                vstupneFormaty[counter] = ((Format) i.next()).getMeno();
                counter++;
            }
        }
        vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
        vstupnyFormatComboBox.setSelectedIndex(0);
        vstupnyFormatComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vstupnyFormatComboBoxActionPerformed(evt);
            }
        });
        getContentPane().add(vstupnyFormatComboBox, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 130, -1, -1));

        destinationPath.setEditable(false);
        getContentPane().add(destinationPath, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 40, 480, -1));

        vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
        vstupnyFormatComboBox.setSelectedIndex(0);
        vystupnyFormatComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                vystupnyFormatComboBoxActionPerformed(evt);
            }
        });
        getContentPane().add(vystupnyFormatComboBox, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 170, -1, -1));

        TransformaciaComboBox.setEnabled(false);
        TransformaciaComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                TransformaciaComboBoxActionPerformed(evt);
            }
        });
        getContentPane().add(TransformaciaComboBox, new org.netbeans.lib.awtextra.AbsoluteConstraints(130, 210, -1, -1));

        findDestinationButton.setText("...");
        findDestinationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                findDestinationButtonActionPerformed(evt);
            }
        });
        getContentPane().add(findDestinationButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(560, 40, -1, -1));

        AdminstraciaMenu.setText("Administrácia");

        AdministraciaMenuItem.setText("Vstup do administrácie");
        AdministraciaMenuItem.setAccelerator(KeyStroke.getKeyStroke('A',
            Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
    AdministraciaMenuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            AdministraciaMenuItemActionPerformed(evt);
        }
    });
    AdminstraciaMenu.add(AdministraciaMenuItem);

    HesloMenuItem.setText("Nastavenie/Zmena hesla");
    HesloMenuItem.setAccelerator(KeyStroke.getKeyStroke('H',
        Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
HesloMenuItem.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(java.awt.event.ActionEvent evt) {
        HesloMenuItemActionPerformed(evt);
    }
    });
    AdminstraciaMenu.add(HesloMenuItem);

    QuitMenuItem.setText("Koniec");
    QuitMenuItem.setAccelerator(KeyStroke.getKeyStroke('Q',
        Toolkit.getDefaultToolkit(  ).getMenuShortcutKeyMask(  ), true));
QuitMenuItem.addActionListener(new java.awt.event.ActionListener() {
    public void actionPerformed(java.awt.event.ActionEvent evt) {
        QuitMenuItemActionPerformed(evt);
    }
    });
    AdminstraciaMenu.add(QuitMenuItem);

    MainFrameMenuBar.add(AdminstraciaMenu);

    setJMenuBar(MainFrameMenuBar);

    pack();
    }// </editor-fold>//GEN-END:initComponents

private void findSourceButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findSourceButtonActionPerformed
// TODO add your handling code here:
    fc.setFileSelectionMode(JFileChooser.FILES_ONLY);
    int returnVal = fc.showOpenDialog(findSourceButton);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
        File file = fc.getSelectedFile();
        this.sourcePath.setText(file.getAbsolutePath());
        p.vstup = new VstupnySubor(file.getAbsolutePath());
        String pripona = file.getAbsolutePath();
        pripona = pripona.substring(pripona.lastIndexOf(".")+1,pripona.length());        
        String nastavenyVstupnyFormat = (String) this.vstupnyFormatComboBox.getSelectedItem();
        this.setVstupnyFormatComboBox(pripona);
        if (this.p.o != null) {
            this.p.vstupnyFormat = this.p.o.getFormat(pripona);
            if (this.p.vstupnyFormat == null) {
                vstupnyFormatComboBox.setSelectedItem(nastavenyVstupnyFormat);
                this.p.vstupnyFormat = this.p.o.getFormat(pripona);
            }
            else {
                setVystupneFormaty();
            }            
        }
        String nazovSuboru = file.getAbsolutePath();
        if (nazovSuboru.lastIndexOf("/") != -1) {
            nazovSuboru = nazovSuboru.substring(nazovSuboru.lastIndexOf("/")+1, nazovSuboru.length());
        }
        if (nazovSuboru.lastIndexOf(".") != -1) {
            nazovSuboru = nazovSuboru.substring(0, nazovSuboru.lastIndexOf("."));
        }
        this.p.menoVstupnehoSuboru = nazovSuboru;
    }
    checkInputConditions();
    
}//GEN-LAST:event_findSourceButtonActionPerformed

private void setVstupnyFormatComboBox(String pripona) {
    String pred = (String) this.vstupnyFormatComboBox.getSelectedItem();
    this.vstupnyFormatComboBox.setSelectedItem(pripona);
    if (((String) this.vstupnyFormatComboBox.getSelectedItem()).compareTo(pred) == 0 && pred.compareTo(pripona) != 0) {
        this.vstupnyFormatComboBox.setSelectedItem("");
    }
    checkInputConditions();
}


private void findDestinationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_findDestinationButtonActionPerformed
// TODO add your handling code here:
    fc.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    int returnVal = fc.showOpenDialog(findDestinationButton);
    if (returnVal == JFileChooser.APPROVE_OPTION) {
        File file = fc.getSelectedFile();
        this.destinationPath.setText(file.getAbsolutePath());
        p.vystup = new VystupnySubor(file.getAbsolutePath());
    }
    checkInputConditions();
}//GEN-LAST:event_findDestinationButtonActionPerformed

private void convertButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_convertButtonActionPerformed
    KonverziaFrame kf = new KonverziaFrame();
    kf.setLocationRelativeTo(convertButton);
    kf.setVisible(true);
    kf.setParentFrame(this);
}//GEN-LAST:event_convertButtonActionPerformed

private void okruhComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okruhComboBoxActionPerformed
// TODO add your handling code here:
    String okruhMeno = (String) this.okruhComboBox.getSelectedItem();
    this.p.o = p.conf.getOkruh(okruhMeno);
    String[] vstupneFormaty = new String[this.p.o.formaty.size() + 1];
    vstupneFormaty[0] = "";
    int counter = 1;
    for (Iterator i = this.p.o.formaty.iterator(); i.hasNext();) {
        vstupneFormaty[counter] = ((Format) i.next()).getMeno();
        counter++;
    }
    vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
    vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
    if (this.p.menoVstupnehoSuboru != null) {
        String pripona = this.sourcePath.getText();
        pripona = pripona.substring(pripona.lastIndexOf(".")+1,pripona.length());
        this.setVstupnyFormatComboBox(pripona);
        this.p.vstupnyFormat = this.p.o.getFormat(pripona);
        setVystupneFormaty();
    }
    else {
        this.p.vstupnyFormat = null;
        setVystupneFormaty();
    }
    this.p.vystupnyFormat = null;
    checkInputConditions();
}//GEN-LAST:event_okruhComboBoxActionPerformed

private void vstupnyFormatComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vstupnyFormatComboBoxActionPerformed
// TODO add your handling code here:
    String vstupnyFormatMeno = (String) this.vstupnyFormatComboBox.getSelectedItem();
    if (vstupnyFormatMeno.compareTo("") != 0) {
        this.p.vstupnyFormat = this.p.o.getFormat(vstupnyFormatMeno);
        setVystupneFormaty();
    }
    else {
        this.p.vstupnyFormat = null;
        setVystupneFormaty();
    }
    checkInputConditions();
}//GEN-LAST:event_vstupnyFormatComboBoxActionPerformed

private void vystupnyFormatComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_vystupnyFormatComboBoxActionPerformed
// TODO add your handling code here:
    String vystupnyFormatMeno = (String) this.vystupnyFormatComboBox.getSelectedItem();
    if (vystupnyFormatMeno.compareTo("") != 0) {
        this.p.vystupnyFormat = this.p.o.getFormat(vystupnyFormatMeno);        
    }
    else {
        this.p.vystupnyFormat = null;
    }
    checkInputConditions();
}//GEN-LAST:event_vystupnyFormatComboBoxActionPerformed

private void setVystupneFormaty() {
    String povodnyVystupnyFormatMeno = (String) this.vystupnyFormatComboBox.getSelectedItem();
    if (this.p.o == null) {
        String[] vystupneFormaty = new String[1];
        vystupneFormaty[0] = "";
        vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vystupneFormaty));
        this.p.vystupnyFormat = null;
        return;
    }
    if (this.p.vstupnyFormat != null) {
        String[] formaty = this.p.vstupnyFormat.getTransformovatelneFormaty();
        String[] vystupneFormaty = new String[formaty.length+1];
        vystupneFormaty[0] = "";
        for (int i = 0; i < formaty.length; i++) {
            vystupneFormaty[i+1] = formaty[i];
        }
        vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vystupneFormaty));
        vystupnyFormatComboBox.setSelectedItem(povodnyVystupnyFormatMeno);
    }
    else {
       String[] vystupneFormaty = new String[this.p.o.formaty.size()+1]; 
       vystupneFormaty[0] = "";
       int counter = 1;
       for (Iterator i = this.p.o.formaty.iterator(); i.hasNext();){
           vystupneFormaty[counter] = ((Format) i.next()).getMeno();
           counter++;
       }
       vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vystupneFormaty));
       vystupnyFormatComboBox.setSelectedItem(povodnyVystupnyFormatMeno);
    }
    this.p.vystupnyFormat = this.p.o.getFormat((String) vystupnyFormatComboBox.getSelectedItem());
}

private void TransformaciaComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_TransformaciaComboBoxActionPerformed
// TODO add your handling code here:
    Integer transfID = Integer.parseInt((String) this.TransformaciaComboBox.getSelectedItem());
    ArrayList transformacie = this.p.vstupnyFormat.getTransformacieNaFormat(this.p.vystupnyFormat.getMeno());
    for (Iterator i = transformacie.iterator();i.hasNext();) {
        TransformacnaRetaz tr = ((TransformacnaRetaz) i.next());
        if (tr.id == transfID) {
            this.p.pouzitaTransRetaz = tr;
            this.p.pouzitaTransRetaz.setVstup(this.p.vstup);
            this.p.pouzitaTransRetaz.setVystup(new VystupnySubor(this.p.vystup.cesta + "/" + this.p.menoVstupnehoSuboru + "." +  this.p.vystupnyFormat.getMeno()));
            this.refreshTransfDetailyPanel();
        }
    }
    this.settingsButton.setEnabled(this.p.pouzitaTransRetaz.isConfigurable());
    this.transfInfoPanel.setVisible(true);
}//GEN-LAST:event_TransformaciaComboBoxActionPerformed

private void settingsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_settingsButtonActionPerformed
// TODO add your handling code here:
    SettingsFrame sf = new SettingsFrame();
    sf.setParentFrame(this);
    sf.setLocationRelativeTo(settingsButton);
    sf.setVisible(true);
}//GEN-LAST:event_settingsButtonActionPerformed

private void AdministraciaMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_AdministraciaMenuItemActionPerformed
    try {
            ProgramSettingsHandler ph = new ProgramSettingsHandler();
            if (!ph.isPasswordSet()) {
                //System.out.print("Vstup bez hesla!");
                AdministraciaFrame af = new AdministraciaFrame();
                af.setParentFrame(this);
                af.setLocationRelativeTo(this.AdminstraciaMenu);
                af.setVisible(true);
            }
            else {
                LoginFrame lf = new LoginFrame();
                lf.setParentFrame(this);
                lf.setLocationRelativeTo(this.AdminstraciaMenu);
                lf.setVisible(true);
            }
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null,
                "Nenájdený súbor settings.conf!",
                "",
                JOptionPane.ERROR_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(null,
                "Chyba pri čítaní súboru settings.conf!",
                "",
                JOptionPane.ERROR_MESSAGE);
        }   
}//GEN-LAST:event_AdministraciaMenuItemActionPerformed

private void HesloMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HesloMenuItemActionPerformed
        try {
            ProgramSettingsHandler ph = new ProgramSettingsHandler();
            if (ph.isPasswordSet()) {
                ChangePasswordFrame chpf = new ChangePasswordFrame();
                chpf.setParentFrame(this);
                chpf.setLocationRelativeTo(this.HesloMenuItem);
                chpf.setVisible(true);
            }
            else {
                InitPasswordFrame ipf = new InitPasswordFrame();
                ipf.setParentFrame(this);
                ipf.setLocationRelativeTo(this.HesloMenuItem);
                ipf.setVisible(true);
            }
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null,
                "Nenájdený súbor settings.conf!",
                "",
                JOptionPane.ERROR_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(null,
                "Chyba pri čítaní súboru settings.conf!",
                "",
                JOptionPane.ERROR_MESSAGE);
        }
    
}//GEN-LAST:event_HesloMenuItemActionPerformed

private void QuitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_QuitMenuItemActionPerformed
    // TODO add your handling code here:
    this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
}//GEN-LAST:event_QuitMenuItemActionPerformed

public void refreshTransfDetailyPanel() {
    this.transfInfoPanel.setVisible(true);
    this.pocetTransformaciiDetaily.setText(((Integer)this.p.pouzitaTransRetaz.dlzka).toString());
    this.TransfCestaDetaily.setText(this.p.pouzitaTransRetaz.vypisCesty());
}

private void checkInputConditions() {
    if (this.p.possibleTransformation()) {
        ArrayList transformacie = this.p.vstupnyFormat.getTransformacieNaFormat(this.p.vystupnyFormat.getMeno());
        if (transformacie != null && transformacie.size() >0) {
            convertButton.setEnabled(true);
            this.Transformácia.setEnabled(true);
            this.TransformaciaComboBox.setEnabled(true);
            this.settingsButton.setEnabled(true);
            
            String[] transformacieMena = new String[transformacie.size()];
            int counter = 0;
            for (Iterator i = transformacie.iterator(); i.hasNext();) {
                TransformacnaRetaz actualTR = ((TransformacnaRetaz) i.next());
                String actualID = ((Integer) actualTR.id).toString();
                if (counter == 0) {
                    this.settingsButton.setEnabled(actualTR.isConfigurable());
                }
                transformacieMena[counter] = actualID;
                counter++;
            }
            this.TransformaciaComboBox.setModel(new javax.swing.DefaultComboBoxModel(transformacieMena));
            this.p.pouzitaTransRetaz = ((TransformacnaRetaz) transformacie.get(0));
            this.p.pouzitaTransRetaz.setVstup(this.p.vstup);
            this.p.pouzitaTransRetaz.setVystup(new VystupnySubor(this.p.vystup.cesta + "/" + this.p.menoVstupnehoSuboru + "." +  this.p.vystupnyFormat.getMeno()));
            //System.out.println(this.p.vystup.cesta + "/" + this.p.menoVstupnehoSuboru + "." +  this.p.vystupnyFormat.getMeno());
            this.refreshTransfDetailyPanel();
            return;
        }
    }
    this.p.pouzitaTransRetaz = null;
    this.transfInfoPanel.setVisible(false);
    convertButton.setEnabled(false);
    this.settingsButton.setEnabled(false);
    this.Transformácia.setEnabled(false);
    this.TransformaciaComboBox.setEnabled(false);
}


    public void reinit() {
        try {
            ProgramSettingsHandler psh = new ProgramSettingsHandler();
            p.conf = new Konfiguracia();
            p.setKonfiguracnySubor(psh.getTransformationsFilePath());            
            p.nacitajKonfiguraciu();
            p.conf.vypocitajUzaver();
            p.menoVstupnehoSuboru = null;
            p.o = null;
            p.vstup = null;
            p.vystup = null;
            p.vstupnyFormat = null;
            p.vystupnyFormat = null;
            p.pouzitaTransRetaz = null;
            
            sourcePath.setText("");
            destinationPath.setText("");
            
            okruhComboBox.setModel(new javax.swing.DefaultComboBoxModel());
            String[] okruhyMena = new String[p.conf.okruhy.size()];
            int counter = 0;
            for (Iterator i = this.p.conf.okruhy.iterator(); i.hasNext();) {
                Okruh spracovavany = ((Okruh) i.next());
                if (counter == 0) {
                    this.p.o = spracovavany;
                }
                okruhyMena[counter] = spracovavany.meno;
                counter++;
            }
            okruhComboBox.setModel(new javax.swing.DefaultComboBoxModel(okruhyMena));
            okruhComboBox.setSelectedIndex(0);
             String okruhMeno = (String) this.okruhComboBox.getSelectedItem();
            this.p.o = p.conf.getOkruh(okruhMeno);
            int size = 1;
            if (this.p.o != null) {
                size = this.p.o.formaty.size()+1;
            }       
            String[] vstupneFormaty = new String[size];
            vstupneFormaty[0] = "";
            if (this.p.o != null) {
                counter = 1;
                for (Iterator i = this.p.o.formaty.iterator(); i.hasNext();) {
                    vstupneFormaty[counter] = ((Format) i.next()).getMeno();
                    counter++;
                }
            }
            vstupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
            vstupnyFormatComboBox.setSelectedIndex(0);
            
            vystupnyFormatComboBox.setModel(new javax.swing.DefaultComboBoxModel(vstupneFormaty));
            vstupnyFormatComboBox.setSelectedIndex(0);
            
            TransformaciaComboBox.setModel(new javax.swing.DefaultComboBoxModel());
            TransformaciaComboBox.setEnabled(false);
            
        } catch (Exception e) {
            JOptionPane.showMessageDialog(null,
                "Chyba načítavania súboru!",
                "",
                JOptionPane.ERROR_MESSAGE);
        }
    }
    
    

    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        } catch (ClassNotFoundException ex) {
        } catch (InstantiationException ex) {
        } catch (IllegalAccessException ex) {            
        } catch (UnsupportedLookAndFeelException ex) {
        }
        finally {
        }
        
        java.awt.EventQueue.invokeLater(new Runnable() {
                public void run() {
                    new BakalarkaMainFrame().setVisible(true);
                }
            });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem AdministraciaMenuItem;
    private javax.swing.JMenu AdminstraciaMenu;
    private javax.swing.JMenuItem HesloMenuItem;
    private javax.swing.JMenuBar MainFrameMenuBar;
    private javax.swing.JPanel MainPanel;
    private javax.swing.JMenuItem QuitMenuItem;
    private javax.swing.JLabel TransfCestaDetaily;
    private javax.swing.JLabel TransfCestaLabel;
    private javax.swing.JComboBox TransformaciaComboBox;
    private javax.swing.JLabel Transformácia;
    private javax.swing.JButton convertButton;
    private javax.swing.JLabel destinationLabel;
    private javax.swing.JTextField destinationPath;
    private javax.swing.JButton findDestinationButton;
    private javax.swing.JButton findSourceButton;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JComboBox okruhComboBox;
    private javax.swing.JLabel okruhLabel;
    private javax.swing.JLabel pocetTransformaciiDetaily;
    private javax.swing.JLabel pocetTransformaciiLabel;
    private javax.swing.JButton settingsButton;
    private javax.swing.JLabel sourceLabel;
    private javax.swing.JTextField sourcePath;
    private javax.swing.JPanel transfInfoPanel;
    private javax.swing.JComboBox vstupnyFormatComboBox;
    private javax.swing.JLabel vstupnyFormatLabel;
    private javax.swing.JComboBox vystupnyFormatComboBox;
    private javax.swing.JLabel vystupnyFormatLabel;
    // End of variables declaration//GEN-END:variables
    private JFileChooser fc = new JFileChooser();
    public static Program p;
}
