package bakalarka;

import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ChangePasswordFrame extends javax.swing.JFrame {

    /** Creates new form ChangePasswordFrame */
    public ChangePasswordFrame() {
        initComponents();
        this.setAlwaysOnTop(true);
    }
    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        oldPasswordField = new javax.swing.JPasswordField();
        newPasswordField1 = new javax.swing.JPasswordField();
        newPasswordField2 = new javax.swing.JPasswordField();
        saveButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel1.setFont(new java.awt.Font("DejaVu Sans", 1, 14)); // NOI18N
        jLabel1.setText("Zmena administračného hesla");
        getContentPane().add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(30, 20, -1, -1));

        jLabel2.setText("Pôvodné heslo:");
        getContentPane().add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 60, -1, -1));

        jLabel3.setText("Nové heslo:");
        getContentPane().add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 100, -1, -1));

        jLabel4.setText("Potvrdenie hesla:");
        getContentPane().add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 140, -1, -1));

        oldPasswordField.setColumns(10);
        getContentPane().add(oldPasswordField, new org.netbeans.lib.awtextra.AbsoluteConstraints(150, 60, -1, -1));

        newPasswordField1.setColumns(10);
        getContentPane().add(newPasswordField1, new org.netbeans.lib.awtextra.AbsoluteConstraints(150, 100, -1, -1));

        newPasswordField2.setColumns(10);
        getContentPane().add(newPasswordField2, new org.netbeans.lib.awtextra.AbsoluteConstraints(150, 140, -1, -1));

        saveButton.setText("Uložiť");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });
        getContentPane().add(saveButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(40, 180, 60, -1));

        cancelButton.setText("Zrušiť");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        getContentPane().add(cancelButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(150, 180, 60, -1));

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
    this.parentFrame.setEnabled(true);
}//GEN-LAST:event_formWindowClosing

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
    this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
}//GEN-LAST:event_cancelButtonActionPerformed

private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveButtonActionPerformed
    String heslo1 = new String(this.newPasswordField1.getPassword());
    String heslo2 = new String(this.newPasswordField2.getPassword());
    
    if (heslo1.compareTo(heslo2) != 0) {
        JOptionPane.showMessageDialog(null,
                        "Heslá sa musia rovnať!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
        this.newPasswordField1.setText("");
        this.newPasswordField2.setText("");
    }
    else {
            try {
                ProgramSettingsHandler ph = new ProgramSettingsHandler();                
                if (!ph.checkPassword(new String(this.oldPasswordField.getPassword()))) {
                    JOptionPane.showMessageDialog(null,
                        "Nesprávne heslo!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                    this.oldPasswordField.setText("");
                }
                else {
                    ph.writePassword(heslo1);
                    JOptionPane.showMessageDialog(null,
                        "Úspešne zmenené heslo.",
                        "",
                        JOptionPane.PLAIN_MESSAGE);
                    this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
                }                
            } catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null,
                    "Nenájdený súbor settings.conf!",
                    "",
                    JOptionPane.ERROR_MESSAGE);
            } catch (IOException ex) {
                JOptionPane.showMessageDialog(null,
                    "Chyba pri čítaní súboru settings.conf!",
                    "",
                    JOptionPane.ERROR_MESSAGE);
            }
        
    }
}//GEN-LAST:event_saveButtonActionPerformed

public void setParentFrame(JFrame frame) {
    this.parentFrame = frame;
    this.parentFrame.setEnabled(false);
}
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPasswordField newPasswordField1;
    private javax.swing.JPasswordField newPasswordField2;
    private javax.swing.JPasswordField oldPasswordField;
    private javax.swing.JButton saveButton;
    // End of variables declaration//GEN-END:variables

    public JFrame parentFrame = null;
}
