package bakalarka;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;


public class Editor {
        
    public Konfiguracia conf = new Konfiguracia();
    public File nacitanyKonfiguracnySubor = null;
    
    public Okruh aktualnyOkruh = null;
    public Format aktualnyVstupnyFormat = null;
    public Format aktualnyVystupnyFormat = null;
    public JednoduchaTransformacia aktualnaTransformacia = null;
    
    public void loadConfiguration(File f) throws ParserConfigurationException, IOException, SAXException {
        Konfiguracia pokus = new Konfiguracia(f);
        
        this.nacitanyKonfiguracnySubor = f;
        this.conf = pokus;
        aktualnyOkruh = null;
        aktualnyVstupnyFormat = null;
        aktualnyVystupnyFormat = null;
        aktualnaTransformacia = null;
    }
    
    public void loadConfiguration(String cesta) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        ProgramSettingsHandler psh = new ProgramSettingsHandler();
        if (psh.isRelativePath(cesta)) {
            PathManager pm = new PathManager();
            cesta = pm.getProjectPath().concat("/").concat(cesta);
        }
        File f = new File(cesta);
        this.nacitanyKonfiguracnySubor = f;
        this.conf = new Konfiguracia(f);
    }
    
    public boolean confLoaded() {
        if (conf != null) {
            return true;
        }
        return false;
    }
    
}
