package bakalarka;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class Format {

	public String meno = "";
	public ArrayList jednoducheTransformacie = new ArrayList();	//mnozina jednoskokovych transformacii z tohoto formatu na iny format
	public Hashtable transformacie;				//slovnik, ktoreho kluce su nazvy formatov na ktore sa da konvertovat
												//a hodnoty su zoznamy transformacnych retazi		
	public Okruh mojOkruh;						//okruh,kam patri format
	
	
	public Format(String meno, Okruh mojOkruh) {
		this.meno = meno;
		this.mojOkruh = mojOkruh;
		this.jednoducheTransformacie = new ArrayList();
		transformacie = new Hashtable();
	}
	
	public String getMeno() {
		return this.meno;
	}
	
	public boolean pridajJednoduchuTransformaciu(JednoduchaTransformacia jt) {
		if (jt.from.meno.compareTo(this.meno) != 0) {
			return false;
		}
		if (this.mojOkruh.getFormat(jt.to.getMeno()) == null) {
			return false;
		}
		boolean pridane = this.jednoducheTransformacie.add(jt);
		if (pridane) {
			TransformacnaRetaz tr = new TransformacnaRetaz(jt);
			pridane = this.pridajTransformacnuRetaz(tr);
			return pridane;
		}
		return false;
	}
	
	
	public void pridajFormatNaTransformaciu(Format f) {
		Object o = this.transformacie.get(f.getMeno());
		if (o != null) {
			return;
		}
		this.transformacie.put(f.getMeno(), new ArrayList());
	}
	
	public boolean pridajTransformacnuRetaz(TransformacnaRetaz tr) {
		if (tr.from.getMeno().compareTo(this.meno) != 0) {
			return false;
		}
		if (this.mojOkruh.getFormat(tr.to.getMeno()) == null) {
			return false;
		}
		this.pridajFormatNaTransformaciu(tr.to);
		ArrayList al = this.getTransformacieNaFormat(tr.to.getMeno());
		return al.add(tr);
	}
	
	public ArrayList getTransformacieNaFormat(String menoFormatu) {
		Object o = this.transformacie.get(menoFormatu);
		if (o == null) {
			return null;
		}
		return (ArrayList) o;
	}
        
        public ArrayList getJednoducheTransformacieNaFormat(String menoFormatu) {
            ArrayList result = new ArrayList();
            for (Iterator i = this.jednoducheTransformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = ((JednoduchaTransformacia) i.next());
                if (jt.to.getMeno().compareTo(menoFormatu) == 0) {
                    result.add(jt);
                }
            }
            return result;
        }
        
        public JednoduchaTransformacia getJTPodlaId(int id) {
            for (Iterator i = this.jednoducheTransformacie.iterator(); i.hasNext(); ) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                if (jt.id == id) {
                    return jt;
                }
            }
            return null;
        }
        
        public String[] getTransformovatelneFormaty() {
            //ArrayList<String> transformovatelneFormaty = new ArrayList<String>();
            int counter = 0;
            for (Iterator i = this.mojOkruh.formaty.iterator(); i.hasNext();) {
                Format f = (Format) i.next();
                if ((this.transformacie.get(f.getMeno()) != null) && (((ArrayList) this.transformacie.get(f.getMeno())).size() > 0)) {
                    counter++;
                }
            }
            String[] vystup = new String[counter];
            int index = 0;
            for (Iterator i = this.mojOkruh.formaty.iterator(); i.hasNext();) {
                Format f = (Format) i.next();
                if ((this.transformacie.get(f.getMeno()) != null) && (((ArrayList) this.transformacie.get(f.getMeno())).size() > 0)) {                    
                    vystup[index] = f.getMeno();
                    index++;
                }
            }
            return vystup;
        }
        	
	public void vypis() {
		System.out.println("Format "+this.meno);
		System.out.println("Jednoduche transformacie:");
		for (java.util.Iterator i = this.jednoducheTransformacie.iterator(); i.hasNext();) {
			((JednoduchaTransformacia) i.next()).vypis();
		}
		System.out.println();
		System.out.println("Transformacne retaze: "+this.meno);
		Set vystupy = this.transformacie.keySet();
		for (java.util.Iterator i = vystupy.iterator(); i.hasNext();) {
			String vystupnyFormat = (String) i.next();
			System.out.println("Konverzie do "+vystupnyFormat+":");
			int counter = 1;
			ArrayList transformacieDoFormatu = (ArrayList) this.transformacie.get(vystupnyFormat);
			for (java.util.Iterator j = transformacieDoFormatu.iterator();j.hasNext();) {
				System.out.println("Moznost "+counter);
				counter++;
				((TransformacnaRetaz) j.next()).vypis();
			}
			System.out.println();
		}
		System.out.println();
	}
        
        public boolean zmazJTpodlaId(int id) {
            for (Iterator i = this.jednoducheTransformacie.iterator(); i.hasNext();) {
			JednoduchaTransformacia spectated = (JednoduchaTransformacia) i.next();
			if (spectated.id == id) {
				return this.jednoducheTransformacie.remove(spectated);
			}
		}
		return false;
        }
        
        public String printXML() {
            String result = "";
            result = result + "<format meno="+'"'+this.meno+'"'+">";
            for (Iterator i = this.jednoducheTransformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                result = result + "<konverzia do="+'"'+jt.to.getMeno()+'"'+">";
                result = result + jt.predpis.printXML();
                result = result + "</konverzia>";
            }
            result = result + "</format>";
            return result;
        }
        
        public String printFormattedXML(String tab) {
            String result = "";
            result = result + "<format meno="+'"'+this.meno+'"'+">"+System.getProperty("line.separator");
            for (Iterator i = this.jednoducheTransformacie.iterator(); i.hasNext();) {
                result = result.concat(tab+ProgramSettingsHandler.tabulator);
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                result = result + "<konverzia do="+'"'+jt.to.getMeno()+'"'+">" + System.getProperty("line.separator");
                result = result + jt.predpis.printFormattedXML(tab+ProgramSettingsHandler.tabulator + ProgramSettingsHandler.tabulator);
                result = result + tab + ProgramSettingsHandler.tabulator + "</konverzia>" + System.getProperty("line.separator");
            }
            result = result + tab + "</format>"+System.getProperty("line.separator");
            return result;
        }
}





