package bakalarka;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class HistoriaChangedPredpis extends HistoriaZaznam {
    private String oldPredpis;
    private String newPredpis;
    
    public HistoriaChangedPredpis(AdministraciaFrame af, Okruh aktualnyOkruh, Format aktualnyVstupnyFormat, 
            Format aktualnyVystupnyFormat, JednoduchaTransformacia aktualnaTransformacia, String oldPredpis, String newPredpis) {
        this.af = af;
        this.aktualnyOkruh = aktualnyOkruh;
        this.aktualnyVstupnyFormat = aktualnyVstupnyFormat;
        this.aktualnyVystupnyFormat = aktualnyVystupnyFormat;
        this.aktualnaTransformacia = aktualnaTransformacia;
        this.oldPredpis = oldPredpis;
        this.newPredpis = newPredpis;
    }
   
    public void undoAction() {
        try {
            this.aktualnaTransformacia.predpis.setPredpis(oldPredpis, "");

            this.af.e.aktualnyOkruh = this.aktualnyOkruh;
            this.af.e.aktualnyVstupnyFormat = this.aktualnyVstupnyFormat;
            this.af.e.aktualnyVystupnyFormat = this.aktualnyVystupnyFormat;
            this.af.e.aktualnaTransformacia = this.aktualnaTransformacia;
            
            this.af.refreshAll();
            
            this.af.refreshPredpisArea(false);
            this.af.refreshNodesPanel();
            this.af.refreshPrikazPanel();
        } catch (ParserConfigurationException ex) {
            this.af.showError(ex.getMessage());
        } catch (SAXException ex) {
            this.af.showError(ex.getMessage());
        } catch (IOException ex) {
            this.af.showError(ex.getMessage());
        }
        
        
    }
    
    public void redoAction() {
        try {
            this.aktualnaTransformacia.predpis.setPredpis(newPredpis, "");
            
            this.af.e.aktualnyOkruh = this.aktualnyOkruh;
            this.af.e.aktualnyVstupnyFormat = this.aktualnyVstupnyFormat;
            this.af.e.aktualnyVystupnyFormat = this.aktualnyVystupnyFormat;
            this.af.e.aktualnaTransformacia = this.aktualnaTransformacia;
            
            this.af.refreshAll();
            
            this.af.refreshPredpisArea(false);
            this.af.refreshNodesPanel();
            this.af.refreshPrikazPanel();
        } catch (ParserConfigurationException ex) {
            this.af.showError(ex.getMessage());
        } catch (SAXException ex) {
            this.af.showError(ex.getMessage());
        } catch (IOException ex) {
            this.af.showError(ex.getMessage());
        }
    }   

}
