package bakalarka;

import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class InitPasswordFrame extends javax.swing.JFrame {
    
    public InitPasswordFrame() {
        initComponents();
        this.setAlwaysOnTop(true);
    }

    
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        SaveButton = new javax.swing.JButton();
        CancelButton = new javax.swing.JButton();
        Heslo1Field = new javax.swing.JPasswordField();
        Heslo2Field = new javax.swing.JPasswordField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel1.setFont(new java.awt.Font("DejaVu Sans", 1, 14)); // NOI18N
        jLabel1.setText("Nastavenie hesla");
        getContentPane().add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(80, 10, -1, -1));

        jLabel2.setText("Heslo:");
        getContentPane().add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 50, -1, -1));

        jLabel3.setText("Overenie hesla:");
        getContentPane().add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 80, -1, -1));

        SaveButton.setText("Uložiť");
        getContentPane().add(SaveButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 110, 60, -1));
        SaveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SaveButtonActionPerformed(evt);
            }
        });

        CancelButton.setText("Zrušiť");
        CancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                CancelButtonActionPerformed(evt);
            }
        });
        
        getContentPane().add(CancelButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 110, 60, -1));

        Heslo1Field.setColumns(10);
        getContentPane().add(Heslo1Field, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 40, -1, -1));

        Heslo2Field.setColumns(10);
        getContentPane().add(Heslo2Field, new org.netbeans.lib.awtextra.AbsoluteConstraints(140, 70, -1, -1));

        pack();
    }// </editor-fold>

private void formWindowClosing(java.awt.event.WindowEvent evt) {
// TODO add your handling code here:
    this.parentFrame.setEnabled(true);
}

private void SaveButtonActionPerformed(java.awt.event.ActionEvent evt) {
    String heslo1 = new String(this.Heslo1Field.getPassword());
    String heslo2 = new String(this.Heslo2Field.getPassword());
    
    if (heslo1.compareTo(heslo2) != 0) {
        JOptionPane.showMessageDialog(null,
                        "Heslá sa musia rovnať!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
        this.Heslo1Field.setText("");
        this.Heslo2Field.setText("");
    }
    else {
            try {
                ProgramSettingsHandler ph = new ProgramSettingsHandler();
                ph.writePassword(heslo1);
                JOptionPane.showMessageDialog(null,
                        "Úspešne nastavené heslo.",
                        "",
                        JOptionPane.PLAIN_MESSAGE);
                this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
            } catch (FileNotFoundException ex) {
                JOptionPane.showMessageDialog(null,
                        "Nenájdený súbor settings.conf!",
                        "",
                        JOptionPane.ERROR_MESSAGE);                
                this.Heslo1Field.setText("");
                this.Heslo2Field.setText("");
            } catch (IOException ex) {
                JOptionPane.showMessageDialog(null,
                        "Chyba pri čítaní súboru settings.conf!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                this.Heslo1Field.setText("");
                this.Heslo2Field.setText("");
            }
        
    }
}

private void CancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
    this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
}



   
    public void setParentFrame(JFrame frame) {
        this.parentFrame = frame;
        this.parentFrame.setEnabled(false);
    }
    
    
    
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new InitPasswordFrame().setVisible(true);
            }
        });
    }

   
    private javax.swing.JButton CancelButton;
    private javax.swing.JPasswordField Heslo1Field;
    private javax.swing.JPasswordField Heslo2Field;
    private javax.swing.JButton SaveButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    
    
    public JFrame parentFrame = null;
}
