package bakalarka;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


public class Konfiguracia {

	public ArrayList okruhy = new ArrayList(); // mnozina okruhov pouzivana v programe
	
        public Konfiguracia() {
        }
	
	public Konfiguracia(File f) throws ParserConfigurationException, SAXException, IOException {
		this.nacitajKonfiguraciu(f);
	}
    
        
	public void nacitajKonfiguraciu(File f) throws ParserConfigurationException, SAXException, IOException {
		DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
		DocumentBuilder db = dbf.newDocumentBuilder();
		Document doc = db.parse(f);
		doc.getDocumentElement().normalize();
		
		NodeList okruhy = doc.getDocumentElement().getChildNodes();
		for (int s = 0; s < okruhy.getLength(); s++) { // spracovanie
			// okruhov
			Node spracovanyOkruh = okruhy.item(s);
			if (spracovanyOkruh.getNodeType() == Node.ELEMENT_NODE && spracovanyOkruh.getNodeName().compareTo("okruh") == 0) {
				Element okruh = (Element) spracovanyOkruh;
				this.pridajOkruh(okruh.getAttribute("meno"));
				Okruh spracovavanyOkruh = this.getOkruh(okruh
						.getAttribute("meno"));
				NodeList uzlyOkruhu = okruh.getChildNodes();
				String medziformat = "";
				for (int l = 0; l < uzlyOkruhu.getLength(); l++) { // spracovavanie
					// poduzlov
					// okruhu
					Node poduzolOkruhu = uzlyOkruhu.item(l);
					if (poduzolOkruhu.getNodeType() == Node.ELEMENT_NODE) {
						if (poduzolOkruhu.getNodeName().compareTo(
								"medziformat") == 0) { // nacitanie
							// medziformatu pre
							// dany okruh
							medziformat = ((Element) poduzolOkruhu)
									.getAttribute("format"); 
						}
						if (poduzolOkruhu.getNodeName()
								.compareTo("formaty") == 0) {
							NodeList zoznamFormatov = poduzolOkruhu
									.getChildNodes();
							for (int i = 0; i < zoznamFormatov.getLength(); i++) { // pridanie
								// formatov
								// do
								// okruhu
								Node uzolFormatov = zoznamFormatov.item(i);
								if (uzolFormatov.getNodeType() == Node.ELEMENT_NODE
										&& uzolFormatov.getNodeName()
												.compareTo("format") == 0) {
									spracovavanyOkruh
											.pridajFormat(((Element) uzolFormatov)
													.getAttribute("meno"));
								}
							}
							for (int i = 0; i < zoznamFormatov.getLength(); i++) { // pridanie
								// konverzii
								Node uzolFormatov = zoznamFormatov.item(i);
								if (uzolFormatov.getNodeType() == Node.ELEMENT_NODE
										&& uzolFormatov.getNodeName()
												.compareTo("format") == 0) {
									Format spracovavanyFormat = spracovavanyOkruh
											.getFormat(((Element) uzolFormatov)
													.getAttribute("meno"));
									if (spracovavanyFormat != null) {
										NodeList zoznamPoduzlovFormatov = uzolFormatov
												.getChildNodes();
										for (int k = 0; k < zoznamPoduzlovFormatov
												.getLength(); k++) {
											Node poduzolFormatov = zoznamPoduzlovFormatov
													.item(k);
											if (poduzolFormatov
													.getNodeType() == Node.ELEMENT_NODE
													&& poduzolFormatov
															.getNodeName()
															.compareTo(
																	"konverzia") == 0) {
												String menoVystupnehoFormatu = ((Element) poduzolFormatov)
														.getAttribute("do");
												Format vystupnyFormat = spracovavanyOkruh
														.getFormat(menoVystupnehoFormatu);
												if (vystupnyFormat != null) {
													JednoduchaTransformacia spracovavanaTransformacia = new JednoduchaTransformacia(
															spracovavanyFormat,
															vystupnyFormat,
															spracovavanyOkruh);
													Predpis predpis = new Predpis();
                                                                                                        String m = ProgramSettingsHandler.tabulator;
													predpis.setPredpis(poduzolFormatov.getChildNodes(), m+m+m+m+m);
													spracovavanaTransformacia.predpis = predpis;
													spracovavanyFormat.pridajJednoduchuTransformaciu(spracovavanaTransformacia);
												}
											}
										}
									}
								}
							}
						}
					}
				}
				spracovavanyOkruh.setMedziformat(medziformat);
			}
		}
	}
	
	public boolean pridajOkruh(String meno) {
		if (this.getOkruh(meno) == null) {
			Okruh o = new Okruh(meno);
			return this.okruhy.add(o);
		}
		return false; 
	}
	
	public Okruh getOkruh(String meno) {
		for (Iterator i = okruhy.iterator(); i.hasNext();) {
			Okruh spectated = (Okruh) i.next();
			if (spectated.meno.compareTo(meno) == 0) {
				return spectated;
			}
		}
		return null;
	}
	
	public boolean zmazOkruh(String meno) {
		for (Iterator i = okruhy.iterator(); i.hasNext();) {
			Okruh spectated = (Okruh) i.next();
			if (spectated.meno.compareTo(meno) == 0) {
				return okruhy.remove(spectated);
			}
		}
		return false;
	}
	
	public void vypis() {
		System.out.println("Konfiguracia programu:");
		int count = 1;
		for (Iterator i = this.okruhy.iterator(); i.hasNext();) {
			System.out.print(count+". ");
			((Okruh) i.next()).vypis();
			count++;
		}
	}
	
	public void vypocitajUzaver() {
		for (Iterator i = this.okruhy.iterator(); i.hasNext();) {
			Object o = i.next();
			if (o.getClass().getName().endsWith("Okruh")) {
				((Okruh) o).vypocitajUzaver();
			}
		}
	}
        
        public String printXML() {
            String result = "";
            result = result.concat("<?xml version="+'"'+"1.0"+'"'+"?>");
            result = result.concat("<konverznyProgram>");
            for (Iterator i = okruhy.iterator(); i.hasNext();) {
                result = result.concat(((Okruh) i.next()).printXML());
            }
            result = result.concat("</konverznyProgram>");
            return result;
        }
        
        public String printFormattedXML() {
            String result = "";
            result = result.concat("<?xml version="+'"'+"1.0"+'"'+"?>");
            result = result.concat("<konverznyProgram>"+System.getProperty("line.separator"));
            for (Iterator i = okruhy.iterator(); i.hasNext();) {
                result = result.concat(ProgramSettingsHandler.tabulator);
                result = result.concat(((Okruh) i.next()).printFormattedXML(ProgramSettingsHandler.tabulator));
            }
            result = result.concat("</konverznyProgram>");
            return result;
        }
}
