package bakalarka;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;



public class KonverziaFrame extends javax.swing.JFrame {
    
    Process p;
    
    public BakalarkaMainFrame parentFrame = null;
    public JPanel mainPanel;
    public JTextArea prikazyArea;
    public JScrollPane prikazyAreaScrollPane;
    public JTextArea vypisArea;
    public JScrollPane vypisAreaScrollPane;
    public JTextArea errorArea;
    public JScrollPane errorAreaScrollPane;
    public JButton convertButton;
    public JButton cancelButton;
    
    
    public KonverziaFrame() {
        this.setVisible(true);
        initComponents();
        //this.setAlwaysOnTop(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
    }

   public void setParentFrame(BakalarkaMainFrame jf) {
        this.parentFrame = jf;
        jf.setEnabled(false);
        this.setVisible(true);
    }   
    
    private void initComponents() {        
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mainPanel = new JPanel(new java.awt.GridBagLayout());        
        
        this.setTitle("Konverzia");
                
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        
        Insets labelIns = new Insets(10, 0, 5, 0);
        Insets noIns = new Insets(0, 0, 0, 0);
        Insets buttonIns = new Insets(15, 15, 0, 30);
        
        gbc.insets = labelIns;
        mainPanel.add(new JLabel("Príkazy"), gbc);
        
        
        prikazyArea = new JTextArea();
        prikazyArea.setEditable(false);
        prikazyArea.setForeground(Color.BLUE);
        prikazyArea.setLineWrap(true);
        prikazyArea.setWrapStyleWord(true);
        prikazyArea.setRows(5);
        prikazyArea.setColumns(100);
        
        prikazyAreaScrollPane = new JScrollPane(prikazyArea);
        prikazyAreaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        
        gbc.gridwidth = 100;
        gbc.gridy++;
        gbc.insets = noIns;
        mainPanel.add(prikazyAreaScrollPane, gbc);
        gbc.gridwidth = 1;
        
        gbc.gridy++;
        gbc.insets = labelIns;
        mainPanel.add(new JLabel("Výstup"), gbc);
        
        vypisArea = new JTextArea();
        vypisArea.setEditable(false);
        vypisArea.setBackground(Color.BLACK);
        vypisArea.setForeground(Color.WHITE);
        vypisArea.setLineWrap(true);
        vypisArea.setWrapStyleWord(true);
        vypisArea.setRows(15);
        vypisArea.setColumns(100);
        
        vypisAreaScrollPane = new JScrollPane(vypisArea);
        vypisAreaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        
        gbc.gridwidth = 100;
        gbc.gridy++;
        gbc.insets = noIns;
        mainPanel.add(vypisAreaScrollPane, gbc);
        gbc.gridwidth = 1;
        
        
        gbc.gridy++;
        gbc.insets = labelIns;
        mainPanel.add(new JLabel("Chybový výstup"), gbc);
        
        errorArea = new JTextArea();
        errorArea.setEditable(false);
        errorArea.setForeground(Color.RED);
        errorArea.setLineWrap(true);
        errorArea.setWrapStyleWord(true);
        errorArea.setRows(10);
        errorArea.setColumns(100);
        
        errorAreaScrollPane = new JScrollPane(errorArea);
        errorAreaScrollPane.setVerticalScrollBarPolicy(
                        JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        
        gbc.gridwidth = 100;
        gbc.gridy++;
        gbc.insets = noIns;
        mainPanel.add(errorAreaScrollPane, gbc);
        gbc.gridwidth = 1;
        
        
        convertButton = new JButton("Konvertuj!");
        gbc.gridx = 0;
        gbc.gridy++;
        gbc.insets = buttonIns;
        convertButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                convertButtonActionPerformed(evt);
            }
        });
        mainPanel.add(convertButton, gbc);
        
        cancelButton = new JButton("Zrušiť!");
        gbc.gridx = 1;
        gbc.insets = buttonIns;
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        
        mainPanel.add(cancelButton, gbc);
        
        getContentPane().add(mainPanel);
        pack();
        
    }
  
    
    public void convertButtonActionPerformed(ActionEvent evt) {
        runCommands();
    }
    
    public void cancelButtonActionPerformed(ActionEvent evt) {
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }
    
    
    public void runCommands() {
       final JTextArea vypisovePole = vypisArea;
       
       Runnable longTask = new Runnable() {
            private JTextArea vypisovePole2 = vypisovePole;
           
       public void run() {
         // Run task to do long stuff
         try {
            String s = null;
            String e = null;
            
            String vstupnaCestaBezSuboru = parentFrame.p.vstup.cesta;
            if (vstupnaCestaBezSuboru.lastIndexOf("/") != -1) {
               vstupnaCestaBezSuboru = vstupnaCestaBezSuboru.substring(0, vstupnaCestaBezSuboru.lastIndexOf("/")+1);
            }
            
            String vystupnaCestaBezSuboru = parentFrame.p.vystup.cesta+"/";
            
            for (Iterator i = parentFrame.p.pouzitaTransRetaz.transformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                
                jt.predpis.setVstup(new VstupnySubor(vstupnaCestaBezSuboru+parentFrame.p.menoVstupnehoSuboru+"."+jt.from.getMeno()));
                jt.predpis.setVystup(new VystupnySubor(vystupnaCestaBezSuboru+parentFrame.p.menoVstupnehoSuboru+"."+jt.to.getMeno()));
                String prikaz = jt.predpis.getValue();
                
                prikazyArea.append(prikaz);
                
                String vstup = vstupnaCestaBezSuboru+parentFrame.p.menoVstupnehoSuboru+"."+jt.from.getMeno();
                vstup = vstup.trim();
                
                String vystup1 = vystupnaCestaBezSuboru+parentFrame.p.menoVstupnehoSuboru+"."+jt.to.getMeno();
                vystup1 = vystup1.trim();
                
                String vystup2 = vystupnaCestaBezSuboru;
                vystup2 = vystup2.trim();
                
                ArrayList commands = new ArrayList();
                while (prikaz.compareTo("") != 0) {
                    prikaz = prikaz.trim();

                                        
                    if (prikaz.startsWith(vystup1)) {
                        commands.add(new String(vystup1));
                        prikaz = prikaz.substring(vystup1.length());
                    }
                    else if (prikaz.startsWith(vstup)) {
                        commands.add(new String(vstup));                        
                        prikaz = prikaz.substring(vstup.length());
                    }
                    else if (prikaz.startsWith(vystup2)) {
                        commands.add(new String(vystup2));
                        prikaz = prikaz.substring(vystup2.length());
                    }                    
                    else {
                        if (prikaz.indexOf(" ") != -1) {
                            commands.add(new String(prikaz.substring(0, prikaz.indexOf(" "))));
                            prikaz = prikaz.substring(prikaz.indexOf(" "), prikaz.length());
                        }
                        else {
                            if (prikaz.trim().compareTo("") != 0) {
                                commands.add(prikaz.trim());
                                prikaz = "";
                            }
                        }
                    }
                }
                
                if (commands.size() == 0) {
                    break;
                }
                String[] cmd = new String[commands.size()];
                int counter = 0;
                for (Iterator j = commands.iterator(); j.hasNext();) {
                    cmd[counter] = ((String) j.next());
                    counter++;
                }
                                
               p = Runtime.getRuntime().exec(cmd);
                
                convertButton.setEnabled(false);
                
                BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                
                
                boolean sIde = true;
                
                while (((s = stdInput.readLine()) != null) || ((e = stdError.readLine()) != null)) {
                    if (sIde) {
                        if (s != null) {
                        vypisovePole2.setText(this.vypisovePole2.getText() + s + System.getProperty("line.separator"));
                        vypisArea.repaint();
                        vypisArea.setCaretPosition(vypisArea.getText().length());
                        }

                        if (e != null) {
                            errorArea.setText(errorArea.getText() + e + System.getProperty("line.separator"));                            
                            errorArea.repaint();
                            errorArea.setCaretPosition(errorArea.getText().length());
                        }
                        sIde = false;
                   }
                   else {
                       if (e != null) {
                            errorArea.setText(errorArea.getText() + e + System.getProperty("line.separator"));
                            errorArea.repaint();
                            errorArea.setCaretPosition(errorArea.getText().length());
                       }
                         
                       if (s != null) {
                            vypisovePole2.setText(this.vypisovePole2.getText() + s + System.getProperty("line.separator"));
                            vypisArea.repaint();
                            vypisArea.setCaretPosition(vypisArea.getText().length());
                       }
                       sIde = true;
                   }
                }
              
                
                prikazyArea.setText(prikazyArea.getText() + "....... FINISHED" + System.getProperty("line.separator"));
                prikazyArea.repaint();
                prikazyAreaScrollPane.repaint();
                mainPanel.repaint();
                prikazyArea.setCaretPosition(prikazyArea.getText().length());
            }
            convertButton.setEnabled(true);
            Iterator i = parentFrame.p.pouzitaTransRetaz.transformacie.iterator();
            i.next();
            while (i.hasNext()) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                deleteFile(vystupnaCestaBezSuboru+parentFrame.p.menoVstupnehoSuboru+"."+jt.from.getMeno());
                if (i.hasNext()) {
                    i.next();
                }                
            }
            JOptionPane.showMessageDialog(null,
                "Transformácie skončené!",
                "",
                JOptionPane.PLAIN_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(null,
                "Chyba konverzie!"+System.getProperty("line.separator")+"Detaily:"+ex.getMessage(),
                "",
                JOptionPane.ERROR_MESSAGE);
        }
           
           
         
         Runnable awtTask = new Runnable() {
           public void run() {
           }
         };
        EventQueue.invokeLater(awtTask);
       }
     };
      Thread t = new Thread(longTask);
      t.setPriority(Thread.NORM_PRIORITY);
      t.start();
       
    }
  
    
    private void formWindowClosing(java.awt.event.WindowEvent evt) {
        if (p != null) {
            p.destroy();
        }
        this.parentFrame.setEnabled(true);
    }
    
    private void deleteFile(String fileName) {
    try {
      // Construct a File object for the file to be deleted.
      File target = new File(fileName);

      if (!target.exists()) {
        return;
      }      
      target.delete();
      
    } catch (SecurityException e) {
    }
  }

}

