package bakalarka;

import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class LoginFrame extends javax.swing.JFrame {

   
    public LoginFrame() {
        initComponents();
    }

    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jPasswordField1 = new javax.swing.JPasswordField();
        LoginButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
        setResizable(false);

        jLabel1.setFont(new java.awt.Font("DejaVu Sans", 1, 14)); // NOI18N
        jLabel1.setText("Prihlásenie do administrácie");

        jLabel2.setText("Heslo:");

        jPasswordField1.setColumns(10);

        LoginButton.setText("Prihlásiť");
        LoginButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                LoginButtonActionPerformed(evt);
            }
        });
        
       javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(24, 24, 24)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPasswordField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(LoginButton)
                .addContainerGap())
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap(37, Short.MAX_VALUE)
                .addComponent(jLabel1)
                .addGap(28, 28, 28))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel2)
                    .addComponent(jPasswordField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(LoginButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }

    
    private void LoginButtonActionPerformed(java.awt.event.ActionEvent evt) {
        String candidate = new String(this.jPasswordField1.getPassword());
        try {
            ProgramSettingsHandler ph = new ProgramSettingsHandler();
            if (ph.checkPassword(candidate)) {               
                AdministraciaFrame af = new AdministraciaFrame();
                af.setParentFrame((BakalarkaMainFrame) this.parentFrame);
                af.setLocationRelativeTo(this.LoginButton);
                af.setVisible(true);
                this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
            }
            else {
                JOptionPane.showMessageDialog(null,
                        "Nesprávne heslo!",
                        "",
                        JOptionPane.ERROR_MESSAGE);
                this.jPasswordField1.setText("");
            }
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(null,
                        "Nenájdený súbor settings.conf",
                        "",
                        JOptionPane.ERROR_MESSAGE);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(null,
                        "Chyba pri čítaní súboru settings.conf",
                        "",
                        JOptionPane.ERROR_MESSAGE);
        }
        
    }
    
    
    public void setParentFrame(JFrame frame) {
        this.parentFrame = frame;
        this.parentFrame.setEnabled(false);
    }
    
    private void formWindowClosing(java.awt.event.WindowEvent evt) {
    // TODO add your handling code here:
        this.parentFrame.setEnabled(true);
    }

    // Variables declaration - do not modify
    private javax.swing.JButton LoginButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPasswordField jPasswordField1;
    
    public JFrame parentFrame = null;
    // End of variables declaration

}
