package bakalarka;

import java.util.ArrayList;
import java.util.Iterator;


public class Okruh {

	public String meno="";
	public ArrayList formaty = new ArrayList(); // mnozina formatov v okruhu
	public Format medziformat = new Format("",this);
	public int transformacieCounter;		//pocitadlo,pomocou ktoreho sa prideluju ID jednoduchym transformaciam
	public int transformacneRetazeCounter;	//pocitadlo,pomocou ktoreho sa prideluju ID transformacnym retaziam	
	
	
	public Okruh(String meno) {
		this.meno = meno;
		this.formaty = new ArrayList();
		this.transformacieCounter = 0;
		this.transformacneRetazeCounter = 0;
	}
	
	public String getMeno() {
		return this.meno;
	}
	
	public Format getMedziformat() {
		return this.medziformat;
	}
	
	public void setMedziformat(String meno) {
		for (Iterator i = formaty.iterator(); i.hasNext();) {
			Format f = ((Format) i.next()); 
			if ( f.getMeno().compareTo(meno) == 0) {
				this.medziformat = f;
				return;
			}
		}
	}
	
	public int getTransformacieCounter() {
		this.transformacieCounter++;
		return (this.transformacieCounter-1);
	}
	
	public int getTransformacneRetazeCounter() {
		this.transformacneRetazeCounter++;
		return (this.transformacneRetazeCounter-1);
	}
	
	public boolean pridajFormat(String meno) {
		if (this.getFormat(meno) == null) {
			Format f = new Format(meno,this);
			return this.formaty.add(f);
		}
		return false; 
	}
	
	public boolean pridajFormat(Format f) {
		if (this.getFormat(f.getMeno()) == null) {
			return this.formaty.add(f);
		}
		return false;
	}
	
	public Format getFormat(String meno) {
		Iterator i = this.formaty.iterator();
		for (; i.hasNext();) {
			Format spectated = (Format) i.next();
			if (spectated.meno.compareTo(meno) == 0) {
				return spectated;
			}
		}
		return null;
	}
	
	public boolean zmazFormat(String meno) {
		for (Iterator i = formaty.iterator(); i.hasNext();) {
			Format spectated = (Format) i.next();
			if (spectated.meno.compareTo(meno) == 0) {
				return formaty.remove(spectated);
			}
		}
		return false;
	}
	
	public void vypocitajUzaver() {
		for (Iterator s = this.formaty.iterator();s.hasNext();) {
			Format stred = (Format) s.next();
			for (Iterator f = this.formaty.iterator();f.hasNext();) {
				Format from = (Format) f.next();
				for (Iterator t = this.formaty.iterator();t.hasNext();) {
					Format to = (Format) t.next();
					if (from.equals(stred) || to.equals(stred) || from.equals(to)) {
						continue;
					}
					ArrayList fromTransformacie = from.getTransformacieNaFormat(stred.getMeno());
					ArrayList toTransformacie = stred.getTransformacieNaFormat(to.getMeno());
					if (fromTransformacie != null && toTransformacie != null) {
						for (Iterator ft = fromTransformacie.iterator();ft.hasNext();) {
							TransformacnaRetaz fromTR = (TransformacnaRetaz) ft.next();
							for (Iterator tt = toTransformacie.iterator();tt.hasNext();) {								
								TransformacnaRetaz toTR = (TransformacnaRetaz) tt.next();
								if (!fromTR.spolocnyFormat(toTR)) {
									from.pridajTransformacnuRetaz(fromTR.zretaz(toTR));
								}
							}
						}
					}
				}
			}
		}
	}
	
	
	public void vypis() {
		System.out.println("Okruh: "+this.meno+", Medziformat: "+this.medziformat.getMeno());
		System.out.println();
		int count = 1;
		for (Iterator i = this.formaty.iterator(); i.hasNext();) {
			System.out.print(count+". ");
			((Format) i.next()).vypis();
			count++;
		}
		System.out.println();
	}
        
        public String printXML() {
            String result = "";
            result = result + "<okruh meno="+'"'+this.meno+'"'+">";
            result = result+"<formaty>";
            for (Iterator i = this.formaty.iterator(); i.hasNext();) {
                result = result+ ((Format) i.next()).printXML();
            }
            result = result+"</formaty>";
            result = result + "</okruh>";
            return result;
        }
        
        
        public String printFormattedXML(String tab) {
            String result = "";
            result = result + "<okruh meno="+'"'+this.meno+'"'+">"+System.getProperty("line.separator");
            result = result+tab+ProgramSettingsHandler.tabulator+"<formaty>"+System.getProperty("line.separator");
            for (Iterator i = this.formaty.iterator(); i.hasNext();) {
                result = result.concat(tab+ProgramSettingsHandler.tabulator+ProgramSettingsHandler.tabulator);
                result = result+ ((Format) i.next()).printFormattedXML(tab+ProgramSettingsHandler.tabulator+ProgramSettingsHandler.tabulator);
            }
            result = result+tab+ProgramSettingsHandler.tabulator+"</formaty>"+System.getProperty("line.separator");
            result = result + tab + "</okruh>" + System.getProperty("line.separator");
            return result;
        }
	
}
