package bakalarka;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Predpis {
	public ArrayList vstupy = new ArrayList();	// referencie na objekty,ktore umoznuju vkladanie volieb pre transformaciu
	public ArrayList prikazy = new ArrayList();	// zretazenim zoznamu prikazov dostavame vysledny prikaz,ktory spusta transformaciu
        String lastValue = null;
	
	
        public void setPredpis(String xml, String tab) throws ParserConfigurationException, SAXException, IOException {
            xml = (new String("<?xml version="+'"'+"1.0"+'"'+"?><predpis>")).concat(xml);
            xml = xml.concat("</predpis>");
            
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = factory.newDocumentBuilder();
            InputSource inStream = new InputSource();
            inStream.setCharacterStream(new StringReader(xml));
            Document doc = db.parse(inStream);
            doc.getDocumentElement().normalize();
                        
            setPredpis(doc.getElementsByTagName("predpis").item(0).getChildNodes(), tab);
        }
        
        public void setPredpis(NodeList uzly, String tab) {
            vstupy = new ArrayList();
            prikazy = new ArrayList();
            for (int i = 0; i<uzly.getLength(); i++) {
                    Node uzol = uzly.item(i);
                    if ((uzol.getNodeType() == Node.TEXT_NODE)) {                            
                            String text = uzol.getNodeValue();
                            String vysledok = filterInputText(text, tab);
                            if (vysledok.compareTo("") != 0) {
                                this.pridajText(vysledok);
                            }                            
                            continue;
                    }
                    if (uzol.getNodeType() == Node.ELEMENT_NODE) {
                            if (uzol.getNodeName().compareTo("inputbox") == 0) {
                                    String defaultValue = "";
                                    defaultValue = ((Element) uzol).getAttribute("default");
                                    String meno = ((Element) uzol).getAttribute("meno");
                                    InputBox ib = new InputBox(defaultValue);
                                    ib.setNazov(meno);
                                    this.pridajInputBox(ib);
                            }
                            if (uzol.getNodeName().compareTo("vstup") == 0) {
                               VstupnySubor vstup = new VstupnySubor("");
                               this.pridajVstupnySubor(vstup);
                            }
                            if (uzol.getNodeName().compareTo("vystup") == 0) {
                                    VystupnySubor vystup = new VystupnySubor("");
                                    String wholePath = "";
                                    wholePath = ((Element) uzol).getAttribute("wholePath");
                                    if (wholePath.compareTo("yes") == 0) {
                                        vystup.wholePath = true;
                                    }
                                    this.pridajVystupnySubor(vystup);
                            }
                            if (uzol.getNodeName().compareTo("checkbox") == 0) {
                                    CheckBox chb = new CheckBox();
                                    String nazov = "";
                                    Element e = (Element) uzol;
                                    chb.setNazov(e.getAttribute("meno"));
                                    if (e.getAttribute("selected").compareTo("yes") == 0) {
                                            chb.enable();
                                    }
                                    else {chb.disable();}
                                    chb.hodnota = new Predpis();
                                    chb.hodnota.setPredpis(uzol.getChildNodes(), tab+ProgramSettingsHandler.tabulator);
                                    this.pridajCheckBox(chb);
                            }
                            if (uzol.getNodeName().compareTo("selectbox") == 0) {
                                    SelectBox sb = new SelectBox();
                                    Element e = (Element) uzol;
                                    String defaultOption = e.getAttribute("default");
                                    sb.setNazov(e.getAttribute("meno"));
                                    Option spracOp;
                                    NodeList poduzlySelBoxu = uzol.getChildNodes();
                                    for (int j = 0; j<poduzlySelBoxu.getLength(); j++) {
                                            Node poduzolSelBoxu = poduzlySelBoxu.item(j);
                                            if (poduzolSelBoxu.getNodeType() == Node.ELEMENT_NODE && poduzolSelBoxu.getNodeName().compareTo("option") == 0) {
                                                    spracOp = new Option();
                                                    spracOp.setNazov( ((Element) poduzolSelBoxu).getAttribute("meno") );
                                                    spracOp.predpis = new Predpis();
                                                    spracOp.predpis.setPredpis(poduzolSelBoxu.getChildNodes(), tab + ProgramSettingsHandler.tabulator + ProgramSettingsHandler.tabulator);
                                                    sb.pridajOption(spracOp);
                                            }
                                    }
                                    sb.setDefaultnaOption(defaultOption);
                                    this.pridajSelectBox(sb);
                            }
                    }
            }
            if (this.prikazy.isEmpty()) {
                this.pridajText("");
            }
	}
        
        public String filterInputText(String text, String tab) {
            String result = "";
            text = text+" ";
            String[] riadky = text.split(System.getProperty("line.separator"));            
            int beginIndex = 1;
            if ((riadky.length > 0) && (riadky[0].trim().compareTo("") != 0)) {
                beginIndex = 0;
            }
            int endIndex = riadky.length-1;
            for (int i = beginIndex; i < endIndex; i++) {
                if (riadky[i].startsWith(tab)) {
                    result = result.concat(riadky[i].substring(tab.length()) + System.getProperty("line.separator"));
                }
                else {
                    result = result.concat(riadky[i] + System.getProperty("line.separator"));
                }
            }
            
            if (result.length() > 0) {
                result = result.substring(0, result.length()-1);
            }
            return result;
        }
        
        public boolean isConfigurable() {
            if (this.vstupy != null && this.vstupy.size() != 0) {
                return true;
            }
            return false;
        }
	
	public void setVstup(VstupnySubor vstup) {
		for (Iterator i = this.prikazy.iterator(); i.hasNext();) {
			Object o = i.next();
                        if (o.getClass().getName().endsWith("VstupnySubor")) {
                            ((VstupnySubor) o).cesta = vstup.cesta;
                        }
			if (o.getClass().getName().endsWith("CheckBox")) {
				((CheckBox) o).hodnota.setVstup(vstup);
			}
			if (o.getClass().getName().endsWith("SelectBox")) {
				SelectBox sb = (SelectBox) o;
				for (Iterator j = sb.options.iterator(); j.hasNext();) {
					((Option) j.next()).predpis.setVstup(vstup);
				}
			}
		}
	}
	
	public void setVystup(VystupnySubor vystup) {		
		for (Iterator i = this.prikazy.iterator(); i.hasNext();) {
			Object o = i.next();
                        if (o.getClass().getName().endsWith("VystupnySubor")) {
                            ((VystupnySubor) o).cesta = vystup.cesta;
                        }
			if (o.getClass().getName().endsWith("CheckBox")) {
				((CheckBox) o).hodnota.setVystup(vystup);
			}
			if (o.getClass().getName().endsWith("SelectBox")) {
				SelectBox sb = (SelectBox) o;
				for (Iterator j = sb.options.iterator(); j.hasNext();) {
					((Option) j.next()).predpis.setVystup(vystup);
				}
			}
		}
	}
	
	public boolean pridajText(String text) {
		return prikazy.add(text);
	}
	
	public boolean pridajInputBox(InputBox ib) {
		ib.setID(this.vstupy.size());
		vstupy.add(ib);		
		return prikazy.add(ib);
	}
	
	public boolean pridajCheckBox(CheckBox chb) {
		chb.setID(this.vstupy.size());
		vstupy.add(chb);
		return prikazy.add(chb);
	}
	
	public boolean pridajSelectBox(SelectBox sb) {
		sb.setID(this.vstupy.size());
		vstupy.add(sb);
		return prikazy.add(sb);
	}
	
	public boolean pridajVstupnySubor(VstupnySubor vs) {
		return prikazy.add(vs);
	}
	
	public boolean pridajVystupnySubor(VystupnySubor vs) {
		return prikazy.add(vs);
	}
	
	public Object getBoxByID(int id) {
		if (id >=0 && id < this.vstupy.size()) {
			return this.vstupy.get(id);
		}
		return null;
	}
	
	public String getValue() {
		String vysledok = "";
		for (Iterator i = this.prikazy.iterator();i.hasNext();) {
			Object o = i.next();
			if (o.getClass().getName().endsWith("String")) {
				vysledok = vysledok.concat(((String) o));
			}
			else
				if (o.getClass().getName().endsWith("InputBox")) {
					vysledok = vysledok.concat(((InputBox) o).getValue());
				}
				else if (o.getClass().getName().endsWith("SelectBox")) {
					vysledok = vysledok.concat(((SelectBox) o).getValue());
				}
				else if (o.getClass().getName().endsWith("CheckBox")) {
					vysledok = vysledok.concat(((CheckBox) o).getValue());
				}
				else if (o.getClass().getName().endsWith("VstupnySubor")) {
					vysledok = vysledok.concat(((VstupnySubor) o).getValue());
				}
				else if (o.getClass().getName().endsWith("VystupnySubor")) {
					vysledok = vysledok.concat(((VystupnySubor) o).getValue());
				}
		}
		return vysledok;
	}
	
        
	public String getNormalizedValue() {
		String vysledok="";
		for (Iterator i = this.prikazy.iterator();i.hasNext();) {
			Object o = i.next();
			if (o.getClass().getName().endsWith("String")) {
				vysledok = vysledok.trim().concat(" ");
				vysledok = vysledok.concat(((String) o));
			}
			else
				if (o.getClass().getName().endsWith("InputBox")) {
					vysledok = vysledok.trim().concat(" ");
					vysledok = vysledok.concat(((InputBox) o).getNormalizedValue());
				}
				else if (o.getClass().getName().endsWith("SelectBox")) {
					vysledok = vysledok.trim().concat(" ");
					vysledok = vysledok.concat(((SelectBox) o).getNormalizedValue());
				}
				else if (o.getClass().getName().endsWith("CheckBox")) {
					vysledok = vysledok.trim().concat(" ");
					vysledok = vysledok.concat(((CheckBox) o).getNormalizedValue());
				}
				else if (o.getClass().getName().endsWith("VstupnySubor")) {
					vysledok = vysledok.trim().concat(" ");
					vysledok = vysledok.concat(((VstupnySubor) o).getNormalizedValue());
				}
				else if (o.getClass().getName().endsWith("VystupnySubor")) {
					vysledok = vysledok.trim().concat(" ");
					vysledok = vysledok.concat(((VystupnySubor) o).getNormalizedValue());
				}
		}
		return vysledok.trim();
	}
       
        
    public void paintPanel(final SettingsPanel addedPanel, final SettingsFrame sFrame) {        
        GridBagConstraints componentGridBagConstraints = new GridBagConstraints();
        int cgbcWidth = 500;
        componentGridBagConstraints.fill = GridBagConstraints.BOTH;
        componentGridBagConstraints.anchor = GridBagConstraints.LINE_START;
        componentGridBagConstraints.gridx = 0;
        componentGridBagConstraints.gridy = 0;
        JLabel jLabel1;
        for (Iterator i = this.vstupy.iterator(); i.hasNext();) {
            Object o = i.next();
            if (o.getClass().getName().endsWith("InputBox")) {
                final InputBox ib = (InputBox) o;
                String s = new String("");
                if (ib.value != null) {
                    s = ib.value;
                }
                else if (ib.defaultValue != null) {
                    s = ib.defaultValue;
                }
                
                final JTextField jTextField1 = new JTextField();
                jTextField1.setText(s);
                addedPanel.add(jTextField1, componentGridBagConstraints);
                                
                jTextField1.addKeyListener(new java.awt.event.KeyAdapter() {
                    public void keyReleased(java.awt.event.KeyEvent evt) {
                        ib.setValue(jTextField1.getText());
                        jTextField1.repaint();
                        sFrame.repaint();
                        sFrame.pack();
                        sFrame.myCorrection();                        
                    }
                });
                
                jLabel1 = new JLabel();
                jLabel1.setText(((InputBox) o).getNazov());
                componentGridBagConstraints.gridx = 1;
                componentGridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
                addedPanel.add(jLabel1, componentGridBagConstraints);
                sFrame.components.add(jLabel1);
                componentGridBagConstraints.gridx = 0;
                componentGridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
                
                componentGridBagConstraints.gridy++;
            }
            if (o.getClass().getName().endsWith("CheckBox")) {
                final SettingsPanel JPanelCh;
                final CheckBox chb = (CheckBox) o;
                final JCheckBox jCheckBox1 = new JCheckBox();
                jCheckBox1.setText(chb.nazov);
                jCheckBox1.setSelected(chb.checked);
                addedPanel.add(jCheckBox1, componentGridBagConstraints);
                sFrame.components.add(jCheckBox1);
                componentGridBagConstraints.gridy++;
                
                
                JPanelCh = new SettingsPanel();
                JPanelCh.parent = addedPanel;
                JPanelCh.setLayout(new java.awt.GridBagLayout());
                chb.paintPanel(JPanelCh,sFrame);
                componentGridBagConstraints.insets = new java.awt.Insets(5, 20, 0, 0);
                componentGridBagConstraints.gridwidth = cgbcWidth;
                componentGridBagConstraints.fill = GridBagConstraints.NONE;
                addedPanel.add(JPanelCh, componentGridBagConstraints);
                sFrame.components.add(JPanelCh);
                componentGridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
                componentGridBagConstraints.gridy++;
                componentGridBagConstraints.gridwidth = 1;
                componentGridBagConstraints.fill = GridBagConstraints.BOTH;
                
                jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        if (jCheckBox1.isSelected()) {
                            chb.enable();                           
                        }
                        else {
                            chb.disable();                            
                        }
                        int pocetPred = JPanelCh.getComponents().length;
                        JPanelCh.removeAll();
                        chb.paintPanel(JPanelCh,sFrame);
                        JPanelCh.repaint();
                        sFrame.repaint();
                        if (!(pocetPred == 0 && JPanelCh.getComponents().length == 0)) {
                            sFrame.pack();
                            sFrame.myCorrection();
                        }
                    }
                });                
                
            }
            
            if (o.getClass().getName().endsWith("SelectBox")) {
                final SelectBox sb = (SelectBox) o;
                final JComboBox jComboBox1 = new JComboBox();
                String[] optiony = new String[sb.options.size()];
                int j = 0;
                for (Iterator i1 = sb.options.iterator(); i1.hasNext();) {
                    optiony[j] = ((Option) i1.next()).nazov;
                    j++;
                }                    
                jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(optiony));
                Option vybrataOption = sb.getVybrataOption();
                if (vybrataOption != null) {
                    jComboBox1.setSelectedItem(vybrataOption.nazov);
                }
                
                addedPanel.add(jComboBox1, componentGridBagConstraints);
                sFrame.components.add(jComboBox1);
                
                jLabel1 = new JLabel();
                jLabel1.setText(sb.nazov);
                componentGridBagConstraints.gridx = 1;
                componentGridBagConstraints.insets = new java.awt.Insets(0, 5, 0, 0);
                addedPanel.add(jLabel1, componentGridBagConstraints);
                sFrame.components.add(jLabel1);
                componentGridBagConstraints.gridy++;
                componentGridBagConstraints.gridx = 0;
                componentGridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
                
                final SettingsPanel JPanelSb = new SettingsPanel();
                JPanelSb.parent = addedPanel;
                JPanelSb.setLayout(new java.awt.GridBagLayout());
                sb.paintPanel(JPanelSb,sFrame);
                componentGridBagConstraints.insets = new java.awt.Insets(5, 20, 0, 0);
                componentGridBagConstraints.gridwidth = cgbcWidth;
                componentGridBagConstraints.fill = GridBagConstraints.NONE;
                addedPanel.add(JPanelSb, componentGridBagConstraints);
                sFrame.components.add(JPanelSb);
                componentGridBagConstraints.gridy++;
                componentGridBagConstraints.gridwidth = 1;
                componentGridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 0);
                componentGridBagConstraints.fill = GridBagConstraints.BOTH;
                
                
                jComboBox1.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        if (sb.getVybrataOption().getNazov().compareTo((String) jComboBox1.getSelectedItem()) != 0) {
                            int pocetPred = JPanelSb.getComponents().length;
                            sb.setVybrataOption((String) jComboBox1.getSelectedItem());                            
                            JPanelSb.removeAll();
                            sb.paintPanel(JPanelSb,sFrame);
                            JPanelSb.repaint();
                            sFrame.repaint();
                            if (!(pocetPred == 0 && JPanelSb.getComponents().length == 0)) {
                                sFrame.pack();
                                sFrame.myCorrection();
                            }
                        }
                    }
                });
            }            
         
        }
    }

    
    public String printXML() {
        String result = new String("");
        for (Iterator i = this.prikazy.iterator(); i.hasNext();) {
            Object o = i.next();
            if (o.getClass().getName().endsWith("InputBox")) {
                result = result.concat(((InputBox) o).printXML());
            }
            else if (o.getClass().getName().endsWith("SelectBox")) {
                result = result.concat(((SelectBox) o).printXML());
            }
            else if (o.getClass().getName().endsWith("CheckBox")) {
                result = result.concat(((CheckBox) o).printXML());
            }
            else if (o.getClass().getName().endsWith("VstupnySubor")) {
                result = result.concat(((VstupnySubor) o).printXML());
            }
            else if (o.getClass().getName().endsWith("VystupnySubor")) {
                result = result.concat(((VystupnySubor) o).printXML());
            }
            else if (o.getClass().getName().endsWith("String")) {
                result = result.concat(((String) o));
            }
        }
        return result;
    }
 
    public String printFormattedXML(String tab) {
        String result = new String("");
        for (Iterator i = this.prikazy.iterator(); i.hasNext();) {
            Object o = i.next();
            if (o.getClass().getName().endsWith("InputBox")) {
                result = result.concat(((InputBox) o).printFormattedXML(tab));
            }
            else if (o.getClass().getName().endsWith("SelectBox")) {
                result = result.concat(((SelectBox) o).printFormattedXML(tab));
            }
            else if (o.getClass().getName().endsWith("CheckBox")) {
                result = result.concat(((CheckBox) o).printFormattedXML(tab));
            }
            else if (o.getClass().getName().endsWith("VstupnySubor")) {
                result = result.concat(((VstupnySubor) o).printFormattedXML(tab));
            }
            else if (o.getClass().getName().endsWith("VystupnySubor")) {
                result = result.concat(((VystupnySubor) o).printFormattedXML(tab));
            }
            else if (o.getClass().getName().endsWith("String")) {
                result = result.concat(tab+((String) o)).concat(System.getProperty("line.separator"));
            }
        }
        return result;
    }

    public void paintEditorialPanel(SettingsPanel addedPanel,final JFrame aThis, String cislovanie) {
        
        final JButton addNodeButton = new javax.swing.JButton();;
        final JPopupMenu popup = new JPopupMenu();
        
             class PopupListener extends MouseAdapter {
                public void mousePressed(MouseEvent e) {
                    maybeShowPopup(e);
                }

                public void mouseReleased(MouseEvent e) {
                    maybeShowPopup(e);
                }

                private void maybeShowPopup(MouseEvent e) {
                    popup.show(e.getComponent(),e.getX(), e.getY());
                }
            }            

         final Predpis helpReference = this;

        JMenuItem menuItem = new JMenuItem("Text");
        menuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            addTextFrame atf = new addTextFrame(helpReference);
            atf.setLocationRelativeTo(addNodeButton);
            atf.setParentFrame(aThis);
        }
        });
        popup.add(menuItem);

        menuItem = new JMenuItem("Input Box");
        menuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            addInputBoxFrame atf = new addInputBoxFrame(helpReference);
            atf.setLocationRelativeTo(addNodeButton);
            atf.setParentFrame(aThis);
        }
        });
        popup.add(menuItem);

        menuItem = new JMenuItem("Check Box");
        menuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            addCheckBoxFrame atf = new addCheckBoxFrame(helpReference);
            atf.setLocationRelativeTo(addNodeButton);
            atf.setParentFrame(aThis);
        }
        });
        popup.add(menuItem);

        menuItem = new JMenuItem("Select Box");
        menuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            addSelectBoxFrame atf = new addSelectBoxFrame(helpReference);
            atf.setLocationRelativeTo(addNodeButton);
            atf.setParentFrame(aThis);
        }
        });
        popup.add(menuItem);

        menuItem = new JMenuItem("Vstup");
        menuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            addVstupFrame atf = new addVstupFrame(helpReference);
            atf.setLocationRelativeTo(addNodeButton);
            atf.setParentFrame(aThis);
        }
        });
        popup.add(menuItem);

        menuItem = new JMenuItem("Výstup");
        menuItem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            addVystupFrame atf = new addVystupFrame(helpReference);
            atf.setLocationRelativeTo(addNodeButton);
            atf.setParentFrame(aThis);
        }
        });
        popup.add(menuItem);

        MouseListener popupListener = new PopupListener();
        
       
        
        if (cislovanie.compareTo("") != 0) {
            cislovanie = cislovanie.concat(".");
        }
        final AdministraciaFrame aFrame = (AdministraciaFrame) aThis;
        JPanel addedPanel2;
        JPanel addedPanel3;
        
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.fill = GridBagConstraints.NONE;
        gbc2.anchor = GridBagConstraints.LINE_START;       
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        
        GridBagConstraints gbc3 = new GridBagConstraints();
        gbc3.fill = GridBagConstraints.NONE;
        gbc3.anchor = GridBagConstraints.LINE_START;       
        gbc3.gridx = 0;
        gbc3.gridy = 1;
        
        
        String hore = new String("Hore");
        String dole = new String("Dole");
        String zrusit = new String("Zrušiť");
        
        addedPanel.setLayout(new java.awt.GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = GridBagConstraints.BOTH;
        gbc.anchor = GridBagConstraints.LINE_START;
        gbc.gridx = 0;
        gbc.gridy = 0;
        
        Insets nadpisIns = new Insets(15, 5, 0, 0);
        Insets smallIns = new Insets(5, 5, 0, 0);
        Insets atributIns = new Insets(5, 10, 0, 0);
        Insets panelIns = new Insets(5, 30, 0, 0);
        Insets optionsIns = new Insets(5, 20, 0, 0);
        Insets noIns = new Insets(0, 0, 0, 0);
        
        int counter = 1;
        
        addNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
        addNodeButton.setText("Pridať uzol");                
        addNodeButton.setEnabled(true);
        
        addNodeButton.addMouseListener(popupListener);
        
        gbc.fill = GridBagConstraints.NONE;
        addedPanel.add(addNodeButton, gbc);
        addNodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {

            }
        });
        gbc.gridy++;
        gbc.fill = GridBagConstraints.BOTH;
        
        
        for (Iterator i = this.prikazy.iterator(); i.hasNext(); counter++) {
            Object o = i.next();
            final int nodeId = counter-1;
            /*
             TEXTOVY UZOL
            */
            addedPanel2 = new JPanel();
            addedPanel2.setLayout(new java.awt.GridBagLayout());

            addedPanel3 = new JPanel();
            addedPanel3.setLayout(new java.awt.GridBagLayout());
                
            if (o.getClass().getName().endsWith("String")) {
                final String node = (String) o;
                
                JLabel textLabel = new JLabel(cislovanie+(new Integer(counter)).toString()+". Text");
                gbc2.insets = nadpisIns;
                gbc2.gridx = 0;
                addedPanel2.add(textLabel, gbc2);
                
                JButton moveNodeUpButton = new javax.swing.JButton();
                moveNodeUpButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeUpButton.setText(hore);
                if (counter > 1) {
                    moveNodeUpButton.setEnabled(true);
                }
                else {
                    moveNodeUpButton.setEnabled(false);
                }
                gbc2.gridx = 1;
                addedPanel2.add(moveNodeUpButton, gbc2);
                moveNodeUpButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolHore(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton moveNodeDownButton = new javax.swing.JButton();
                moveNodeDownButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeDownButton.setText(dole);
                if (counter < prikazy.size()) {
                    moveNodeDownButton.setEnabled(true);
                }
                else {
                    moveNodeDownButton.setEnabled(false);
                }
                gbc2.gridx = 2;
                addedPanel2.add(moveNodeDownButton, gbc2);
                moveNodeDownButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolDole(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton cancelNodeButton = new javax.swing.JButton();
                cancelNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                cancelNodeButton.setText(zrusit);                
                cancelNodeButton.setEnabled(true);
                gbc2.gridx = 3;
                addedPanel2.add(cancelNodeButton, gbc2);
                cancelNodeButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        odstranUzol(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                gbc2.gridx = 0;
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel2, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
                
                JLabel hodnotaLabel = new JLabel("Hodnota:");
                gbc3.insets = atributIns;
                addedPanel3.add(hodnotaLabel, gbc3);
                
                final JTextArea hodnotaArea = new JTextArea();
                hodnotaArea.setLineWrap(true);
                hodnotaArea.setWrapStyleWord(true);
                hodnotaArea.setRows(1);
                hodnotaArea.setColumns(20);
                hodnotaArea.setText(node);
               
                hodnotaArea.addKeyListener(new java.awt.event.KeyAdapter() {
                   public void keyReleased(java.awt.event.KeyEvent evt) {
                       prikazy.remove(nodeId);
                       prikazy.add(nodeId, hodnotaArea.getText());
                       aFrame.refreshPredpisArea();
                       aFrame.refreshPrikazPanel();
                       hodnotaArea.grabFocus();
                   }
                }); 
                
                JScrollPane hodnotaAreaScrollPane = new JScrollPane(hodnotaArea);
                hodnotaAreaScrollPane.setVerticalScrollBarPolicy(
                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
                gbc3.gridx = 1;
                gbc3.insets = smallIns;
                addedPanel3.add(hodnotaAreaScrollPane, gbc3);
                gbc3.gridx = 0;
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel3, gbc);
                gbc.fill = GridBagConstraints.BOTH;                
                
            }
            
            else if (o.getClass().getName().endsWith("VstupnySubor")) {
                final VstupnySubor node = (VstupnySubor) o;
                
                addedPanel2 = new JPanel();
                addedPanel2.setLayout(new java.awt.GridBagLayout());
                
                JLabel textLabel = new JLabel(cislovanie+counter+". Vstupný súbor");
                gbc2.insets = nadpisIns;
                gbc2.gridx = 0;
                addedPanel2.add(textLabel, gbc2);
                
                JButton moveNodeUpButton = new javax.swing.JButton();
                moveNodeUpButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeUpButton.setText(hore);
                if (counter > 1) {
                    moveNodeUpButton.setEnabled(true);
                }
                else {
                    moveNodeUpButton.setEnabled(false);
                }
                gbc2.gridx = 1;
                addedPanel2.add(moveNodeUpButton, gbc2);
                moveNodeUpButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolHore(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton moveNodeDownButton = new javax.swing.JButton();
                moveNodeDownButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeDownButton.setText(dole);
                if (counter < prikazy.size()) {
                    moveNodeDownButton.setEnabled(true);
                }
                else {
                    moveNodeDownButton.setEnabled(false);
                }
                gbc2.gridx = 2;
                addedPanel2.add(moveNodeDownButton, gbc2);
                moveNodeDownButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolDole(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton cancelNodeButton = new javax.swing.JButton();
                cancelNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                cancelNodeButton.setText(zrusit);                
                cancelNodeButton.setEnabled(true);
                gbc2.gridx = 3;
                addedPanel2.add(cancelNodeButton, gbc2);
                cancelNodeButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        odstranUzol(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                gbc2.gridx = 0;
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel2, gbc);
                gbc.fill = GridBagConstraints.BOTH;
            }
            
            else if (o.getClass().getName().endsWith("VystupnySubor")) {
                final VystupnySubor node = (VystupnySubor) o;
                
                addedPanel2 = new JPanel();
                addedPanel2.setLayout(new java.awt.GridBagLayout());
                
                JLabel textLabel = new JLabel(cislovanie+counter+". Výstupný súbor");
                gbc2.insets = nadpisIns;
                gbc2.gridx = 0;
                addedPanel2.add(textLabel, gbc2);
                
                JButton moveNodeUpButton = new javax.swing.JButton();
                moveNodeUpButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeUpButton.setText(hore);
                if (counter > 1) {
                    moveNodeUpButton.setEnabled(true);
                }
                else {
                    moveNodeUpButton.setEnabled(false);
                }
                gbc2.gridx = 1;
                addedPanel2.add(moveNodeUpButton, gbc2);
                moveNodeUpButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolHore(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton moveNodeDownButton = new javax.swing.JButton();
                moveNodeDownButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeDownButton.setText(dole);
                if (counter < prikazy.size()) {
                    moveNodeDownButton.setEnabled(true);
                }
                else {
                    moveNodeDownButton.setEnabled(false);
                }
                gbc2.gridx = 2;
                addedPanel2.add(moveNodeDownButton, gbc2);
                moveNodeDownButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolDole(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton cancelNodeButton = new javax.swing.JButton();
                cancelNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                cancelNodeButton.setText(zrusit);                
                cancelNodeButton.setEnabled(true);
                gbc2.gridx = 3;
                addedPanel2.add(cancelNodeButton, gbc2);
                cancelNodeButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        odstranUzol(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                gbc2.gridx = 0;
                
                                
                
                final JCheckBox pathCheckBox = new JCheckBox("Plná cesta");
                pathCheckBox.setSelected(node.wholePath);
                pathCheckBox.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        if (pathCheckBox.isSelected()) {
                            node.wholePath = true;
                        }
                        else {
                            node.wholePath = false;
                        }
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                    }
                });
                
                addedPanel3 = new JPanel();
                addedPanel3.setLayout(new java.awt.GridBagLayout());
                gbc3.insets = atributIns;
                addedPanel3.add(pathCheckBox, gbc3);
                
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel2, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel3, gbc);
                gbc.fill = GridBagConstraints.BOTH;
            }
            
            else if (o.getClass().getName().endsWith("InputBox")) {
                final InputBox node = (InputBox) o;
                
                addedPanel2 = new JPanel();
                addedPanel2.setLayout(new java.awt.GridBagLayout());
                
                JLabel textLabel = new JLabel(cislovanie+counter+". Input Box");
                gbc2.insets = nadpisIns;
                gbc2.gridx = 0;
                addedPanel2.add(textLabel, gbc2);
                
                JButton moveNodeUpButton = new javax.swing.JButton();
                moveNodeUpButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeUpButton.setText(hore);
                if (counter > 1) {
                    moveNodeUpButton.setEnabled(true);
                }
                else {
                    moveNodeUpButton.setEnabled(false);
                }
                gbc2.gridx = 1;
                addedPanel2.add(moveNodeUpButton, gbc2);
                moveNodeUpButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolHore(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton moveNodeDownButton = new javax.swing.JButton();
                moveNodeDownButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeDownButton.setText(dole);
                if (counter < prikazy.size()) {
                    moveNodeDownButton.setEnabled(true);
                }
                else {
                    moveNodeDownButton.setEnabled(false);
                }
                gbc2.gridx = 2;
                addedPanel2.add(moveNodeDownButton, gbc2);
                moveNodeDownButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolDole(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton cancelNodeButton = new javax.swing.JButton();
                cancelNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                cancelNodeButton.setText(zrusit);                
                cancelNodeButton.setEnabled(true);
                gbc2.gridx = 3;
                addedPanel2.add(cancelNodeButton, gbc2);
                cancelNodeButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        odstranUzol(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                gbc2.gridx = 0;
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel2, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
                
                
                JLabel inputBoxNameLabel = new JLabel("Názov:");
                gbc3.insets = atributIns;
                gbc3.gridy = 0;
                gbc3.gridx = 0;
                addedPanel3.add(inputBoxNameLabel, gbc3);
                
                final JTextArea nazovArea = new JTextArea();
                nazovArea.setLineWrap(true);
                nazovArea.setWrapStyleWord(true);
                nazovArea.setRows(1);
                nazovArea.setColumns(20);
                nazovArea.setText(node.getNazov());
                nazovArea.addKeyListener(new java.awt.event.KeyAdapter() {
                   public void keyReleased(java.awt.event.KeyEvent evt) {
                       ((InputBox) prikazy.get(nodeId)).nazov = nazovArea.getText();
                       aFrame.refreshPredpisArea(); 
                       aFrame.refreshPrikazPanel();
                       nazovArea.grabFocus();
                   }
                });
                
                JScrollPane nazovAreaScrollPane = new JScrollPane(nazovArea);
                nazovAreaScrollPane.setVerticalScrollBarPolicy(
                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
                gbc3.gridx = 1;
                gbc3.insets = smallIns;
                addedPanel3.add(nazovAreaScrollPane, gbc3);
                gbc3.gridx = 0;
                
                JLabel inputBoxDefValueLabel = new JLabel("Defaultná hodnota:");
                gbc3.gridy = 1;
                gbc3.insets = atributIns;
                addedPanel3.add(inputBoxDefValueLabel, gbc3);
                gbc3.gridy = 0;
                
                final JTextArea defValueArea = new JTextArea();
                defValueArea.setLineWrap(true);
                defValueArea.setWrapStyleWord(true);
                defValueArea.setRows(1);
                defValueArea.setColumns(20);
                defValueArea.setText(node.defaultValue);
                defValueArea.addKeyListener(new java.awt.event.KeyAdapter() {
                   public void keyReleased(java.awt.event.KeyEvent evt) {
                       ((InputBox) prikazy.get(nodeId)).defaultValue = defValueArea.getText();
                       aFrame.refreshPredpisArea();                       
                       defValueArea.grabFocus();
                   }
                });
                
                JScrollPane defValueAreaScrollPane = new JScrollPane(defValueArea);
                defValueAreaScrollPane.setVerticalScrollBarPolicy(
                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
                gbc3.gridx = 1;
                gbc3.gridy = 1;
                gbc3.insets = smallIns;
                addedPanel3.add(defValueAreaScrollPane, gbc3);
                gbc3.gridx = 0;
                gbc3.gridy = 0;
                
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel3, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
            }
            
            else if (o.getClass().getName().endsWith("CheckBox")) {
                final CheckBox node = (CheckBox) o;
                
                addedPanel2 = new JPanel();
                addedPanel2.setLayout(new java.awt.GridBagLayout());
                
                JLabel textLabel = new JLabel(cislovanie+counter+". Check Box");
                gbc2.insets = nadpisIns;
                gbc2.gridx = 0;
                addedPanel2.add(textLabel, gbc2);
                
                JButton moveNodeUpButton = new javax.swing.JButton();
                moveNodeUpButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeUpButton.setText(hore);
                if (counter > 1) {
                    moveNodeUpButton.setEnabled(true);
                }
                else {
                    moveNodeUpButton.setEnabled(false);
                }
                gbc2.gridx = 1;
                addedPanel2.add(moveNodeUpButton, gbc2);
                moveNodeUpButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolHore(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton moveNodeDownButton = new javax.swing.JButton();
                moveNodeDownButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeDownButton.setText(dole);
                if (counter < prikazy.size()) {
                    moveNodeDownButton.setEnabled(true);
                }
                else {
                    moveNodeDownButton.setEnabled(false);
                }
                gbc2.gridx = 2;
                addedPanel2.add(moveNodeDownButton, gbc2);
                moveNodeDownButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolDole(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton cancelNodeButton = new javax.swing.JButton();
                cancelNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                cancelNodeButton.setText(zrusit);                
                cancelNodeButton.setEnabled(true);
                gbc2.gridx = 3;
                addedPanel2.add(cancelNodeButton, gbc2);
                cancelNodeButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        odstranUzol(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                gbc2.gridx = 0;
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel2, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
                
                
                
                JLabel checkBoxNameLabel = new JLabel("Názov:");
                gbc3.gridx = 0;
                gbc3.gridy = 0;
                gbc3.insets = atributIns;
                addedPanel3.add(checkBoxNameLabel, gbc3);
                
                final JTextArea nazovArea = new JTextArea();
                nazovArea.setLineWrap(true);
                nazovArea.setWrapStyleWord(true);
                nazovArea.setRows(1);
                nazovArea.setColumns(20);
                nazovArea.setText(node.nazov);
                nazovArea.addKeyListener(new java.awt.event.KeyAdapter() {
                   public void keyReleased(java.awt.event.KeyEvent evt) {
                       ((CheckBox) prikazy.get(nodeId)).nazov = nazovArea.getText();
                       aFrame.refreshPredpisArea(); 
                       aFrame.refreshPrikazPanel();
                       nazovArea.grabFocus();
                   }
                });
                
                JScrollPane nazovAreaScrollPane = new JScrollPane(nazovArea);
                nazovAreaScrollPane.setVerticalScrollBarPolicy(
                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
                gbc3.gridx = 1;
                gbc3.gridy = 0;
                gbc3.insets = smallIns;
                addedPanel3.add(nazovAreaScrollPane, gbc3);
                gbc3.gridx = 0;
                
                
                
                JLabel checkedCheckBoxLabel = new JLabel("Defaultne vybrané:");
                gbc3.gridx = 0;
                gbc3.gridy = 1;
                gbc3.insets = atributIns;
                addedPanel3.add(checkedCheckBoxLabel, gbc3);
                
                final JCheckBox jCheckBox1 = new JCheckBox();
                jCheckBox1.setText("");
                jCheckBox1.setSelected(node.checked);
                gbc3.gridx = 1;
                gbc3.gridy = 1;
                gbc3.insets = smallIns;
                addedPanel3.add(jCheckBox1, gbc3);
                gbc3.gridx = 0;
                
                 jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        if (jCheckBox1.isSelected()) {
                            node.enable();
                        }
                        else {
                            node.disable();
                        }
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                    }
                });
                
                JLabel valueCheckBoxLabel = new JLabel("Poduzly:");
                gbc3.gridx = 0;
                gbc3.gridy = 2;
                gbc3.insets = atributIns;
                addedPanel3.add(valueCheckBoxLabel, gbc3);
                
                SettingsPanel newCheckBoxPanel = new SettingsPanel();
                newCheckBoxPanel.parent = addedPanel; 
                newCheckBoxPanel.setLayout(new java.awt.GridBagLayout());                
                gbc3.gridwidth = 500;
                gbc3.gridx = 0;
                gbc3.gridy = 3;
                gbc3.fill = GridBagConstraints.NONE;
                gbc3.insets = panelIns;
                node.hodnota.paintEditorialPanel(newCheckBoxPanel, aThis, cislovanie.concat(new Integer(counter).toString()));
                addedPanel3.add(newCheckBoxPanel, gbc3);
                gbc3.gridwidth = 1;
                gbc3.gridx = 0;
                gbc3.gridy = 0;
                
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel3, gbc);
                gbc.fill = GridBagConstraints.BOTH;
            }
            
            else if (o.getClass().getName().endsWith("SelectBox")) {
                SelectBox node = (SelectBox) o;
                
                addedPanel2 = new JPanel();
                addedPanel2.setLayout(new java.awt.GridBagLayout());
                
                JLabel textLabel = new JLabel(cislovanie+counter+". Select Box");
                gbc2.insets = nadpisIns;
                gbc2.gridx = 0;
                addedPanel2.add(textLabel, gbc2);
                
                JButton moveNodeUpButton = new javax.swing.JButton();
                moveNodeUpButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeUpButton.setText(hore);
                if (counter > 1) {
                    moveNodeUpButton.setEnabled(true);
                }
                else {
                    moveNodeUpButton.setEnabled(false);
                }
                gbc2.gridx = 1;
                addedPanel2.add(moveNodeUpButton, gbc2);
                moveNodeUpButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolHore(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton moveNodeDownButton = new javax.swing.JButton();
                moveNodeDownButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                moveNodeDownButton.setText(dole);
                if (counter < prikazy.size()) {
                    moveNodeDownButton.setEnabled(true);
                }
                else {
                    moveNodeDownButton.setEnabled(false);
                }
                gbc2.gridx = 2;
                addedPanel2.add(moveNodeDownButton, gbc2);
                moveNodeDownButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        posunUzolDole(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                
                
                JButton cancelNodeButton = new javax.swing.JButton();
                cancelNodeButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                cancelNodeButton.setText(zrusit);                
                cancelNodeButton.setEnabled(true);
                gbc2.gridx = 3;
                addedPanel2.add(cancelNodeButton, gbc2);
                cancelNodeButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        odstranUzol(nodeId);
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                        aFrame.refreshNodesPanel();
                    }
                });
                gbc2.gridx = 0;
                                                
                
                
                JButton addOptionButton = new javax.swing.JButton();
                addOptionButton.setFont(new java.awt.Font("DejaVu Sans", 0, 10));
                addOptionButton.setText("Pridať voľbu");                
                addOptionButton.setEnabled(true);
                gbc2.gridx = 4;
                addedPanel2.add(addOptionButton, gbc2);
                addOptionButton.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        String s = (String)JOptionPane.showInputDialog(
                            new JFrame(),
                            "Názov novej voľby:",
                            "Pridávanie voľby",
                            JOptionPane.PLAIN_MESSAGE,
                            null,
                            null,
                            "NováVoľba");
                        if (s != null) {
                            Option pridavana = new Option();
                            pridavana.setNazov(s);
                            ((SelectBox) prikazy.get(nodeId)).options.add(0, pridavana);
                            aFrame.refreshPredpisArea();
                            aFrame.refreshPrikazPanel();
                            aFrame.refreshNodesPanel();
                        }
                    }
                });
                gbc2.gridx = 0;
                
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel2, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
                
                
                JLabel selectBoxNameLabel = new JLabel("Názov:");
                gbc3.gridx = 0;
                gbc3.gridy = 0;
                gbc3.insets = atributIns;
                addedPanel3.add(selectBoxNameLabel, gbc3);
                
                final JTextArea nazovArea = new JTextArea();
                nazovArea.setLineWrap(true);
                nazovArea.setWrapStyleWord(true);
                nazovArea.setRows(1);
                nazovArea.setColumns(20);
                nazovArea.setText(node.nazov);
                nazovArea.addKeyListener(new java.awt.event.KeyAdapter() {
                   public void keyReleased(java.awt.event.KeyEvent evt) {
                       ((SelectBox) prikazy.get(nodeId)).nazov = nazovArea.getText();
                       aFrame.refreshPredpisArea();
                       aFrame.refreshPrikazPanel();
                       nazovArea.grabFocus();
                   }
                });
                
                JScrollPane nazovAreaScrollPane = new JScrollPane(nazovArea);
                nazovAreaScrollPane.setVerticalScrollBarPolicy(
                    JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
                gbc3.gridx = 1;
                gbc3.gridy = 0;
                gbc3.insets = smallIns;
                addedPanel3.add(nazovAreaScrollPane, gbc3);
                
                
                
                JLabel selectBoxDefOptionLabel = new JLabel("Defaultná možnosť:");
                gbc3.gridx = 0;
                gbc3.gridy = 1;
                gbc3.insets = atributIns;
                addedPanel3.add(selectBoxDefOptionLabel, gbc3);
                
                
                final JComboBox optionComboBox = new JComboBox();
                String[] options = node.getOptionsAsStringArray();
                if (options != null) {
                    int selIndex = 0;
                    if (node.defaultOption != null) {
                        for (int j = 0; j < options.length; j++) {
                            if (options[j].compareTo(node.defaultOption.nazov) == 0) {
                                selIndex = j;
                                break;
                            }
                        }
                    }
                    optionComboBox.setModel(new javax.swing.DefaultComboBoxModel(options));
                    optionComboBox.setEnabled(true);
                    optionComboBox.setSelectedIndex(selIndex);
                }
                else {
                    optionComboBox.setEnabled(false);
                }
                gbc3.insets = smallIns;
                gbc3.gridx = 1;
                gbc3.gridy = 1;
                addedPanel3.add(optionComboBox, gbc3);
                optionComboBox.addActionListener(new java.awt.event.ActionListener() {
                    public void actionPerformed(java.awt.event.ActionEvent evt) {
                        ((SelectBox) prikazy.get(nodeId)).setDefaultnaOption((String) optionComboBox.getSelectedItem());
                        aFrame.refreshPredpisArea();
                        aFrame.refreshPrikazPanel();
                    }
                });
                
                SettingsPanel newSelectBoxPanel = new SettingsPanel();
                newSelectBoxPanel.parent = addedPanel; 
                newSelectBoxPanel.setLayout(new java.awt.GridBagLayout());                
                gbc3.gridwidth = 500;
                gbc3.gridx = 0;
                gbc3.gridy = 3;
                gbc3.fill = GridBagConstraints.NONE;
                gbc3.insets = optionsIns;
               
                node.paintOptionsEditorialPanel(newSelectBoxPanel, aThis, cislovanie.concat(new Integer(counter).toString()), optionComboBox);
                addedPanel3.add(newSelectBoxPanel, gbc3);
                gbc3.gridwidth = 1;
                
                
                gbc.gridy++;
                gbc.insets = noIns;
                gbc.fill = GridBagConstraints.NONE;
                addedPanel.add(addedPanel3, gbc);
                gbc.fill = GridBagConstraints.BOTH;
                
            }
            
            
        }
    }
    
    
    public Object odstranUzol(int nodeId) {
        return this.prikazy.remove(nodeId);
    }
    
    public void posunUzolHore(int nodeId) {
        if ((nodeId > 0) && (nodeId < (this.prikazy.size()))) {
            Object moved = this.prikazy.remove(nodeId);
            this.prikazy.add(nodeId-1, moved);
        }
    }
    
    public void posunUzolDole(int nodeId) {
        if ((nodeId >= 0) && (nodeId < (this.prikazy.size()-1))) {
            Object moved = this.prikazy.remove(nodeId);
            this.prikazy.add(nodeId+1, moved);
        }
    }
    
    
    
}
