package bakalarka;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;


public class TransformacnaRetaz {
	
	public Format from;
	public Format to;
	public int dlzka;
	public ArrayList transformacie;
	public int id;
	public Okruh mojOkruh;
	
	
	public TransformacnaRetaz(JednoduchaTransformacia jt) {
		this.transformacie = new ArrayList();
		this.from = jt.from;
		this.to = jt.to;
		this.mojOkruh = from.mojOkruh;
		dlzka = 1;
		this.id = this.mojOkruh.getTransformacneRetazeCounter(); 
		this.transformacie.add(jt);
	}
	
	private TransformacnaRetaz(TransformacnaRetaz tr) {
		//konstruktor kopie tr lisiaci sa len o id od argumentu
		this.from = tr.from;
		this.to = tr.to;
		this.dlzka = tr.dlzka;
		this.mojOkruh = tr.mojOkruh;
		this.id = this.mojOkruh.getTransformacneRetazeCounter();
		this.transformacie = new ArrayList();
		for (Iterator i = tr.transformacie.iterator(); i.hasNext();) {
			this.transformacie.add(i.next()); 
		}
	}
	
	
	public boolean pridajTransformaciu(JednoduchaTransformacia jt) {
		boolean pridane = false;
		if (!this.mojOkruh.equals(jt.mojOkruh)) {
			return false;
		}
		if (jt.from.getMeno().compareTo( ((JednoduchaTransformacia) this.transformacie.get(this.transformacie.size()-1)).to.getMeno() ) != 0) {
			return false;
		}		
		pridane = this.transformacie.add(jt);
		if (pridane) {
			this.to = jt.to;
			dlzka++;
		}
		return pridane;
	}
	
	public boolean pridajTransformacnuRetaz(TransformacnaRetaz tr) {
		boolean pridane = false;
		if (!this.mojOkruh.equals(tr.mojOkruh)) {
			return false;
		}
		if (this.to.getMeno().compareTo(tr.from.getMeno()) != 0) {
			return false;
		}
		pridane = this.transformacie.addAll(tr.transformacie);
		if (pridane) {
			this.to = tr.to;
			dlzka += tr.dlzka;
		}
		return pridane;
	}
	
	public TransformacnaRetaz zretaz(JednoduchaTransformacia jt) {
		//vrati novu transformacnu retaz,ktora vznikne spojenim sucasnej transformacnej retaze s jednoduchou transformaciou v argumente
		TransformacnaRetaz kopia = new TransformacnaRetaz(this);
		kopia.pridajTransformaciu(jt);
		return kopia;
	}
	
	public TransformacnaRetaz zretaz(TransformacnaRetaz tr) {
		TransformacnaRetaz kopia = new TransformacnaRetaz(this);
		kopia.pridajTransformacnuRetaz(tr);
		return kopia;
	}
	
	public void vypis() {
		System.out.println("Transformacna retaz dlzky "+this.dlzka+" s id "+this.id+" z okruhu "+this.mojOkruh.getMeno()+": "+from.getMeno()+" -> "+to.getMeno());
		int counter = 1;
		for (Iterator i = this.transformacie.iterator(); i.hasNext();) {
			System.out.print("Krok "+counter+":");
			counter++;
			((JednoduchaTransformacia) i.next()).vypis();
		}
		System.out.println();
		System.out.println();
	}
	
	public boolean spolocnyFormat(TransformacnaRetaz tr) {
		if (this.dlzka == 0 || tr.dlzka == 0) {
			return false;
		}
		String[] formaty = new String[this.dlzka+tr.dlzka+1];
		int counter = 0;
                Iterator i;
                String lastTo = "";
		for (i = this.transformacie.iterator();i.hasNext();) {
                        JednoduchaTransformacia jt = ((JednoduchaTransformacia) i.next());
			formaty[counter] = jt.from.getMeno();
                        if (!i.hasNext()) {
                            lastTo = jt.to.getMeno();
                        }
			counter++;
		}
                formaty[counter] = lastTo;
                counter++;
		i = tr.transformacie.iterator();
		for (;i.hasNext();) {
			formaty[counter] = ((JednoduchaTransformacia) i.next()).to.getMeno();
			counter++;
		}
		Arrays.sort(formaty);
		for (int j = 0; j<(formaty.length-1);j++) {
			if (formaty[j].compareTo(formaty[j+1]) == 0) {
				return true;
			}
		} 
		return false;
	}
        
        public String vypisCesty() {
            String vysledok = "";
            for (Iterator i = this.transformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                vysledok = vysledok.concat(jt.from.getMeno()+"->"+jt.to.getMeno());
                if (i.hasNext()) {
                    vysledok = vysledok.concat(", ");
                }
            }
            return vysledok;
        }
        
        public boolean isConfigurable() {
            for (Iterator i = this.transformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                if (jt.isConfigurable()) {
                    return true;
                }
            }
            return false;
        }
        
        public void setVstup(VstupnySubor vstup) {
            for (Iterator i = this.transformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                jt.setVstup(vstup);
            }
        }
        
        public void setVystup(VystupnySubor vystup) {
            for (Iterator i = this.transformacie.iterator(); i.hasNext();) {
                JednoduchaTransformacia jt = (JednoduchaTransformacia) i.next();
                jt.setVystup(vystup);
            }
        }
	
}
