package bakalarka;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;


public class addSelectBoxFrame extends javax.swing.JFrame {
        
    public JFrame parentFrame = null;
    public JPanel mainPanel;
    public Predpis changedPredpis;
    public JTextField nazovTextField;
    public JComboBox poziciaComboBox;
    
    public addSelectBoxFrame(Predpis p) {
        this.changedPredpis = p;
        this.setVisible(true);
        initComponents();
        this.setAlwaysOnTop(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });
    }

   public void setParentFrame(JFrame jf) {
        this.parentFrame = jf;
        jf.setEnabled(false);
        this.setVisible(true);
    }   
    
    private void initComponents() {        
        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mainPanel = new JPanel(new java.awt.GridBagLayout());        
        
        this.setTitle("Pridávanie select boxu");
                
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.NONE;
        gbc.anchor = GridBagConstraints.LINE_START;
        Insets noIns = new Insets(0, 0, 0, 0);
        Insets labelIns = new Insets(0, 0, 15, 0);
        Insets fieldIns = new Insets(0, 25, 15, 0);
        Insets okIns = new Insets(10, 30, 10, 0);
        Insets cancelIns = new Insets(10, 30, 10, 0);
        
        nazovTextField = new JTextField("Nový Select Box");
        nazovTextField.setColumns(20);
                
        Integer[] pozicie = new Integer[changedPredpis.prikazy.size()+1];
        for (int i = 1; i <= (changedPredpis.prikazy.size()+1); i++) {
            pozicie[i-1] = new Integer(i);
        }
        poziciaComboBox = new JComboBox(pozicie);
        poziciaComboBox.setSelectedIndex(changedPredpis.prikazy.size());
        
        
        JPanel helpPanel = new JPanel(new GridBagLayout());
        gbc.insets = labelIns;
        helpPanel.add(new JLabel("Názov:"), gbc);
        
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = fieldIns;
        helpPanel.add(nazovTextField, gbc);
        
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = labelIns;
        helpPanel.add(new JLabel("Pozícia:"), gbc);
        
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = fieldIns;
        helpPanel.add(poziciaComboBox, gbc);
        
        
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 10;
        gbc.insets = noIns;
        mainPanel.add(helpPanel, gbc);
        
        
        JButton ok = new JButton("OK");
        ok.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = okIns;
        mainPanel.add(ok, gbc);
        
        JButton cancel = new JButton("Zrušiť");
        cancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.insets = cancelIns;
        mainPanel.add(cancel, gbc);
        
        
        getContentPane().add(mainPanel);
        pack();
    }
   
    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {
        SelectBox vkladanyUzol = new SelectBox();
        vkladanyUzol.setNazov(nazovTextField.getText());
        int pozicia = (Integer) poziciaComboBox.getSelectedItem() -1;
        changedPredpis.prikazy.add(pozicia, vkladanyUzol);
        ((AdministraciaFrame) parentFrame).refreshPredpisArea();
        ((AdministraciaFrame) parentFrame).refreshNodesPanel();
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {
        this.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(this, WindowEvent.WINDOW_CLOSING));
    }
    
    private void formWindowClosing(java.awt.event.WindowEvent evt) {
        this.parentFrame.setEnabled(true);
    }

}

