import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;


/**
 * @author Dana
 *
 */
public class PProgram extends JPanel{
	private static final long serialVersionUID = 1L;
	private JTextArea ta;
	private JScrollPane s;
	private JLabel nazov;
	private int selected;
	public void init(){
		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		ta = new JTextArea(50,50);
		s = new JScrollPane(ta);
		nazov=new JLabel("Program: ");
		add(nazov);
		add(s);
		setVisible(true);
		selected=-1;
	 }
	public void velkost(Dimension d){
		s.setPreferredSize(d);
		
	}
	public void setFile(File f){
		if (f.canRead()){
			try {
				ta.read(new FileReader(f), null);
				setNazov("Program: "+f.getName());
			} catch (FileNotFoundException e) {
			} catch (IOException e) {
			}
		}
	}
	
	public void getFile(File f){
		try {
			ta.write(new FileWriter(f));
		} catch (IOException e) {
		}
	}
	public void setEditable(boolean b){
		ta.setEditable(b);
		
	}
	public void odznac(){
		if (selected==-1)return;
		try {
			int zac = ta.getLineStartOffset(selected);
			int kon = ta.getLineEndOffset(selected);
			String riadok=ta.getText(zac,kon-zac);
			String novy=riadok.substring(4);
			ta.replaceRange(novy,zac,kon);
			selected=-1;
		} catch (BadLocationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	public void oznac(int line){
		if (selected>-1) odznac();	
		try {
				int zac = ta.getLineStartOffset(line);
				int kon = ta.getLineEndOffset(line);
				String riadok=ta.getText(zac,kon-zac);
				String novy=">   "+riadok;
				ta.replaceRange(novy,zac,kon);
				ta.setSelectionStart(zac);
				ta.setSelectionEnd(kon);
				selected=line;
			} catch (BadLocationException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
	
	}
	public void print(){
		try {
			String[]nazov=new String[1];
			nazov[0]=this.nazov.getText().substring(9);
			String[][] C=new String[ta.getLineCount()][1];
			for (int i=0;i<ta.getLineCount(); i++){
				int zac=ta.getLineStartOffset(i);
				int kon=ta.getLineEndOffset(i);
				String s=ta.getText(zac, kon-zac);
				if (s.length()>1){
					C[i][0]=s.split("\n")[0];
				}
			}
			JTable tab=new JTable(new DefaultTableModel(C,nazov));
			s = new JScrollPane( tab);
			JOptionPane.showMessageDialog(this, s,"Print program",JOptionPane.PLAIN_MESSAGE)
;			if (!tab.print()) {
		    }
		} catch (java.awt.print.PrinterException e) {
			JOptionPane.showMessageDialog(this,"Cannot print %s%n"+ e.getMessage());
		} catch (BadLocationException e) {
				
		} 

	}
	public void setNazov(String s){
		nazov.setText(s);
	}
	
}
