import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import programy.Pram;

/**
 * @author Dana
 *
 */
public class PStep extends JFrame implements ActionListener{
	
	private static final long serialVersionUID = 1L;
	PProgram fProg;
	PPamat fPamet;
	POptions2 fOpt;
	PInstrukcie fInstr;
	PColumns fStlpce;
	JTabbedPane tabbedPane;
	int cProcesor;
	Pram prog;
	GUI g;
	
	public PStep(File file,Pram prog,GUI g){
		setTitle("Prostredie pre experimentovanie s PRAMami");
		this.prog = prog;
		this.g = g;
		this.setSize(new Dimension(700,500));
		//this.setLayout(null);
		JPanel hlavny=new JPanel();
		hlavny.setLayout(new BoxLayout(hlavny, BoxLayout.Y_AXIS));
		
		JPanel p = new JPanel();
		p.setLayout(new BoxLayout(p, BoxLayout.X_AXIS));
		//Editor na program, pamat, nastavenia 
		p.add(Box.createRigidArea(new Dimension(10,0)));
		fProg = new PProgram();
		fProg.init();
		fProg.setFile(file);
		fProg.setPreferredSize(new Dimension(300,200));
		fProg.setVisible(true);
		fProg.setEditable(false);
		p.add(fProg,"program");

		fOpt = new POptions2();
		fOpt.init(this);
		fOpt.setPreferredSize(new Dimension(300,200));
		fOpt.setSize(new Dimension(300,200));
		p.add(fOpt);
		p.add(Box.createRigidArea(new Dimension(10,0)));
		//p.setPreferredSize(new Dimension(300,400));
		//p.setSize(new Dimension(300,400));
		
		tabbedPane=new JTabbedPane();
		tabbedPane.setSize(200,600);
		fPamet = new PPamat();
		fPamet.init( "pamet",prog.getPocetProcesorov());
		fPamet.setEnabled(false);
		tabbedPane.addTab("Pamt",fPamet);
		fInstr = new PInstrukcie();
		fInstr.init( "Instrukcie",prog.getPocetProcesorov());
		fInstr.velkost(new Dimension(300,150));
		fInstr.setEnabled(false);
		tabbedPane.addTab("Intrukcie",fInstr);

		fStlpce = new PColumns(this,prog.getPocetProcesorov());
		tabbedPane.addTab("Tabuka stpcov", fStlpce);
		hlavny.add(p);
		hlavny.add(tabbedPane);
		
		add(hlavny);
		//this.setModal(true);
		//this.setResizable(false);
		
		fOpt.setVelkostPamete(prog.getVelkostPamete());
		fOpt.setVelkostVystupu(prog.getVelkostVystupu());
		fOpt.setPocetProcesorov(prog.getPocetProcesorov());
		fOpt.setMod(prog.getMod());
		g.setVisible(false);
		setVisible(true);
	}

	public void actionPerformed(ActionEvent e) {
		String command = e.getActionCommand();
		if (command.equals("Procesor")){
			cProcesor = fOpt.Procesor();
			if (cProcesor>=fOpt.getPocProcesorov()){
				cProcesor =fOpt.getPocProcesorov()-1; 
				fOpt.setProcesor(cProcesor);
			}
			update();
		} else if (command.equals("Step")){
			step();
		} else if (command.equals("Run")){
			setVisible(false);
			prog.Dokonci();
			try {
				g.hotovo(prog.getFVystup(),prog.getVelkostVystupu());
				g.setVisible(true);
				finalize();
			} catch (Throwable e1) {
			}
		} else if (command.equals("Stop")){
			prog.setKoniec();
			setVisible(false);
			try {
				g.setVisible(true);
				finalize();
			} catch (Throwable e1) {
			}
		}else if (command.equals("Print")){
			fPamet.print();
		}else if (command.equals("Step x")){
			xStep();
		}else if (command.equals("Aply")){
			fPamet.nastavenie(prog,fStlpce.getStlpce(),fStlpce.getPoznamky());
			tabbedPane.setSelectedIndex(0);
			
		}else if (command.equals("PocStlpcov")){
			fStlpce.zmenPocetStlpcov(fStlpce.getPocetStlpcov());
		} 
	}
	private void step(){
		if (!prog.Step()){
			try {
				setVisible(false);
				g.hotovo(prog.getFVystup(),prog.getVelkostVystupu());
				g.setVisible(true);
				finalize();
			} catch (Throwable e1) {
			}
		}else {
			update();
		}
	}
	private void xStep(){
		String cislo=JOptionPane.showInputDialog(this,"Poet", "Zadaj poet krokov, ktor maj by vykonan",JOptionPane.PLAIN_MESSAGE);
		if (cislo==null) return;
		int x=0;
		if (cislo.matches("[0-9]+")){
			x=Integer.decode(cislo).intValue();
		}
		for (int i=0; i<x;i++){
			step();
		}
	}
	
	private void update(){
		fPamet.setValues(prog);
		fOpt.setCInstr(prog.getInstrukcia(cProcesor));
		fOpt.setVelkostPamete(prog.getMaxPamat());
		fProg.oznac(prog.getInstrukcia(cProcesor));
		int max = prog.getPocetProcesorov();
		for (int i=0; i<max; i++){
			fInstr.setInstr(i,prog.getInstrukcia(i));
		}
	}
	protected void processWindowEvent(WindowEvent e){
		if (e.getID()==(WindowEvent.WINDOW_CLOSING)){
			g.setVisible(true);
			
		}
		super.processWindowEvent(e);
	}
	

}
