package programy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;

import javax.swing.JOptionPane;

import registre.ZdielaneRegistre;



/**
 * @author Dana
 */
public abstract class Pram {
	protected LinkedList procesor = new LinkedList();
	protected LinkedList program = new LinkedList();
	protected LinkedList ZoznamPoznamok = new LinkedList();
	protected File vstup, vystup;
	protected ZdielaneRegistre P;
	//protected int C[];
	//protected String CPozn[];
	protected int N;
	//protected int M;
	protected int velkostVystup;
	protected boolean stav=false;
	protected boolean padol = false;
	protected int padolProc, padolInstr;
	
	public  Pram(File p, File vstup, File vystup, int N, int vVystup, int M) throws IOException{
		File f=new File(p.getPath().substring(0,p.getPath().length()-4)+".prg"); 
		compile(p,f);
		citajProgram(f);
		this.N = N;
		this.vstup = vstup;
		this.vystup = vystup;
		//this.M = M;
		//C = new int[M];
		//CPozn = new String[M];
		velkostVystup = vVystup;
		for (int i=0; i<N; i++ ){
			procesor.add(i, new Ram(i,M));
		}
	}
	
	public abstract String getMod();
	
	private void citajProgram(File f) throws IOException{
		BufferedReader r = new BufferedReader(new FileReader(f));
		String l;
		String poz=null;
		int j=0;
		while ((l = r.readLine()) != null){
			int instr[]=new int[5];
			String[] s=l.split(" ");
			for(int i=0;i<Math.min(s.length,5);i++){
				if (s[i].matches("[0-9]+")){
					instr[i]=Integer.decode(s[i]).intValue();
				}
			}
			if (s.length>5){
				poz="";
				for (int i=5;i<s.length;i++){
					poz=poz+s[i];
				}
				ZoznamPoznamok.add(j,poz);
			}else{
				ZoznamPoznamok.add(j,"");
			}

			program.add(j,instr);
			j++;
		}
		r.close();
	}
	
	private static String preloz(String p, int riadok,LinkedList navestia, String[] chyby){
		if (p.length()==0) 
			return "0";
		int i=0;
		String chyba=null;
		if (p.charAt(0)=='<'){
			while (p.charAt(i+1)!='>'){
				i++;
			}
			i=i+2;
			while ((p.charAt(i)==' ')&((i+1)<=p.length())){
				i++;
			}
			if (p.length()==i-1){
				return "0";
			}
		}
		if (p.charAt(i)=='/'){
			return "0";
		}
		if ((p.length()<i+2)&(chyba==null)){ 
			chyba="Zla instrukcia";
			JOptionPane.showConfirmDialog(null,chyba+" na riadku "+riadok,"Error",JOptionPane.OK_OPTION,JOptionPane.ERROR_MESSAGE);
			return null;
		}	
		if (p.substring(i,i+2).equals("R[")){
			int ch1;
			int ch2;
			String pom;
			int ipom;
			i=i+2;
			if (p.substring(i,i+2).equals("R[")){
				ch1=2;
				pom="]]=";
				ipom=3;
				i=i+2;
			}else{
				ch1=0;
				pom="]=";
				ipom=2;
			}
			boolean b=true;
			char ch = p.charAt(i);
			while ((!Character.isDigit(ch))|((i+1)>p.length())){
				i++;
				ch= p.charAt(i);
			}
			int j=i;
			if (Character.isDigit(ch)){
				while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
					i++;			
					ch = p.charAt(i);
				}
				if (!b) i++;
				String c1 = p.substring(j,i);
				if (p.substring(i,i+ipom+2).equals(pom+"R[")){
					i=i+ipom+2;
					if (p.substring(i,i+2).equals("R[")){
						ch2=2;
						i=i+2;
					}else{
						ch2=0;
					}
				}else{
					if (p.substring(i,i+ipom+2).equals(pom+"C[")){
						i=i+ipom+2;
						if (p.substring(i,i+2).equals("R[")){
							ch2=3;
							i=i+2;
						}else{
							ch2=1;
						}
					}else{
						ch2=-1;
					}
				}
				b=true;
				ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c2 = p.substring(j,i);
					b=true;
					if (ch2>1){
						i++;
					}
					i++;
					String poz=null;
					if (i<p.length()){
						ch = p.charAt(i);
						while ((ch==' ')&((i+1)<p.length())){
							i++;
							ch= p.charAt(i);
						}
						j=i;
						if (ch=='{'){
							while ((ch!='}')&&((i+1)<p.length())){
								i++;
								ch= p.charAt(i);
							}
							if (ch!='}'){
								ch2=-1;
								chyba="Zly komentar";
							}else{
								poz=p.substring(j+1,i);
							}
						}
					}	
					if (ch2!=-1){
						return "11 "+ch1+" "+ch2+" "+c1+" "+c2+" "+poz;
					}else{
						if (chyba==null){
							chyba="Zla instrukcia";
						}
					}
				}else{
					chyba="Chybne cislo druheho registra";
				}
			}else{
				chyba="Chybne cislo prveho registra";
			}
			if (chyba==null){
				chyba="????????";
			}
		}
		if ((chyba==null)&&(p.substring(i,i+2).equals("C["))){
			int ch1;
			int ch2;
			String pom;
			int ipom;
			i=i+2;
			if (p.substring(i,i+2).equals("R[")){
				ch1=3;
				pom="]]=";
				ipom=3;
				i=i+2;
			}else{
				ch1=1;
				pom="]=";
				ipom=2;
			}
			boolean b=true;
			char ch = p.charAt(i);
			while ((!Character.isDigit(ch))|((i+1)>p.length())){
				i++;
				ch= p.charAt(i);
			}
			int j=i;
			if (Character.isDigit(ch)){
				while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
					i++;			
					ch = p.charAt(i);
				}
				if (!b) i++;
				String c1 = p.substring(j,i);
				if (p.substring(i,i+ipom+2).equals(pom+"R[")){
					i=i+ipom+2;
					if (p.substring(i,i+2).equals("R[")){
						ch2=2;
						i=i+2;
					}else{
						ch2=0;
					}
				}else{
						ch2=-1;
				}
				b=true;
				ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c2 = p.substring(j,i);
					if (ch2>1){
						i++;
					}
					i++;
					b=true;
					String poz=null;
					if (i<p.length()){
						ch = p.charAt(i);
						while ((ch==' ')&((i+1)<p.length())){
							i++;
							ch= p.charAt(i);
						}
						j=i;
						if (ch=='{'){
							while ((ch!='}')&&((i+1)<p.length())){
								i++;
								ch= p.charAt(i);
							}
							if (ch!='}'){
								ch2=-1;
								chyba="Zly komentar";
							}else{
								poz=p.substring(j+1,i);
							}
						}
					}
					if (ch2!=-1){
						return "11 "+ch1+" "+ch2+" "+c1+" "+c2+" "+poz;
					}else{
						chyba="Zla instrukcia";
					}
				}else{
					chyba="Chybne cislo druheho registra";
				}
			}else{
				chyba="Chybne cislo prveho registra";
			}
			if (chyba==null){
				chyba="????????";
			}
		}
		if (p.length()>=i+3){ 
			if (p.substring(i,i+3).equals("NOP")){
				return "0";
			}
		}	
		if (p.length()>=i+4){ 
			if (p.substring(i,i+4).equals("HALT")){
				return "1";
			}
			if (p.substring(i,i+4).equals("ADD ")){
				int  j= i+4;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "4 "+c;
				}else{
					chyba="Zla instrukcia";
				}
			}
			if (p.substring(i,i+4).equals("SUB ")){
				int  j= i+4;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "5 "+c;
				}else{
					chyba="Zla instrukcia";
				}
			}
			if (p.substring(i,i+4).equals("DIV ")){
				int  j= i+4;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "7 "+c;
				}else{
					chyba="Zla instrukcia";
				}
			}
		}
		if (p.length()>=i+5){ 
			if (p.substring(i,i+5).equals("MULT ")){
				int  j= i+5;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "6 "+c;
				}else{
					chyba="Zla instrukcia";
				}
			}
			if (p.substring(i,i+5).equals("GOTO ")){
				int  j= i+5;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((ch==' ')&&((i+1)<p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "8 "+c;
				}else{
					if (ch!='/'){
						while ((p.charAt(i)!=' ')&&((i+1)<p.length())){
							i++;
						}
						if (p.charAt(i)!=' '){
							i++;
						}
						String nav=p.substring(j,i);
						int c=navestia.indexOf(nav);
						if (c>-1){
							return "8 "+Integer.toString(c);
						}else{
							chyba="Zle navestie";
						}
					}else{
						chyba="Zla instrukcia";
					}
				}
			}
			if ((chyba==null)&&(p.substring(i,i+5).equals("IDENT"))){
				return "2";
			}
		}	
		if (p.length()>=i+6){ 
			if (p.substring(i,i+6).equals("CONST ")){
				int  j= i+6;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((!Character.isDigit(ch))|((i+1)>p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "3 "+c;
				}else{
					chyba="Zla instrukcia";
				}
			}
		}
		if (p.length()>=i+7){ 
			if (p.substring(i,i+7).equals("IFZERO ")){
				int  j= i+7;
				i=j;
				boolean b=true;
				char ch = p.charAt(i);
				while ((ch==' ')&&((i+1)<p.length())){
					i++;
					ch= p.charAt(i);
				}
				j=i;
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c = p.substring(j,i);
					return "9 "+c;
				}else{
					if (ch!='/'){
						while ((p.charAt(i)!=' ')&&((i+1)<p.length())){
							i++;
						}
						if (p.charAt(i)!=' '){
							i++;
						}
						String nav=p.substring(j,i);
						int c=navestia.indexOf(nav);
						if (c>-1){
							return "9 "+Integer.toString(c);
						}else{
							chyba="Zle navestie";
						}
					}else{
						chyba="Zla instrukcia";
					}
				}
			}
			if (p.substring(i,i+7).equals("ISLESS(")){
				i=i+7;
				int j=i;
				boolean b=true;
				char ch = p.charAt(i);
				if (Character.isDigit(ch)){
					while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
						i++;			
						ch = p.charAt(i);
					}
					if (!b) i++;
					String c1 = p.substring(j,i);
					if (p.charAt(i)==','){
						i++;
						j=i;
						ch=p.charAt(i);
						if (Character.isDigit(ch)){
							while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
								i++;			
								ch = p.charAt(i);
							}
							if (!b) i++;
							String c2 = p.substring(j,i);
							if (p.charAt(i)==')'){
								i++;
								b=true;
								ch = p.charAt(i);
								while ((ch==' ')&&((i+1)<p.length())){
									i++;
									ch= p.charAt(i);
								}
								j=i;
								if (Character.isDigit(ch)){
									while ((Character.isDigit(ch))&&(b=(p.length()>i+1))){
										i++;			
										ch = p.charAt(i);
									}
									if (!b) i++;
									String c3 = p.substring(j,i);
									return "10 "+c1+" "+c2+" "+c3;
								}else{
									if (ch!='/'){
										while ((p.charAt(i)!=' ')&&((i+1)<p.length())){
											i++;
										}
										if (p.charAt(i)!=' '){
											i++;
										}
										String nav=p.substring(j,i);
										int c=navestia.indexOf(nav);
										if (c>-1){
											return "10 "+c1+" "+c2+" "+Integer.toString(c);
										}else{
											chyba="Zle navestie";
										}
									}else{
										chyba="Chyba 3";
									}
								}
							}else{
								chyba="Koniec zatvorky";
							}
						}else{
							chyba="chyba pri citani 2.cislo";
						}	
					}else{
						chyba="chyba pri citani ciarky";
					}
				}else{
					chyba="chyba pri citani 1. cisla";
				}
				if (chyba==null){
					chyba="?????????";
				}
			}
		}
		if (chyba==null){
			chyba="Zla instrukcia";
		}
		chyby[chyby.length-1]=chyba+" '"+p+"'"+" na riadku "+riadok;
		return null;
	}
	private static LinkedList vytvorZoznamNavesti(File f1) throws IOException{
		LinkedList nav= new LinkedList();
		BufferedReader r = null;
		r = new BufferedReader(new FileReader(f1));
		String l;
		String p;
		int j=0;
		boolean b=true;
		while (((l = r.readLine()) != null)&(b)){
			p=l.trim().toUpperCase();
			if (p.length()==0){ 
				nav.add(j,null);
			}else{	
				int i=0;
				if (p.charAt(0)=='<'){
					while (p.charAt(i+1)!='>'){
						i++;
					}
					nav.add(j,p.substring(1,i+1));
				}else{
					nav.add(j,null);
				}
			}
			j++;
		}
		r.close();
		return nav;
	}
	
	public static void compile(File f1, File f2){
		try {
			LinkedList navestia=vytvorZoznamNavesti(f1);
			BufferedReader r = null;
			PrintWriter w = null;
			r = new BufferedReader(new FileReader(f1));
			w = new PrintWriter(new FileWriter(f2));
			String l;
			String p;
			String[] chyby=new String[1];
			int i=0;
			boolean b=true;
			while (((l = r.readLine()) != null)&(b)){
				p=preloz(l.trim().toUpperCase(),i,navestia,chyby);
				if (p==null){
					b=false;
				}
				w.println(p);
				i++;
			}
			r.close();
			w.close();
		} catch (IOException e) {
			JOptionPane.showConfirmDialog(null,"Zle zadany subor pre program, compilacia", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
	public static String[] compile(File f1){
		String[] chyby=new String[1];
		try {
			LinkedList navestia=vytvorZoznamNavesti(f1);
			BufferedReader r = null;
			r = new BufferedReader(new FileReader(f1));
			String l;
			String p;
			int i=0;
			boolean b=true;
			while (((l = r.readLine()) != null)&(b)){
				p=preloz(l.trim().toUpperCase(),i,navestia,chyby);
				if (p==null){
					String[] pom=chyby;
					chyby=new String[chyby.length+1];
					for (int j=0;j<pom.length;j++){
						chyby[j]=pom[j];
					}
				}
				i++;
			}
			r.close();
		} catch (IOException e) {
			JOptionPane.showConfirmDialog(null,"Zle zadany subor pre program, compilacia", "Error", JOptionPane.ERROR_MESSAGE);
		}
		return chyby;
	}
	
	public void setVystup(File vystup, int vVystup){
		this.vystup = vystup;
		velkostVystup = vVystup;
	}
	
	public void setProgram(File p){
		BufferedReader r = null;
			try {
				r = new BufferedReader(new FileReader(p));
				String l;
				int j=0;
				while ((l = r.readLine()) != null){
					program.add(j,l);
					j++;
				}
			} catch (IOException e) {
				JOptionPane.showConfirmDialog(null,"Zle zadany subor pre program", "Error", JOptionPane.ERROR_MESSAGE);
			}
			
		
	}
	public void setPocetProcesov(int poc){
		procesor.clear();	
		this.N = poc; 
		
		for (int i=0; i<N; i++ ){
			//procesor.add(i,new Ram(i,M));
			procesor.add(i,new Ram(i,P.getVelkost()));
		}

	}
	
	//abstract boolean krok();
	protected boolean krok(){
		boolean b = false;
		for (int i=0; i<N; i++){
			Ram r= (Ram) procesor.get(i);
			if (r.getStav()){
				int j =r.getCInstr(); 
				if ((j< program.size())&(j>=0)){
					r.Krok((int[]) program.get(r.getCInstr()),P,ZoznamPoznamok);
					if (r.padol()){
						padolProc=i;
						padolInstr=j;
						padol = true;
						b=false;
					} else {	
						b=true;
					}
				}else{
					int[] instr= new int[5];
					instr[0]=1;
					r.Krok((int[]) program.get(r.getCInstr()),P,ZoznamPoznamok);
					if (r.padol()){
						padolProc=i;
						padolInstr=j;
						padol = true;
						b=false;
					} else {	
						b=true;
					}
				}
				
			}
		}
		P.novyKrok();
		return b;
	}
	private boolean init() {
		int velkostVstup = 0;
		if (vstup != null) {
			BufferedReader r = null;
			try {
				r = new BufferedReader(new FileReader(vstup));
				String l;
				if ((l = r.readLine()) != null){
					if (l.matches("[0-9]+")){
						velkostVstup =(Integer.decode(l)).intValue();
					}else{
						JOptionPane.showMessageDialog(null,"Zle zadany vstupny subor", "Error", JOptionPane.ERROR_MESSAGE);
						return false;
					}
				}
				for (int i=1; (i<=velkostVstup)&(i<=P.getVelkost()); i++){
					if ((l = r.readLine()) != null){
						if (l.matches("[0-9]+")){
							//C[i]=(Integer.decode(l)).intValue();
							P.setR(i,(Integer.decode(l)).intValue());
						}else{
							JOptionPane.showMessageDialog(null,"Zle zadany vstupny subor", "Error", JOptionPane.ERROR_MESSAGE);
							return false;
						}
					}
					
				}
				r.close();
				//C[0]=velkostVstup;
				P.setR(0,velkostVstup);
			} catch (IOException e) {
				JOptionPane.showMessageDialog(null,"Zle zadany vstupny subor", "Error", JOptionPane.ERROR_MESSAGE);
				return false;
			}
		}
		P.novyKrok();
		for (int i = 0; i<N; i++ ){
			Ram p = (Ram) procesor.get(i);
			p.setStav(true);
			p.setPadol(false);
		}
		stav = true;
		padol = false;
		return true;
	}
	private void koniec() {
		
		if (velkostVystup>0){
			PrintWriter w = null;
			try {
				w = new PrintWriter(new FileWriter(vystup));
				for (int i=0; (i<velkostVystup)&(i<P.getVelkost()); i++){
					//w.println(C[i]);
					w.println(P.getR(i));
				}
				w.close();
			} catch (IOException e) {
				JOptionPane.showMessageDialog(null,"Zle zadany vystupny subor", "Error", JOptionPane.ERROR_MESSAGE);
			}
		}	
		stav = false;
	}
	public void Run() {

		if (!init()) return;
		while (krok());
		if (!padol)
			koniec();
	}
	
	public void Dokonci(){
		while (krok());
		
		if (!padol)
			koniec();
		else JOptionPane.showMessageDialog(null, "Zl intrukcia: procesor "+padolProc+" instrukcia "+padolInstr);

	}
	public boolean Step() {
		if (!stav) {
			if (!init()){
				padol=true;
				stav=false;
				return false;
			}
		}
		if (!krok()) {
			
			if (!padol){
				koniec();
			}else{
				JOptionPane.showMessageDialog(null, "Zl intrukcia: procesor "+padolProc+" instrukcia "+padolInstr);
			}
			return false;
		}else{
			if (!padol){
				return true;
			}else{
				JOptionPane.showMessageDialog(null, "Zl intrukcia: procesor "+padolProc+" instrukcia "+padolInstr);
				return false;
			}	
		}
	}
	public boolean padol(){
		return padol;
	}
	public boolean isRun(){
		return stav;
	}
	public int[] getC(){
		//return C;
		return P.getReg();
	}
	public String[] getPozn(){
		//return CPozn;
		return P.getPozn();
	}
	public int[] getR(int i){
		if (i<N){
			Ram p = (Ram) procesor.get(i);
			return p.getR();
		}
		return null;
	}
	public String[] getPozn(int i){
		if (i<N){
			Ram p = (Ram) procesor.get(i);
			return p.getPozn();
		}
		return null;
	}
	public boolean padol(int i){
		Ram p = (Ram) procesor.get(i);
		return p.padol();
	}
	public boolean isRun(int i){
		Ram p = (Ram) procesor.get(i);
		return p.getStav();
	}
	public int getInstrukcia(int i){
		Ram p = (Ram) procesor.get(i);
		return p.getCInstr();
		
	}
	public void setKoniec(){
		padol = true;
	}
	public int getVelkostPamete(){
		//return M;
		return P.getVelkost();
	}
	public int getPocetProcesorov(){
		return N;
	}
	public int getVelkostVystupu(){
		return velkostVystup;
	}
	public File getFVystup(){
		return vystup;
	}
	public int getMaxPamat(){
		//int max=M;
		int max=P.getVelkost();
		for (int i=0;i<N;i++){
			Ram p = (Ram) procesor.get(i);
			max=Math.max(max,p.getMaxPamat());
		}
		return max;
	
	}
}
