/*
  Toto je subor mdemonapl.h - hlavickovy subor pre staticku kniznicu libmdemonapl.a
   - je urcena aplikaciam vyuzivajucim program MDemon
*/

/*
  mdconnect
  - sluzi na pripojenie klientskej aplikacie k programu MDemon pocuvajuceho na ip_adress a ip_port. ip_adress aj ip_port su v textovom tvare.
  - priklad volania: mdconnect("127.0.0.1", "9765");
  - funkcia vracia file deskriptor pripojenia, alebo -1 kedy zapise chybu na stderr
*/
int mdconnect(char *ip_adress, char *ip_port);

/*
  mdauth
  - sluzi na autorizovanie klientskej aplikacie pomocou loginu(vlogin) a hesla uzivatela(vheslo) v textovych formach
  - vstupne argumenty su file deskriptor pripojeneho programu MDemon , vlogin a vheslo
  - funkcia vracia 0 v pripade uspesnej autorizacie, inak 1 kedy zapise chybu na stderr
*/
int mdauth(int fd, char *vlogin, char *vheslo);

/*
  mdconnect_and_auth
  - sluzi na pripojenie sa a autorizovanie zaroven
  - informacie o tom, kam sa ma pripojit cerpa z /usr/local/etc/mdemonadr.conf
  - informacie o uzivatelovi(login, heslo) cerpa z /usr/local/etc/mdemonusr.conf
  - funkcia vracia file deskriptor pripojenia, alebo -1 kedy zapise chybu na stderr
*/
int mdconnect_and_auth();

/*
  mdresume
  - sluzi na pripojenie programu MDemon k mobilu. Jeho beh moze trvat aj niekolko sekund. 
  - moze volat len autorizovany klient - neatorizovany klient skonci vzdy s chybou
  - vstupny argument tvori file deskriptor pripojeneho programu MDemon
  - v pripadeu uspechu vrti 0, v pripade neuspechu 1 kedy zapise chybu na stderr
  - mdresume moze neuspiet ak k programu Mdemon je pripojeny klient, ktory ho odpojil od mobilu alebo nastala ina chyba(stratilo sa spojenie,...) 
*/
int mdresume(int fd);

/*
  mdsuspend
  - sluzi na odpojenie programu MDemon od mobilu. 
  - moze volat len autorizovany klient - neatorizovany klient skonci vzdy s chybou
  - vstupny argument tvori file deskriptor pripojeneho programu MDemon
  - v pripadeu uspechu vrti 0, v pripade neuspechu 1 kedy zapise chybu na stderr 
  - mdsuspend moze neuspiet ak k programu Mdemon je pripojeny klient, ktory ho odpojil od mobilu alebo nastala ina chyba(stratilo sa spojenie,...) 
*/
int mdsuspend(int fd);

/*
  mdclose
  - sluzi na ukoncenie programu MDemon. 
  - moze volat len autorizovany klient - neatorizovany klient skonci vzdy s chybou
  - vstupny argument tvori file deskriptor pripojeneho programu MDemon
  - v pripadeu uspechu vrti 0, v pripade neuspechu 1 kedy zapise chybu na stderr 
*/
int mdclose(int fd);

/*
  mdsend_sms
  - sluzi na odoslanie sms pomocou programu MDemon.
  - vstupne argumenty tvoria file deskriptor pripojeneho programu MDemon, tel kam sa ma sms odoslat a text sms.
  - moze volat len autorizovany klient - neatorizovany klient skonci vzdy s chybou
  - tel nesmie mat viac ako 19 znakov, text nesmie mat viac ako 160 znakov vzhladom k prekonvertovaniu ascii znakov na vstupe na gsm7 abecedu - kedy nezmie po prekonvertovani mat viac ako 160 znakov
    Text nesmie obsahovat znaky konca riadku a <ctrl-z> - sposobilo by to chybne odoslanie sms
  - text moze aj prazdny aj NULL
  - v pripadeu uspechu vrti 0, v pripade neuspechu 1 kedy zapise chybu na stderr 
*/
int mdsend_sms(int fd, char *tel, char *text);

/*
  mdsend_command_and_get_response
  - sluzi na priame odoslanie jedneho prikazu programu MDemon.
  - vstupne argumenty tvoria file deskriptor pripojeneho programu MDemon, prikaz ktory sa ma poslat(command) a miesto kam sa ma zapisat sprava od MDemon
  - priklad volania: mdsend_command_and_get_response(fd, "SUSPEND/n", &response)
    fd je typu int a response *char
  - v pripadeu uspechu vrti 0, v pripade neuspechu -1 kedy zapise chybu na stderr 
*/
int mdsend_command_and_get_response(int fd_server_socket, char *command, char **response);

/*
  mdsend_command_and_get_nresponses
  - sluzi na priame odoslanie jedneho a viac prikazov programu MDemon a na ziskanie 0 az n odpovedi, ktore sa vsetky za sebou ulozia do response.
  - vstupne argumenty tvoria file deskriptor pripojeneho programu MDemon, prikazy ktore sa maju poslat(command) napisane za sebou, miesto kam sa ma zapisat 
    sprava od MDemon a pocet ocakavanych odpovedi.
    Pri zadani vyssieho poctu odpovedi ako MDemon posle, moze program ostat stat a cakat na odpovede !
    Takyto pripad moze nastat pri zluceni viacerych prikazov bez toho aby bol klient autorizovany. Ak klient nie je autorizovany, skonci vybavovanie prikazov uz pri prvom prikaze, 
     takze dalsie prikazy nebudu spracovavane a MDemon nebude na ne posielat odpovede
  - odporucane pouzivat len programatorom, ktori naozaj vedia co robia !   
    V pripade, ze sa stratilo medzi aplikaciou a programom spojenie, funkcia vrati chybu a skonci normalne s -1.
  - v pripadeu uspechu vrati 0, v pripade neuspechu -1 kedy zapise chybu na stderr 
*/
int mdsend_command_and_get_nresponses(int fd_server_socket, char *command, char **response, int number);
