/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java;

import jadean.dean.Project;
import jadean.dean.Resource;
import jadean.dean.java.JavaPackage;
import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.jarparser.DefaultJarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.DefaultJarEntryFormatter;
import jadean.dean.java.resourceparser.jarparser.JarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.JarEntryFormatter;
import jadean.dean.java.resourceparser.jarparser.JarResourceUtilities;
import jadean.dean.java.resourceparser.javaparser.visitors.HasMainMethodVisitor;
import jadean.dean.java.resources.JavaResourceContext;
import jadean.dean.java.resources.JavaResourceContextFactory;
import jadean.dean.java.resources.JavaResourceFactory;
import jadean.dean.java.resources.JavaResourceProjectClass;
import jadean.dean.java.resources.JavaResourceProjectResource;
import jadean.dean.java.utilities.FileUtilities;
import jadean.dean.java.utilities.JavaUtilities;
import jadean.dean.java.utilities.ProjectUtilities;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProject
extends Project {
    private List<String> _sourceFolders;
    private String _outputFolder;
    private List<JavaPackage> _referencedPackages;
    private HashMap<JavaPackage, List<String>> _classesInReferencedPackages;
    private HashSet<JavaResource> _visited;
    private boolean _reflectionUsed;

    public JavaProject(String projectName, String[] sourceFolders, String outputFolder, String[] referencedPackages) {
        super(projectName);
        this._sourceFolders = Arrays.asList(sourceFolders);
        this._outputFolder = outputFolder;
        this._referencedPackages = new ArrayList<JavaPackage>();
        int i = 0;
        while (i < referencedPackages.length) {
            JavaPackage jPackage = new JavaPackage(referencedPackages[i]);
            this._referencedPackages.add(jPackage);
            if (jPackage.hasClassPathPackages()) {
                this._referencedPackages.addAll(jPackage.getClassPathPackages());
            }
            ++i;
        }
        this.initClassesInReferencedPackages();
        this._reflectionUsed = false;
    }

    public List<String> getSourceFolders() {
        return this._sourceFolders;
    }

    public String getOutputFolder() {
        return this._outputFolder;
    }

    public List<JavaPackage> getReferencedPackages() {
        return this._referencedPackages;
    }

    public HashMap<JavaPackage, List<String>> getClassesInReferencedLibraries() {
        return this._classesInReferencedPackages;
    }

    private void initClassesInReferencedPackages() {
        this._classesInReferencedPackages = null;
        try {
            this._classesInReferencedPackages = JarResourceUtilities.listFiles(this._referencedPackages, (JarEntryFilter)new DefaultJarEntryFilter(), (JarEntryFormatter)new DefaultJarEntryFormatter());
        }
        catch (IOException iOException) {
            this._classesInReferencedPackages = new HashMap();
        }
    }

    public boolean isContainedInReferencedPackages(String className) {
        for (JavaPackage referencedPackage : this._classesInReferencedPackages.keySet()) {
            for (String referencedClassName : this._classesInReferencedPackages.get(referencedPackage)) {
                if (!referencedClassName.equals(className)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isContainedInProjectFolders(String className) {
        String innerClassName;
        String fullClassFileName = className.replace('.', File.separatorChar);
        int atomicClassNamePosition = fullClassFileName.lastIndexOf(File.separatorChar);
        String classFilePath = atomicClassNamePosition == -1 ? "" : fullClassFileName.substring(0, atomicClassNamePosition + 1);
        String classFileName = atomicClassNamePosition == -1 ? fullClassFileName : fullClassFileName.substring(atomicClassNamePosition + 1);
        for (String sourceFolder : this._sourceFolders) {
            File javaSourceFile = new File(String.valueOf(sourceFolder) + File.separatorChar + fullClassFileName + ".java");
            if (!javaSourceFile.exists()) continue;
            return true;
        }
        File javaClassFile = new File(String.valueOf(this._outputFolder) + File.separatorChar + fullClassFileName + ".class");
        if (javaClassFile.exists()) {
            return true;
        }
        String innerClassFileName = String.valueOf(this._outputFolder) + File.separatorChar + classFilePath + "$" + classFileName + ".class";
        String innerClassDirectory = innerClassFileName.substring(0, innerClassFileName.lastIndexOf(File.separatorChar) + 1);
        return FileUtilities.innerClassInDir(innerClassDirectory, innerClassName = innerClassFileName.substring(innerClassFileName.lastIndexOf(File.separatorChar) + 1));
    }

    public int getResourceType(String className, JavaResourceContext context) {
        if (className.endsWith(".*")) {
            return this.returnPackageType(className, context);
        }
        int type = this.returnProjectClassType(className, context);
        if (type != -1) {
            return type;
        }
        return this.returnReferencedClassType(className, context);
    }

    private int returnReferencedClassType(String className, JavaResourceContext context) {
        if (JavaUtilities.isAtomicClassName(className)) {
            for (String importedPackage : context.getClassImportedPackages()) {
                if (!this.isContainedInReferencedPackages(JavaUtilities.buildFullyQualifiedClassName(importedPackage, className))) continue;
                return 4;
            }
            for (String importedClass : context.getClassImportedClasses()) {
                if (!JavaUtilities.extractClassName(importedClass).equals(className) || !this.isContainedInReferencedPackages(importedClass)) continue;
                return 4;
            }
        } else if (this.isContainedInReferencedPackages(className)) {
            return 4;
        }
        return 6;
    }

    private int returnProjectClassType(String className, JavaResourceContext context) {
        if (JavaUtilities.isAtomicClassName(className)) {
            if (this.isContainedInProjectFolders(className)) {
                return 0;
            }
            for (String importedPackage : context.getClassImportedPackages()) {
                if (!this.isContainedInProjectFolders(JavaUtilities.buildFullyQualifiedClassName(importedPackage, className))) continue;
                return 0;
            }
            for (String importedClass : context.getClassImportedClasses()) {
                if (!JavaUtilities.extractClassName(importedClass).equals(className) || !this.isContainedInProjectFolders(importedClass)) continue;
                return 0;
            }
        } else if (this.isContainedInProjectFolders(className)) {
            return 0;
        }
        return -1;
    }

    private int returnPackageType(String className, JavaResourceContext context) {
        String res = className.replace(".*", "");
        for (String sourceFolder : this._sourceFolders) {
            File f1 = new File(String.valueOf(sourceFolder) + File.separatorChar + res.replace('.', File.separatorChar));
            if (!f1.exists()) continue;
            return 2;
        }
        File f2 = new File(String.valueOf(this._outputFolder) + File.separatorChar + res.replace('.', File.separatorChar));
        if (f2.exists()) {
            return 2;
        }
        for (JavaPackage key : this._classesInReferencedPackages.keySet()) {
            for (String value : this._classesInReferencedPackages.get(key)) {
                if (!value.startsWith(res)) continue;
                return 3;
            }
        }
        return 5;
    }

    public JavaPackage getPackageForResource(JavaResource resource) {
        if (resource instanceof JavaResourceProjectResource) {
            return ((JavaResourceProjectResource)resource).getPackageForResource();
        }
        return null;
    }

    private void buildDependencyGraph(DefaultDirectedGraph<Resource, DefaultEdge> g, JavaResource resource) {
        if (this._visited.contains(resource)) {
            return;
        }
        Collection<Resource> resources = resource.getReferrencedResources();
        g.addVertex((Object)resource);
        this._visited.add(resource);
        for (Resource _r : resources) {
            JavaResource r = (JavaResource)_r;
            if (resource.equals(r)) continue;
            g.addVertex((Object)r);
            g.addEdge((Object)resource, (Object)r);
            this.buildDependencyGraph(g, r);
        }
    }

    @Override
    public Graph<Resource, DefaultEdge> getDependencyGraph(String entryPoint) {
        JavaResourceProjectClass javaResourceEntryPoint = new JavaResourceProjectClass(entryPoint, JavaResourceContextFactory.getResourceContext(this, entryPoint), this);
        DefaultDirectedGraph ret = new DefaultDirectedGraph(DefaultEdge.class);
        this._visited = new HashSet();
        this.buildDependencyGraph((DefaultDirectedGraph<Resource, DefaultEdge>)ret, javaResourceEntryPoint);
        return ret;
    }

    @Override
    public Collection<Resource> getUsedResources(String entryPoint) {
        JavaResourceProjectClass javaResourceEntryPoint = new JavaResourceProjectClass(entryPoint, JavaResourceContextFactory.getResourceContext(this, entryPoint), this);
        DefaultDirectedGraph ret = new DefaultDirectedGraph(DefaultEdge.class);
        this._visited = new HashSet();
        this.buildDependencyGraph((DefaultDirectedGraph<Resource, DefaultEdge>)ret, javaResourceEntryPoint);
        return ProjectUtilities.removeResourcesFromPackage(ret.vertexSet());
    }

    @Override
    public Collection<Resource> getAllResources() {
        HashSet<Resource> ret = new HashSet<Resource>();
        JavaResourceFactory rf = new JavaResourceFactory(this);
        for (JavaPackage referencedPackage : this._referencedPackages) {
            try {
                List<String> resources = referencedPackage.getAllResources();
                for (String s : resources) {
                    JavaResourceContext cnc = new JavaResourceContext();
                    ret.add(rf.classNameToResource(s, cnc));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (File f : FileUtilities.allFilesInDirs(this.getSourceFolders())) {
            String className = FileUtilities.getClassName(f, this.getSourceFolders());
            JavaResourceContext context = JavaResourceContextFactory.getResourceContext(this, className);
            ret.add(rf.classNameToResource(className, context));
        }
        return ret;
    }

    @Override
    public Collection<Resource> getUnusedResources(String entryPoint) {
        Collection<Resource> usedResources = this.getUsedResources(entryPoint);
        Collection<Resource> allResources = this.getAllResources();
        allResources.removeAll(usedResources);
        HashSet<Resource> unusedResources = new HashSet<Resource>(allResources);
        for (Resource usedResource : usedResources) {
            if (!usedResource.getName().endsWith(".*")) continue;
            for (Resource resource : allResources) {
                if (!resource.getName().startsWith(usedResource.getName().replace(".*", ""))) continue;
                unusedResources.remove(resource);
            }
        }
        return unusedResources;
    }

    public Collection<JavaResourceProjectClass> getClassesWithMainMethod() {
        HashSet<JavaResourceProjectClass> mainClasses = new HashSet<JavaResourceProjectClass>();
        List<File> files = FileUtilities.allFilesInDirs(this.getSourceFolders());
        for (File f : files) {
            HasMainMethodVisitor hmmv = new HasMainMethodVisitor();
            CompilationUnit cu = null;
            try {
                cu = JavaParser.parse((File)f);
            }
            catch (ParseException parseException) {
            }
            catch (IOException iOException) {}
            if (cu == null) continue;
            hmmv.visit(cu, null);
            if (!hmmv.hasMainMethod()) continue;
            mainClasses.add(new JavaResourceProjectClass(FileUtilities.getClassName(f, this.getSourceFolders()), null, null));
        }
        return mainClasses;
    }

    @Override
    public void removeResources(Collection<Resource> resources) {
        HashSet<JavaResource> javaResources = new HashSet<JavaResource>();
        for (Resource r : resources) {
            javaResources.add((JavaResource)r);
        }
        for (JavaPackage jp : this.getReferencedPackages()) {
            jp.removeResources(javaResources);
        }
        for (JavaResource jr : javaResources) {
            jr.delete();
        }
    }

    public void setReflectionUsed(boolean b) {
        this._reflectionUsed = b;
    }

    public boolean isReflectionUsed() {
        return this._reflectionUsed;
    }

    public String extractResourceNameFromFileName(String fileName) {
        for (String s : this.getSourceFolders()) {
            if (!fileName.startsWith(s)) continue;
            return fileName.replace(String.valueOf(s) + File.separatorChar, "").replace(".java", "").replace(File.separatorChar, '.');
        }
        return "";
    }
}

