/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.resourceparser.classparser;

import jadean.dean.Resource;
import jadean.dean.exceptions.ResourceIOException;
import jadean.dean.exceptions.ResourceInvalidException;
import jadean.dean.exceptions.ResourceNotFoundException;
import jadean.dean.java.resourceparser.JavaResourceParser;
import jadean.dean.java.resourceparser.classparser.ClassResourceFilter;
import jadean.dean.java.resourceparser.classparser.ClassResourceUtilities;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfo;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoClass;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoDouble;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoFieldRef;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoFloat;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoInteger;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoInterfaceMethodRef;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoLong;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoMethodRef;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoNameAndType;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoString;
import jadean.dean.java.resourceparser.classparser.cpinfo.CPInfoUTF8;
import jadean.dean.java.resources.JavaResourceContext;
import jadean.dean.java.resources.JavaResourceDefault;
import jadean.dean.java.utilities.DebugUtilities;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassResourceParser
extends JavaResourceParser {
    private DataInput di;
    private InputStream is;
    private String res;
    private int magic;
    private int minor;
    private int major;
    private int constantPoolCount;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfacesCount;
    private int fieldsCount;
    private int methodsCount;
    private int attributesCount;
    private CPInfo[] constantPoolTable;

    public ClassResourceParser(String res) throws ResourceNotFoundException {
        super(res);
        try {
            this.res = res;
            this.is = new FileInputStream(new File(res));
            this.di = new DataInputStream(this.is);
        }
        catch (IOException iOException) {
            throw new ResourceNotFoundException();
        }
    }

    public ClassResourceParser(String res, InputStream is) throws ResourceNotFoundException {
        super(res);
        if (is == null) {
            throw new ResourceNotFoundException();
        }
        this.res = res;
        this.is = is;
        this.di = new DataInputStream(this.is);
    }

    private void debug() {
        System.out.println("magic = " + this.magic);
        System.out.println("minor = " + this.minor);
        System.out.println("major = " + this.major);
        System.out.println("constantPoolCount = " + this.constantPoolCount);
        System.out.println("accessFlags = " + this.accessFlags);
        System.out.println("thisClass = " + this.thisClass);
        System.out.println("superClass = " + this.superClass);
        System.out.println("interfacesCount = " + this.interfacesCount);
        System.out.println("fieldsCount = " + this.fieldsCount);
        System.out.println("methodsCount = " + this.methodsCount);
        System.out.println("attributesCount = " + this.attributesCount);
        DebugUtilities.print(this.constantPoolTable);
    }

    private void parse() throws ResourceIOException, ResourceInvalidException {
        try {
            this.magic = this.di.readInt();
            if (this.magic != -889275714) {
                throw new ResourceInvalidException("MAGIC");
            }
            this.minor = this.di.readUnsignedShort();
            this.major = this.di.readUnsignedShort();
            this.constantPoolCount = this.di.readUnsignedShort();
            this.constantPoolTable = new CPInfo[this.constantPoolCount - 1];
            int i = 0;
            while (i < this.constantPoolCount - 1) {
                CPInfo ci;
                this.constantPoolTable[i] = ci = this.readCPInfo();
                if (ci instanceof CPInfoLong || ci instanceof CPInfoDouble) {
                    ++i;
                }
                ++i;
            }
            this.accessFlags = this.di.readUnsignedShort();
            this.thisClass = this.di.readUnsignedShort();
            this.superClass = this.di.readUnsignedShort();
            this.interfacesCount = this.di.readUnsignedShort();
            this.readInterfaces();
            this.fieldsCount = this.di.readUnsignedShort();
            this.readFields();
            this.methodsCount = this.di.readUnsignedShort();
            this.readMethods();
            this.attributesCount = this.di.readUnsignedShort();
            this.readAttributes(this.attributesCount);
            this.is.close();
        }
        catch (EOFException eOFException) {
            throw new ResourceInvalidException("Invalid format");
        }
        catch (IOException iOException) {
            throw new ResourceIOException();
        }
    }

    private CPInfo readCPInfo() throws EOFException, IOException {
        int tag = this.di.readUnsignedByte();
        switch (tag) {
            case 1: {
                return new CPInfoUTF8(this.di);
            }
            case 3: {
                return new CPInfoInteger(this.di);
            }
            case 4: {
                return new CPInfoFloat(this.di);
            }
            case 5: {
                return new CPInfoLong(this.di);
            }
            case 6: {
                return new CPInfoDouble(this.di);
            }
            case 7: {
                return new CPInfoClass(this.di);
            }
            case 8: {
                return new CPInfoString(this.di);
            }
            case 9: {
                return new CPInfoFieldRef(this.di);
            }
            case 10: {
                return new CPInfoMethodRef(this.di);
            }
            case 11: {
                return new CPInfoInterfaceMethodRef(this.di);
            }
            case 12: {
                return new CPInfoNameAndType(this.di);
            }
        }
        return null;
    }

    private void readInterfaces() throws EOFException, IOException {
        int i = 0;
        while (i < this.interfacesCount) {
            this.di.readUnsignedShort();
            ++i;
        }
    }

    private void readFields() throws EOFException, IOException {
        int i = 0;
        while (i < this.fieldsCount) {
            this.di.readUnsignedShort();
            this.di.readUnsignedShort();
            this.di.readUnsignedShort();
            int attributesCount = this.di.readUnsignedShort();
            this.readAttributes(attributesCount);
            ++i;
        }
    }

    private void readMethods() throws EOFException, IOException {
        int i = 0;
        while (i < this.methodsCount) {
            this.di.readUnsignedShort();
            this.di.readUnsignedShort();
            this.di.readUnsignedShort();
            int attributesCount = this.di.readUnsignedShort();
            this.readAttributes(attributesCount);
            ++i;
        }
    }

    private void readAttributes(int j) throws EOFException, IOException {
        int i = 0;
        while (i < j) {
            this.di.readUnsignedShort();
            int k = this.di.readInt();
            int l = 0;
            while (l < k) {
                this.di.readUnsignedByte();
                ++l;
            }
            ++i;
        }
    }

    @Override
    public Collection<Resource> getReferencedResources() throws ResourceIOException, ResourceInvalidException {
        this.parse();
        HashSet<Resource> a = new HashSet<Resource>();
        int ib = this.res.lastIndexOf(File.separatorChar);
        if (ib < 0) {
            ib = 0;
        }
        ClassResourceFilter rf = new ClassResourceFilter(this.res.substring(ib));
        int i = 0;
        while (i < this.constantPoolTable.length) {
            JavaResourceContext cnc;
            CPInfoClass cpic;
            CPInfoUTF8 cpiu;
            String s;
            if (this.constantPoolTable[i] instanceof CPInfoClass && rf.accept(new JavaResourceDefault(s = ClassResourceUtilities.formatClass((cpiu = (CPInfoUTF8)this.constantPoolTable[(cpic = (CPInfoClass)this.constantPoolTable[i]).getIndex() - 1]).getData()), cnc = new JavaResourceContext()))) {
                a.add(new JavaResourceDefault(s, cnc));
            }
            ++i;
        }
        return a;
    }

    private boolean isReflectionCall(String className, String methodName) {
        return className.equals("java/lang/Class") && methodName.equals("forName") || className.equals("java/lang/Class") && methodName.equals("getSuperClass") || className.equals("java/lang/Class") && methodName.equals("getClasses") || className.equals("java/lang/Class") && methodName.equals("getDeclaredClasses") || className.equals("java/lang/Class") && methodName.equals("getEnclosingClass") || className.equals("java/lang/Class") && methodName.equals("getDeclaringClasses") || className.equals("java/lang/reflect/Field") && methodName.equals("getDeclaringClass") || className.equals("java/lang/reflect/Method") && methodName.equals("getDeclaringClass") || className.equals("java/lang/reflect/Constructor") && methodName.equals("getDeclaringClass");
    }

    @Override
    public boolean isReflectionUsed() {
        CPInfo[] cPInfoArray = this.constantPoolTable;
        int n = this.constantPoolTable.length;
        int n2 = 0;
        while (n2 < n) {
            CPInfo cpInfo = cPInfoArray[n2];
            if (cpInfo instanceof CPInfoMethodRef) {
                CPInfoMethodRef methodRef = (CPInfoMethodRef)cpInfo;
                CPInfoClass infoClass = (CPInfoClass)this.constantPoolTable[methodRef.getClassIndex() - 1];
                CPInfoNameAndType infoNameAndType = (CPInfoNameAndType)this.constantPoolTable[methodRef.getNameAndTypeIndex() - 1];
                CPInfoUTF8 classNameUTF8 = (CPInfoUTF8)this.constantPoolTable[infoClass.getIndex() - 1];
                CPInfoUTF8 methodNameUTF8 = (CPInfoUTF8)this.constantPoolTable[infoNameAndType.getNameIndex() - 1];
                if (this.isReflectionCall(classNameUTF8.getData(), methodNameUTF8.getData())) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }
}

