/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.resourceparser.jarparser;

import jadean.dean.java.JavaPackage;
import jadean.dean.java.resourceparser.jarparser.JarEntryFilter;
import jadean.dean.java.resourceparser.jarparser.JarEntryFormatter;
import jadean.dean.java.utilities.FileUtilities;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarResourceUtilities {
    public static InputStream getInputStreamForEntry(String jarRes, String className) throws IOException {
        String entry = String.valueOf(className.replace('.', '/')) + ".class";
        JarFile jf = new JarFile(jarRes);
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (!je.getName().equals(entry)) continue;
            InputStream is = jf.getInputStream(je);
            return is;
        }
        jf.close();
        return null;
    }

    public static List<String> listFiles(String jarRes, JarEntryFilter jefi, JarEntryFormatter jeft) throws IOException {
        JarFile jf = new JarFile(jarRes);
        Enumeration<JarEntry> e = jf.entries();
        ArrayList<String> a = new ArrayList<String>();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (!jefi.accept(je)) continue;
            a.add(jeft.format(je));
        }
        jf.close();
        return a;
    }

    public static HashMap<JavaPackage, List<String>> listFiles(List<JavaPackage> jarRes, JarEntryFilter jefi, JarEntryFormatter jeft) throws IOException {
        HashMap<JavaPackage, List<String>> ret = new HashMap<JavaPackage, List<String>>();
        for (JavaPackage p : jarRes) {
            ret.put(p, JarResourceUtilities.listFiles(p.getPath(), jefi, jeft));
        }
        return ret;
    }

    public static void removeEntries(String jarFileName, ArrayList<String> entriesToDelete) throws IOException {
        String sourceJarFileName = jarFileName;
        String destinationJarFileName = String.valueOf(jarFileName) + ".tmp";
        JarResourceUtilities.copyUndeletedEntries(entriesToDelete, sourceJarFileName, destinationJarFileName);
        FileUtilities.renameTo(destinationJarFileName, sourceJarFileName);
    }

    public static void deleteEmptyFolders(String jarFileName) throws IOException {
        JarFile jarFile = new JarFile(jarFileName);
        Enumeration<JarEntry> e = jarFile.entries();
        HashSet<String> dirEntries = new HashSet<String>();
        HashSet<String> fileEntries = new HashSet<String>();
        while (e.hasMoreElements()) {
            JarEntry je = e.nextElement();
            if (je.isDirectory()) {
                dirEntries.add(je.getName());
                continue;
            }
            fileEntries.add(je.getName());
        }
        jarFile.close();
        HashSet<String> entriesToDelete = new HashSet<String>();
        ArrayList sortedDirEntries = new ArrayList(dirEntries);
        Collections.sort(sortedDirEntries, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                if (arg0.length() < arg1.length()) {
                    return -1;
                }
                if (arg0.length() > arg1.length()) {
                    return 1;
                }
                return 0;
            }
        });
        for (String dir : sortedDirEntries) {
            if (entriesToDelete.contains(dir)) continue;
            JarResourceUtilities.deleteDir(dir, dirEntries, fileEntries, entriesToDelete);
        }
        JarResourceUtilities.removeEntries(jarFileName, new ArrayList<String>(entriesToDelete));
    }

    private static void deleteDir(String dir, Set<String> dirs, Set<String> files, Set<String> deletedDirs) {
        if (JarResourceUtilities.isEmptyDir(dir, dirs, files)) {
            deletedDirs.add(dir);
        } else if (!JarResourceUtilities.containsDirFiles(dir, files)) {
            for (String _dir : JarResourceUtilities.getDirsInDir(dir, dirs)) {
                JarResourceUtilities.deleteDir(_dir, dirs, files, deletedDirs);
            }
            boolean allDirsDeleted = true;
            for (String _dir : JarResourceUtilities.getDirsInDir(dir, dirs)) {
                allDirsDeleted &= deletedDirs.contains(_dir);
            }
            if (allDirsDeleted) {
                deletedDirs.add(dir);
            }
        }
    }

    private static boolean isEmptyDir(String dir, Set<String> dirs, Set<String> files) {
        boolean isEmpty = true;
        for (String _dir : dirs) {
            if (!_dir.startsWith(dir) || _dir.equals(dir)) continue;
            isEmpty = false;
        }
        for (String _file : files) {
            if (!_file.startsWith(dir)) continue;
            isEmpty = false;
        }
        return isEmpty;
    }

    private static boolean containsDirFiles(String dir, Set<String> files) {
        boolean isEmpty = false;
        for (String _file : files) {
            if (!_file.startsWith(dir)) continue;
            isEmpty = true;
        }
        return isEmpty;
    }

    private static Set<String> getDirsInDir(String dir, Set<String> dirs) {
        HashSet<String> ret = new HashSet<String>();
        for (String _dir : dirs) {
            if (!_dir.startsWith(dir) || _dir.equals(dir) || _dir.replace(dir, "").split("/").length != 2) continue;
            ret.add(_dir);
        }
        return ret;
    }

    public static boolean isEntryInList(JarEntry je, ArrayList<String> entriesToDelete) {
        for (String s : entriesToDelete) {
            if (!je.getName().equals(s) && !je.getName().matches(String.valueOf(s.replace('.', '/').replace("\\", "\\\\")) + "(\\$.+)*\\.class")) continue;
            return true;
        }
        return false;
    }

    public static void copyUndeletedEntries(ArrayList<String> entriesToDelete, String sourceJarFileName, String destinationJarFileName) throws IOException {
        JarFile sourceJarFile = new JarFile(sourceJarFileName);
        JarOutputStream destinationJarFile = new JarOutputStream(new FileOutputStream(destinationJarFileName));
        Enumeration<JarEntry> e = sourceJarFile.entries();
        while (e.hasMoreElements()) {
            int bytesRead;
            JarEntry je = e.nextElement();
            byte[] buffer = new byte[1024];
            boolean delete = JarResourceUtilities.isEntryInList(je, entriesToDelete);
            if (delete) continue;
            InputStream entryStream = sourceJarFile.getInputStream(je);
            destinationJarFile.putNextEntry(je);
            while ((bytesRead = entryStream.read(buffer)) != -1) {
                destinationJarFile.write(buffer, 0, bytesRead);
            }
            entryStream.close();
        }
        sourceJarFile.close();
        destinationJarFile.close();
    }

    /*
     * Loose catch block
     */
    public static List<String> getClassPathPackages(String jarFileName) {
        if (!JarResourceUtilities.hasClassPathPackages(jarFileName)) {
            return new ArrayList<String>();
        }
        JarFile jarFile = null;
        String absolutePath = new File(jarFileName).getAbsolutePath();
        String jarPath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separatorChar));
        ArrayList<String> classPathPackages = new ArrayList<String>();
        jarFile = new JarFile(jarFileName);
        Manifest manifest = jarFile.getManifest();
        String classPathAttribute = manifest.getMainAttributes().getValue("Class-Path");
        StringTokenizer tokenizer = new StringTokenizer(classPathAttribute);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken();
            classPathPackages.add(String.valueOf(jarPath) + File.separatorChar + token.replace('/', File.separatorChar));
        }
        ArrayList<String> arrayList = classPathPackages;
        try {
            jarFile.close();
        }
        catch (Exception exception) {}
        return arrayList;
        catch (IOException iOException) {
            ArrayList<String> arrayList2;
            try {
                arrayList2 = new ArrayList<String>();
            }
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                jarFile.close();
            }
            catch (Exception exception) {}
            return arrayList2;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean hasClassPathPackages(String jarFileName) {
        JarFile jarFile = null;
        jarFile = new JarFile(jarFileName);
        Manifest manifest = jarFile.getManifest();
        String classPathAttribute = manifest.getMainAttributes().getValue("Class-Path");
        boolean bl = classPathAttribute != null;
        try {
            jarFile.close();
        }
        catch (Exception exception) {}
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                jarFile.close();
            }
            catch (Exception exception) {}
            return false;
        }
    }
}

