/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.resourceparser.javaparser;

import jadean.dean.Resource;
import jadean.dean.exceptions.ResourceIOException;
import jadean.dean.exceptions.ResourceInvalidException;
import jadean.dean.exceptions.ResourceNotFoundException;
import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.JavaResourceParser;
import jadean.dean.java.resourceparser.javaparser.JavaSourceResourceFilter;
import jadean.dean.java.resourceparser.javaparser.visitors.GetReferencedClassesVisitor;
import jadean.dean.java.resourceparser.javaparser.visitors.IsReflectionUsedVisitor;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSourceResourceParser
extends JavaResourceParser {
    private FileInputStream javaSourceFile;

    public JavaSourceResourceParser(String javaSourceFileName) throws ResourceNotFoundException {
        super(javaSourceFileName);
        try {
            this.javaSourceFile = new FileInputStream(javaSourceFileName);
        }
        catch (IOException iOException) {
            throw new ResourceNotFoundException();
        }
    }

    @Override
    public Collection<Resource> getReferencedResources() throws ResourceIOException, ResourceInvalidException {
        try {
            CompilationUnit sourceFileCompilationUnit = JavaParser.parse((InputStream)this.javaSourceFile);
            GetReferencedClassesVisitor sourceFileVisitor = new GetReferencedClassesVisitor();
            sourceFileVisitor.visit(sourceFileCompilationUnit, null);
            HashSet<JavaResource> referencedClasses = sourceFileVisitor.getReferencedClasses();
            JavaSourceResourceFilter resourceFilter = new JavaSourceResourceFilter();
            HashSet<Resource> resourcesSet = new HashSet<Resource>();
            for (JavaResource referencedClass : referencedClasses) {
                if (!resourceFilter.accept(referencedClass)) continue;
                resourcesSet.add(referencedClass);
            }
            return resourcesSet;
        }
        catch (ParseException parseException) {
            throw new ResourceInvalidException("PARSE");
        }
    }

    @Override
    public boolean isReflectionUsed() {
        try {
            CompilationUnit sourceFileCompilationUnit = JavaParser.parse((InputStream)this.javaSourceFile);
            IsReflectionUsedVisitor isReflectionUsedVisitor = new IsReflectionUsedVisitor();
            isReflectionUsedVisitor.visit(sourceFileCompilationUnit, null);
            return isReflectionUsedVisitor.isReflectionUsed();
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

