/*
 * Decompiled with CFR 0.152.
 */
package jadean.dean.java.resources;

import jadean.dean.Resource;
import jadean.dean.exceptions.ResourceIOException;
import jadean.dean.exceptions.ResourceInvalidException;
import jadean.dean.exceptions.ResourceNotFoundException;
import jadean.dean.java.JavaPackage;
import jadean.dean.java.JavaProject;
import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.JavaResourceParser;
import jadean.dean.java.resourceparser.classparser.ClassResourceParser;
import jadean.dean.java.resourceparser.javaparser.JavaSourceResourceParser;
import jadean.dean.java.resources.JavaResourceContext;
import jadean.dean.java.resources.JavaResourceFactory;
import jadean.dean.java.resources.JavaResourceProjectResource;
import jadean.dean.java.utilities.FileUtilities;
import jadean.dean.java.utilities.ProjectUtilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaResourceProjectClass
extends JavaResourceProjectResource {
    public JavaResourceProjectClass(String name, JavaResourceContext context, JavaProject p) {
        super(name, context, p);
    }

    @Override
    public Collection<Resource> getReferrencedResources() {
        try {
            String fileName = FileUtilities.findInDirs(this.getProject().getSourceFolders(), String.valueOf(this.getName().replace('.', File.separatorChar)) + ".java");
            JavaResourceParser jrp = null;
            jrp = fileName == null ? new ClassResourceParser(String.valueOf(this.getProject().getOutputFolder()) + this.getName().replace('.', File.separatorChar) + ".java") : new JavaSourceResourceParser(fileName);
            Collection<Resource> s = jrp.getReferencedResources();
            ArrayList<Resource> ret = new ArrayList<Resource>();
            JavaResourceFactory rf = new JavaResourceFactory(this.getProject());
            for (Resource resource : s) {
                JavaResource javaResource = (JavaResource)resource;
                ret.add(rf.classNameToResource(javaResource.getName(), javaResource.getContext()));
            }
            if (jrp.isReflectionUsed()) {
                this.getProject().setReflectionUsed(true);
            }
            return ProjectUtilities.deDuplicateResources(ProjectUtilities.normalizeResources(ret, this.getProject()));
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return new ArrayList<Resource>();
        }
        catch (ResourceIOException resourceIOException) {
            return new ArrayList<Resource>();
        }
        catch (ResourceInvalidException resourceInvalidException) {
            return new ArrayList<Resource>();
        }
    }

    @Override
    public JavaPackage getPackageForResource() {
        return null;
    }

    @Override
    public void delete() {
        File classFile = new File(FileUtilities.findInDirs(this.getProject().getSourceFolders(), String.valueOf(this.getName().replace('.', File.separatorChar)) + ".java"));
        classFile.delete();
    }
}

